<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:user="http://www.yisence.com/" exclude-result-prefixes="msxsl user">
  <xsl:variable name="baseInfoDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/webBaseInfo', '.xml'))"/>
  <xsl:variable name="baseInfo" select="$baseInfoDoc/web_baseinfo"/>
  <xsl:template name="import_topcountbar">
    <li class="color t1">
      <a href="#" onclick="javascript:setHomePage('{$baseInfo/websiteurl}');"><xsl:value-of select="//pagemodules/sethomepage"/></a>
    </li>
    <li class="color t2">
      <a href="#" onclick="javascript:addFavorite('{$baseInfo/websiteurl}','{$baseInfo/webname}');"><xsl:value-of select="//pagemodules/addfavorite"/></a>
    </li>
  </xsl:template>
  <xsl:variable name="rotationBgDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/webRotationBg', '.xml'))"/>
  <xsl:variable name="rotationBg" select="$rotationBgDoc/web_rotationbg"/>
  <xsl:template name="import_chgbackground">
    <xsl:if test="$rotationBg!=''">
      <div class="m_background">
        <xsl:for-each select="$rotationBg/rbgitems">
          <span onclick="chgobj_thebg({position()})">
            <img src="{rbgfileurl}" alt="{rbgtopic}"/>
          </span>
        </xsl:for-each>
      </div>
      <script type="text/javascript">
        var bg_obj="main_container";
        var theimgs=new Array();
        var bg_type=0;
        var rotation_time=6000;
        <xsl:for-each select="$rotationBg/rbgitems">
          theimgs[<xsl:value-of select="position()-1"/>]=&quot;<xsl:value-of select="rbgfileurl" disable-output-escaping="yes"/>&quot;;
        </xsl:for-each>
        if(window.attachEvent)
        {
        window.attachEvent('onload',auto_chgbg);
        }
        else if(window.addEventListener)
        {
        window.addEventListener('load',auto_chgbg,false);
        }
      </script>
    </xsl:if>
  </xsl:template>
  <xsl:template name="import_othernavbar0">
    <xsl:choose>
      <xsl:when test="//indexsingles/service/@singleshort!=''">
        <xsl:value-of select="//indexsingles/service" disable-output-escaping="yes"/>
      </xsl:when>
      <xsl:otherwise>
        <a title="请在网站“图文信息管理”添加(单图文信息标识为：service)的信息标识并填写内容！">service</a>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="import_othernavbar">
    <xsl:choose>
      <xsl:when test="//indexsingles/zhuce/@singleshort!=''">
        <div class="check">
          <a href="{//indexsingles/zhuce/@singleurl}"><xsl:value-of select="//indexsingles/zhuce/@singleshort"/></a>
        </div>
      </xsl:when>
      <xsl:otherwise>
        <div class="check" style="display: none;">
        </div>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>