<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="MainMenuDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/webMainMenu', '.xml'))"/>
  <xsl:variable name="webMainMenu" select="$MainMenuDoc/web_mainmenu"/>
  <xsl:template name="import_mainmenubar">
    <xsl:param name="pIndexVar" select="//nowpagetitle/@pindexvar"/>
    <xsl:param name="parentId" select="0"/>
    <xsl:param name="limainMenuClass" select="'ulmainmenu_li'"/>
    <xsl:param name="amainMenuClass" select="'mainmenu_a'"/>
    <xsl:param name="activeMenuClass" select="'activemenu'"/>
    <xsl:element name="div">
      <xsl:if test="$parentId=0">
        <xsl:attribute name="class">
          <xsl:value-of select="'mainmenu_rtul'"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:for-each select="$webMainMenu/menuitem[@parentid=$parentId]">
        <xsl:choose>
          <xsl:when test="$parentId=0">
            <xsl:if test="position() &lt;=9">
              <xsl:if test="@subsortnum &gt; '0'">
                <span onmouseover="MM_showHideLayers_2('mmenu_{position()}','mmenu_','show','{last()}')" onmouseout="MM_showHideLayers('mmenu_{position()}','','hide')">
                  <xsl:if test="$limainMenuClass!=''">
                    <xsl:attribute name="class">
                      <xsl:value-of select="$limainMenuClass"/>
                    </xsl:attribute>
                  </xsl:if>
                  <xsl:element name="a">
                    <xsl:attribute name="id">menua_<xsl:value-of select="@menuid"/>
                    </xsl:attribute>
                    <xsl:if test="$pIndexVar!=@pindexvar">
                      <xsl:attribute name="class">
                        <xsl:value-of select="$amainMenuClass"/>
                      </xsl:attribute>
                    </xsl:if>
                    <xsl:if test="$pIndexVar=@pindexvar">
                      <xsl:attribute name="class">
                        <xsl:value-of select="$activeMenuClass"/>
                      </xsl:attribute>
                    </xsl:if>
                    <xsl:attribute name="href">
                      <xsl:value-of select="@urlpath"/>
                    </xsl:attribute>
                    <xsl:value-of select="."/>
                    <xsl:if test="@urltarget=''">
                      <xsl:attribute name="target">
                        <xsl:value-of select="@urltarget"/>
                      </xsl:attribute>
                    </xsl:if>
                  </xsl:element>
                  <div id="mmenu_{position()}" onmouseover="MM_showHideLayers_2('mmenu_{position()}','mmenu_','show','{last()}')" onmouseout="MM_showHideLayers('mmenu_{position()}','','hide')" class="sub_mainmenudiv">
                    <xsl:attribute name="style">
                      <xsl:value-of select="'visibility: hidden;'"/>
                    </xsl:attribute>
                    <xsl:call-template name="import_mainmenubar">
                      <xsl:with-param name="parentId" select="@menuid"/>
                      <xsl:with-param name="limainMenuClass"/>
                      <xsl:with-param name="amainMenuClass" select="'other_amenu'"/>
                    </xsl:call-template>
                  </div>
                </span>
                <xsl:if test="position() &lt; last() and position() &lt;9">
                  <span class="split_memu"></span>
                </xsl:if>
              </xsl:if>
              <xsl:if test="@subsortnum = '0'">
                <span>
                  <xsl:if test="$limainMenuClass!=''">
                    <xsl:attribute name="class">
                      <xsl:value-of select="$limainMenuClass"/>
                    </xsl:attribute>
                  </xsl:if>
                  <xsl:element name="a">
                    <xsl:if test="$pIndexVar!=@pindexvar">
                      <xsl:attribute name="class">
                        <xsl:value-of select="$amainMenuClass"/>
                      </xsl:attribute>
                    </xsl:if>
                    <xsl:if test="$pIndexVar=@pindexvar">
                      <xsl:attribute name="class">
                        <xsl:value-of select="$activeMenuClass"/>
                      </xsl:attribute>
                    </xsl:if>
                    <xsl:attribute name="href">
                      <xsl:value-of select="@urlpath"/>
                    </xsl:attribute>
                    <xsl:value-of select="."/>
                    <xsl:if test="@urltarget=''">
                      <xsl:attribute name="target">
                        <xsl:value-of select="@urltarget"/>
                      </xsl:attribute>
                    </xsl:if>
                  </xsl:element>
                </span>
                <xsl:if test="position() &lt; last() and position() &lt;9">
                  <span class="split_memu"></span>
                </xsl:if>
              </xsl:if>
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>
            <span>
              <xsl:if test="$limainMenuClass!=''">
                <xsl:attribute name="class">
                  <xsl:value-of select="$limainMenuClass"/>
                </xsl:attribute>
              </xsl:if>
              <xsl:element name="a">
                <xsl:if test="$amainMenuClass!=''">
                  <xsl:attribute name="class">
                    <xsl:value-of select="$amainMenuClass"/>
                  </xsl:attribute>
                </xsl:if>
                <xsl:attribute name="href">
                  <xsl:value-of select="@urlpath"/>
                </xsl:attribute>
                <xsl:value-of select="."/>
                <xsl:if test="@urltarget=''">
                  <xsl:attribute name="target">
                    <xsl:value-of select="@urltarget"/>
                  </xsl:attribute>
                </xsl:if>
              </xsl:element>
            </span>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
</xsl:stylesheet>