﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="nmIndexTopDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/nmIsIndexList', '.xml'))"/>
  <xsl:variable name="nmIsIndexTop" select="$nmIndexTopDoc/nmindextoplists"/>
  <xsl:variable name="indexSortDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/indexSortList', '.xml'))"/>
  <xsl:variable name="indexSortList" select="$indexSortDoc/indexsortlist"/>
  <xsl:template name="import_isindextop_article">
    <xsl:param name="productPriceUnit" select="//pagemodules/price_unit"/>
    <xsl:param name="productSellUnitTit" select="//pagemodules/sell_unittit"/>
    <xsl:param name="nmIndexVar" select="'article'" />
    <xsl:param name="nmIsTopItem" select="$nmIsIndexTop/indextoplistitem[@mindexvar=$nmIndexVar]"/>
    <xsl:choose>
      <xsl:when test="$nmIsTopItem!=''">
        <dl class="i_n_text">
          <xsl:for-each select="$nmIsTopItem/viewitem">
            <xsl:if test="position()&lt;2">
              <dt>
                <a href="{urlpath}"><img src="{viewimage}" title="{viewtopic}"/></a>
              </dt>
              <dd>
                <strong><a href="{urlpath}" title="{viewtopic}"><xsl:value-of select="viewtopic" /></a></strong>
              </dd>
              <h4>
                <xsl:value-of select="viewinfos" />
              </h4>
            </xsl:if>
          </xsl:for-each>
        </dl>
        <div class="nlist">
          <ul>
            <xsl:for-each select="$nmIsTopItem/viewitem">
              <xsl:if test="position()&lt;8 and position()&gt; 1">
                <li>
                  <a href="{urlpath}" title="{viewtopic}"><xsl:value-of select="viewtopic" /></a>
                </li>
              </xsl:if>
            </xsl:for-each>
          </ul>
        </div>
      </xsl:when>
      <xsl:otherwise>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="import_isindextop_articletitle">
    <xsl:param name="productPriceUnit" select="//pagemodules/price_unit"/>
    <xsl:param name="productSellUnitTit" select="//pagemodules/sell_unittit"/>
    <xsl:param name="nmIndexVar" select="'articletitle'"/>
    <xsl:param name="nmIsTopItem" select="$nmIsIndexTop/indextoplistitem[@mindexvar=$nmIndexVar]"/>
    <xsl:choose>
      <xsl:when test="$nmIsTopItem!=''">
        <a id="nsmenuid_2" onmouseover="changetab_objdiv('nsmenuid_','nsremark_',2,2,'activetab','')" href="{$nmIsTopItem/@menuurl}">
          <xsl:value-of select="$nmIsTopItem/@menushort"/>
        </a>
      </xsl:when>
      <xsl:otherwise>
        <div title="请在网站“菜单管理”添加(标识栏目参数为 article 的菜单栏目！">article</div>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>