<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="gbookSortDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/gbookSortList', '.xml'))"/>
  <xsl:variable name="gbookSortList" select="$gbookSortDoc/gbooksortlist"/>
  <xsl:template name="import_gbooksortbar">
    <xsl:param name="parentId" select="0"/>
    <xsl:param name="sortUlClass" select="'ullist_sortnav'"/>
    <xsl:element name="ul">
      <xsl:if test="$sortUlClass!=''">
        <xsl:attribute name="class">
          <xsl:value-of select="$sortUlClass"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:for-each select="$gbookSortList/sortitem[@parentid=$parentId]">
        <xsl:if test="@subsortnum &gt; '0'">
          <li class="p_s_li1" onmouseover="startlist(this,1);" onmouseout="startlist(this,0);">
            <xsl:element name="a">
              <xsl:attribute name="href">
                <xsl:value-of select="@urlpath"/>
              </xsl:attribute>
              <xsl:attribute name="class">
                <xsl:value-of select="'p_s_li1_a'"/>
              </xsl:attribute>
              <xsl:value-of select="@sorttopic"/>
              <xsl:if test="@urltarget=''">
                <xsl:attribute name="target">
                  <xsl:value-of select="@urltarget"/>
                </xsl:attribute>
              </xsl:if>
            </xsl:element>
            <div style="display: none;">
              <xsl:choose>
                <xsl:when test="@sortstarnum &lt; 1">
                  <xsl:attribute name="class">
                    <xsl:value-of select="'p_s_li_div0'"/>
                  </xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:attribute name="class">
                    <xsl:value-of select="'p_s_li_div1'"/>
                  </xsl:attribute>
                </xsl:otherwise>
              </xsl:choose>
              <xsl:call-template name="import_gbooksortbar">
                <xsl:with-param name="parentId" select="@sortid"/>
                <xsl:with-param name="sortUlClass"/>
              </xsl:call-template>
            </div>
          </li>
        </xsl:if>
        <xsl:if test="@subsortnum = '0'">
          <li class="p_s_li0">
            <xsl:element name="a">
              <xsl:attribute name="href">
                <xsl:value-of select="@urlpath"/>
              </xsl:attribute>
              <xsl:attribute name="class">
                <xsl:value-of select="'p_s_li0_a'"/>
              </xsl:attribute>
              <xsl:value-of select="@sorttopic"/>
              <xsl:if test="@urltarget=''">
                <xsl:attribute name="target">
                  <xsl:value-of select="@urltarget"/>
                </xsl:attribute>
              </xsl:if>
            </xsl:element>
          </li>
        </xsl:if>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
</xsl:stylesheet>