<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:template name="import_nmdefined01">
    <xsl:variable name="definedsItem" select="//userdefineds/definedsitem[@definedkeys='definedkeys_1']"/>
    <xsl:if test="$definedsItem!=''">
      <div class="i_left">
        <div class="i_u_def1">
          <div>
            <img src="/templates/images/t1.gif" />
          </div>
          <xsl:if test="$definedsItem/@definedtype=0">
            <div class="i_u_cont1">
              <xsl:value-of select="$definedsItem" disable-output-escaping="yes"/>
            </div>
          </xsl:if>
          <xsl:if test="$definedsItem/@definedtype=1">
            <ul class="i_u_list1">
              <xsl:for-each select="$definedsItem/singleitem">
                <xsl:if test="position()&lt;9">
                  <li>
                    <a href="{urlpath}" title="{itemtopic}"><xsl:value-of select="itemtopic"/></a>
                  </li>
                </xsl:if>
              </xsl:for-each>
            </ul>
          </xsl:if>
          <div>
            <img src="/templates/images/bot1.gif" />
          </div>
        </div>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template name="import_nmdefined02">
    <xsl:variable name="definedsItem" select="//userdefineds/definedsitem[@definedkeys='definedkeys_2']"/>
    <xsl:if test="$definedsItem!=''">
      <div class="i_n_list">
        <div class="i_n_t clearfix">
          <ul class="n1">
            <li>
              <a href="{$definedsItem/@moreurl}"><xsl:value-of select="$definedsItem/@definedtopic"/></a>
            </li>
          </ul>
          <ul class="n2">
            <li class="color">
              <a href="{$definedsItem/@moreurl}"><xsl:value-of select="//pagemodules/view_more"/></a>
            </li>
          </ul>
          <div class="clear"></div>
          <xsl:if test="$definedsItem/@definedtype=0">
            <div class="i_u_cont2">
              <xsl:value-of select="$definedsItem" disable-output-escaping="yes"/>
            </div>
          </xsl:if>
          <xsl:if test="$definedsItem/@definedtype=1">
            <ul class="i_u_list2">
              <xsl:for-each select="$definedsItem/singleitem">
                <li>
                  <a href="{urlpath}" title="{itemtopic}"><xsl:value-of select="itemtopic"/></a>
                  <span><xsl:value-of select="itemtime"/></span>
                </li>
              </xsl:for-each>
            </ul>
          </xsl:if>
        </div>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template name="import_nmdefined03">
    <xsl:variable name="definedsItem" select="//userdefineds/definedsitem[@definedkeys='definedkeys_3']"/>
    <xsl:if test="$definedsItem!=''">
      <div class="i_rig">
        <dl>
          <dt>
            <xsl:value-of select="$definedsItem/@definedtopic"/>
          </dt>
          <dd class="color">
            <a href="{$definedsItem/@moreurl}"><xsl:value-of select="//pagemodules/view_more"/></a>
          </dd>
        </dl>
        <xsl:if test="$definedsItem/@definedtype=0">
          <div class="i_u_cont3">
            <xsl:value-of select="$definedsItem" disable-output-escaping="yes"/>
          </div>
        </xsl:if>
        <xsl:if test="$definedsItem/@definedtype=1">
          <ul class="i_u_list3">
            <xsl:for-each select="$definedsItem/singleitem">
              <li>
                <a href="{urlpath}" title="{itemtopic}"><xsl:value-of select="itemtopic"/></a>
              </li>
            </xsl:for-each>
          </ul>
        </xsl:if>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template name="import_nmdefined04">
    <xsl:variable name="definedsItem" select="//userdefineds/definedsitem[@definedkeys='definedkeys_4']"/>
    <xsl:if test="$definedsItem!=''">
      <div class="p_u_def">
        <ul class="p_u_topic">
          <li class="top01">
            <xsl:value-of select="$definedsItem/@definedtopic"/>
          </li>
          <li class="top02">
            <a href="{$definedsItem/@moreurl}"><xsl:value-of select="//pagemodules/view_more"/></a>
          </li>
        </ul>
        <xsl:if test="$definedsItem/@definedtype=0">
          <div class="p_u_cont">
            <xsl:value-of select="$definedsItem" disable-output-escaping="yes"/>
          </div>
        </xsl:if>
        <xsl:if test="$definedsItem/@definedtype=1">
          <div id="demo_outer">
            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="i_p_tab">
              <tr>
                <td id="demo_obj1">
                  <table border="0" cellspacing="0" cellpadding="0">
                    <tr>
                      <ul>
                        <xsl:for-each select="$definedsItem/singleitem">
                          <td class="i_p_scroll">
                            <li>
                              <a href="{urlpath}"><img src="{itemimage}" titile="{itemtopic}" class="border" /></a>
                              <span><a href="{urlpath}"><xsl:value-of select="itemtopic" /></a></span>
                            </li>
                          </td>
                        </xsl:for-each>
                      </ul>
                    </tr>
                  </table>
                </td>
                <td id="demo_obj2"></td>
              </tr>
            </table>
          </div>
          <script language="javascript" type="text/javascript">
            var lmove_speed=30;
            demo_obj2.innerHTML=demo_obj1.innerHTML;
            function Marquee(){
            if(demo_obj2.offsetWidth-demo_outer.scrollLeft<xsl:text disable-output-escaping="yes">&lt;</xsl:text>=0){ demo_outer.scrollLeft-=demo_obj1.offsetWidth;}
            else{ demo_outer.scrollLeft++;}
            }
            var MyMar=setInterval(Marquee,lmove_speed);
            demo_outer.onmouseover=function() { clearInterval(MyMar);}
            demo_outer.onmouseout=function() { MyMar=setInterval(Marquee,lmove_speed);}
          </script>
        </xsl:if>
      </div>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>