<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:template name="import_nmdefined01">
    <xsl:variable name="definedsItem" select="//userdefineds/definedsitem[@definedkeys='definedkeys_1']"/>
    <xsl:choose>
      <xsl:when test="$definedsItem!=''">
        <xsl:if test="$definedsItem!=''">
          <div class="i_login">
            <div class="i_u_def1">
              <xsl:if test="$definedsItem/@definedtype=0">
                <div class="i_u_cont1">
                  <xsl:value-of select="$definedsItem" disable-output-escaping="yes"/>
                </div>
              </xsl:if>
              <xsl:if test="$definedsItem/@definedtype=1">
                <ul class="i_u_list1">
                  <xsl:for-each select="$definedsItem/singleitem">
                    <xsl:if test="position()&lt;9">
                      <li>
                        <a href="{urlpath}" title="{itemtopic}">·<xsl:value-of select="itemtopic"/></a>
                      </li>
                    </xsl:if>
                  </xsl:for-each>
                </ul>
              </xsl:if>
            </div>
          </div>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <div class="i_login">
          <div class="i_u_def1">
            <div class="i_u_cont1">"请添加“首页”-“首页扩展区一”即可显示！"</div>
          </div>
        </div>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="import_nmdefined02">
    <xsl:variable name="definedsItem" select="//userdefineds/definedsitem[@definedkeys='definedkeys_2']"/>
    <xsl:if test="$definedsItem!=''">
      <div class="i_u_def1">
        <h1>
          <xsl:value-of select="$definedsItem/@definedtopic"/>
        </h1>
        <xsl:if test="$definedsItem/@definedtype=0">
          <div class="i_u_cont1">
            <xsl:value-of select="$definedsItem" disable-output-escaping="yes"/>
          </div>
        </xsl:if>
        <xsl:if test="$definedsItem/@definedtype=1">
          <ul class="i_u_list1">
            <xsl:for-each select="$definedsItem/singleitem">
              <li>
                <a href="{urlpath}" title="{itemtopic}">·<xsl:value-of select="itemtopic"/></a>
              </li>
            </xsl:for-each>
          </ul>
        </xsl:if>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template name="import_nmdefined03">
    <xsl:variable name="definedsItem" select="//userdefineds/definedsitem[@definedkeys='definedkeys_3']"/>
    <xsl:if test="$definedsItem!=''">
      <div class="i_u_def3">
        <dl class="p_p_t">
          <dt>
            <xsl:value-of select="$definedsItem/@definedtopic"/>
          </dt>
        </dl>
        <div class="clear"></div>
        <div class="p_m_content">
          <xsl:if test="$definedsItem/@definedtype=0">
            <div class="i_u_cont1">
              <xsl:value-of select="$definedsItem" disable-output-escaping="yes"/>
            </div>
          </xsl:if>
          <xsl:if test="$definedsItem/@definedtype=1">
            <ul class="i_u_list3">
              <xsl:for-each select="$definedsItem/singleitem">
                <li>
                  <a href="{urlpath}" title="{itemtopic}">·<xsl:value-of select="itemtopic"/></a>
                  <span><xsl:value-of select="itemtime"/></span>
                </li>
              </xsl:for-each>
            </ul>
          </xsl:if>
        </div>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template name="import_nmdefined04">
    <xsl:variable name="definedsItem" select="//userdefineds/definedsitem[@definedkeys='definedkeys_4']"/>
    <xsl:if test="$definedsItem!=''">
      <div class="p_u_def4">
        <xsl:if test="$definedsItem/@definedtype=0">
          <div class="i_u_cont4">
            <xsl:value-of select="$definedsItem" disable-output-escaping="yes"/>
          </div>
        </xsl:if>
        <xsl:if test="$definedsItem/@definedtype=1">
          <div class="p_rig">
            <ul>
              <xsl:for-each select="$definedsItem/singleitem">
                <li>
                  <a href="{urlpath}"><xsl:value-of select="itemtopic" /></a>
                </li>
                <span><xsl:value-of select="itemviews" disable-output-escaping="yes"/></span>
                <h1>
                  <a href="{urlpath}"><img src="{itemimage}" titile="{itemtopic}"/></a>
                </h1>
                <h2></h2>
              </xsl:for-each>
            </ul>
          </div>
        </xsl:if>
      </div>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>