<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:template match="/">
    <xsl:variable name="currentpage" select="pagerlists/viewpage" />
    <div class="navPage pagebar">
      <ul>
        <xsl:for-each select="pagerlists/pagesview/pagesitem">
          <li>
            <a title="{@pagetit}">
              <xsl:if test="@pageid=string($currentpage)">
                <xsl:attribute name="class">
                  <xsl:value-of select="'pagebarCurrent'" />
                </xsl:attribute>
              </xsl:if>
              <xsl:if test="@pageurl!=''">
                <xsl:attribute name="href">
                  <xsl:value-of select="@pageurl" />
                </xsl:attribute>
              </xsl:if>
              <xsl:value-of select="." />
            </a>
          </li>
        </xsl:for-each>
      </ul>
    </div>
  </xsl:template>
</xsl:stylesheet>