﻿/*
功能说明：延迟加载图片
作者：牛商网戴家塔
参数：
threshold:提前加载
autoLoad:是否自动
autoLoadTime:自动加载间隔时间
event:触发事件
effect:图片的加载效果
attr:真实图片路径属性
autoCount:自动加载整屏数，默认为0（此项无须设置）
container:容器
调用方法：*/
$(function () {
	$("img").lazyload({
	    placeholder: "/images/grey.gif", //加载图片前的占位图片
	    threshold: 100, //提前加载增加像素
        autoLoadTime:500, //自动加载间隔时间
	    effect: "fadeIn" //加载图片使用的效果(淡入)
	});
});

(function ($) {
    $.fn.lazyload = function (options) {
        var settings = {
            threshold: 0,
            autoLoad: true,
            autoLoadTime: 100,
            event: "scroll",
            effect: "show",
            attr: "_src",
            autoCount: 0,
            container: window
        };
        if (options) {
            $.extend(settings, options)
        }
        if (this.length < 1)
            return;
        var elements = this;
        var autoTime = null;
        var robotTime = null;
		scrollFn = function (event) {
                settings.autoCount = 0;
                if (event.preventDefault)
                    event.preventDefault();
                event.returnValue = false;
                var counter = 0;
                elements.each(function () {
                    if ($.belowthefold(this, settings)) {//if ($.belowthefold(this, settings) && $.rightoffold(this, settings)) {
                        $(this).trigger("appear");
                    }
                });
                if (robotTime == null) {
                    robotTime = new Date().getTime();
                } else {
                    if (new Date().getTime() - robotTime < 50) {
                        return;
                    }
                    robotTime = new Date().getTime();
                }
                if (autoTime) {
                    clearTimeout(autoTime);
                    autoTime = null;
                }
                autoLoadFn(settings.autoLoad);
            }
        autoLoadFn = function (boContinue) {
            if (boContinue == undefined || boContinue != true) {
                boContinue = false;
            }
            var temp = $.grep(elements,
            function (element) {
                return !element.loaded;
            });
            elements = $(temp);
            if (elements.length > 0) {
                elements.each(function () {
                    if ($.autoVertical(this, settings)) {//if ($.autoVertical(this, settings) && $.autoHorizontal(this, settings)) {
                        $(this).trigger("appear");
                    }
                });
                if (boContinue) {
                    settings.autoCount++;
                    //console.log(settings.autoCount);
                    autoTime = setTimeout("autoLoadFn(" + settings.autoLoad + ")", settings.autoLoadTime);
                }
            } else {
				//scrollFn = null;
                $(settings.container).unbind("scroll",scrollFn);
            }
        };
        if ("scroll" == settings.event) {
            $(settings.container).scroll(scrollFn);
        }
        this.each(function () {
            var self = this;
            $(self).one("appear",
            function () {
                if (!this.loaded) {
                    $("<img />").bind("load",
                    function () {
                        $(self).hide().attr("src", $(self).attr("_src"))[settings.effect](settings.effectspeed);
                        self.loaded = true;
                    }).attr("src", $(self).attr("_src"));
                }
            });
            if ("scroll" != settings.event) {
                $(self).bind(settings.event,
                function (event) {
                    if (!self.loaded) {
                        $(self).trigger("appear")
                    }
                })
            }
        });
        autoLoadFn(settings.autoLoad);//自动加载//autoLoadFn();
    };
    var b = true;
    $.autoVertical = function (element, settings) {
        var $top;
        var $height;
        if (settings.container === undefined || settings.container === window) {
            $top = $(window).scrollTop();
            $height = $(window).height();
        } else {
            $top = $(settings.container).offset().top;
            $height = $(settings.container).height();
        }
        var c = settings.autoCount;
        if (c < 1) c = 1;
        var foldBot = $top + ($height * (c - 1) + $height);
        var foldTop = $top - ($height * (c - 1) + $height);
        if (foldTop < 0)
            foldTop = 0;
        var $ETop = $(element).offset().top;
        return ($ETop <= foldBot + settings.threshold) && ($ETop >= foldTop - settings.threshold);
    };
    $.autoHorizontal = function (element, settings) {
        var $left;
        var $width;
        if (settings.container === undefined || settings.container === window) {
            $left = $(window).scrollLeft();
            $width = $(window).width();
        } else {
            $left = $(settings.container).offset().left;
            $width = $(settings.container).width();
        }
        var c = settings.autoCount;
        if (c < 1) c = 1;
        var foldR = $left + ($width * (c - 1) + $width);
        var foldL = $left - ($width * (c - 1) + $width);
        var $ELeft = $(element).offset().left;
        return ($ELeft <= foldR + settings.threshold) && ($ELeft >= foldL - settings.threshold);
    };
    $.belowthefold = function (element, settings) {
        var $top;
        var $height;
        if (settings.container === undefined || settings.container === window) {
            $top = $(window).scrollTop();
            $height = $(window).height();
        } else {
            $top = $(settings.container).offset().top;
            $height = $(settings.container).height();
        }
        var fold = $top + $height;
        var $ETop = $(element).offset().top;
        return ($ETop <= fold + settings.threshold) && ($ETop >= $top - settings.threshold);
    };
    $.rightoffold = function (element, settings) {
        var $left;
        var $width;
        if (settings.container === undefined || settings.container === window) {
            $left = $(window).scrollLeft();
            $width = $(window).width();
        } else {
            $left = $(settings.container).offset().left;
            $width = $(settings.container).width();
        }
        var fold = $left + $width;
        var $ELeft = $(element).offset().left;
        return ($ELeft <= fold + settings.threshold) && ($ELeft >= $left - settings.threshold);
    };
})(jQuery);