<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:import href="page_import/site_temporaryvar.xslt"/>
  <xsl:import href="page_import/site_countbar.xslt"/>
  <xsl:import href="page_import/site_basefile.xslt"/>
  <xsl:import href="page_import/site_language.xslt"/>
  <xsl:import href="page_import/site_baseinfo.xslt"/>
  <xsl:import href="page_import/site_webcounter.xslt"/>
  <xsl:template match="/">
    <xsl:call-template name="import_doctype" />
    <html>
      <head>
        <xsl:call-template name="import_htmlheader"/>
        <link rel="stylesheet" type="text/css" href="/templates/css_style/cover.css"/>
      </head>
      <body>
        <style type="text/css">
        body
        {
            background: none;
            color: #333333;
        }
        a, a:visited
        {
            background: none;
            color: #333333;
        }
        .the_languagelist
        {
            width: 100%;
            text-align: center;
            vertical-align: middle;
            margin: 0px auto;
            line-height: 30px;
        }
        .the_languagelist ul
        {
            display: table;
            white-space: nowrap;
            text-align: center;
            line-height: 30px;
        }
        .the_languagelist li
        {
            color: #929292;
            display: table-cell;
            text-align: center;
            padding-left: 5px;
            line-height: 20px;
        }
        .the_copyright
        {
            margin: 0px auto;
            line-height: 24px;
            text-align: center;
        }
        </style>
        <div class="i_cover">
          <xsl:variable name="coverFType" select="//coverftype"/>
          <xsl:if test="$coverFType='img'">
            <xsl:if test="//coverimgswf=''">
              <div style="position: relative; width: {//coverimgswf/@imgswfwidth}px; height: {//coverimgswf/@imgswfheight}px; text-align: center; vertical-align: middle; margin: 0px auto; margin-top: 20px;">
                <div style="position: absolute; top: 0px; left: 0px; z-index: 40;">
                  <img src="{//coverfileurl}" />
                </div>
                <div style="position: absolute; top: 0px; left: 0px; z-index: 50;">
                  <xsl:value-of select="//coverremark" disable-output-escaping="yes"/>
                </div>
              </div>
            </xsl:if>
            <xsl:if test="//coverimgswf!=''">
              <xsl:variable name="coverBgSwfAlign" select="//coverimgswf/@imgswfalign"/>
              <xsl:variable name="coverBgSwfWidth" select="//coverimgswf/@imgswfwidth"/>
              <xsl:variable name="coverBgSwfHeight" select="//coverimgswf/@imgswfheight"/>
              <div style="position: relative; width: {$coverBgSwfWidth}px; height: {$coverBgSwfHeight}px; background: url({//coverfileurl}) no-repeat; text-align: center; vertical-align: middle; margin: 0px auto; margin-top: 20px;">
                <div style="position: absolute; top: 0px; left: 0px; z-index: 50;">
                  <xsl:value-of select="//coverremark" disable-output-escaping="yes"/>
                </div>
                <div style="position: absolute; top: 0px; left: 0px; z-index: 100;" id="coverimgswf_content"/>
              </div>
              <script type="text/javascript" language="javascript">
                var so = new SWFObject(&quot;<xsl:value-of select="//coverimgswf"/>&quot;, "coverimgswf", &quot;<xsl:value-of select="$coverBgSwfWidth"/>&quot;, &quot;<xsl:value-of select="$coverBgSwfHeight"/>&quot;, "7", "");
                so.addParam("quality", "high");
                so.addParam("wmode", "transparent");
                so.addParam("menu", "false");
                so.addParam("align", &quot;<xsl:value-of select="$coverBgSwfAlign"/>&quot;);
                so.write("coverimgswf_content");
              </script>
            </xsl:if>
          </xsl:if>
          <xsl:if test="$coverFType='swf'">
            <div style="position: relative; width: {//coverimgswf/@imgswfwidth}px;height: {//coverimgswf/@imgswfheight}px; text-align: center; vertical-align: middle; margin: 0px auto; margin-top: 20px;">
              <div style="position: absolute; top: 0px; left: 0px; z-index: 50;" id="webcover_content"/>
              <div style="position: absolute; top: 0px; left: 0px; z-index: 100;">
                <xsl:value-of select="//coverremark" disable-output-escaping="yes"/>
              </div>
            </div>
            <script type="text/javascript" language="javascript">
              var so = new SWFObject(&quot;<xsl:value-of select="//coverfileurl"/>&quot;, "webcover", &quot;<xsl:value-of select="//coverimgswf/@imgswfwidth"/>&quot;, &quot;<xsl:value-of select="//coverimgswf/@imgswfheight"/>&quot;, "7", "");
              so.addParam("quality", "high");
              so.addParam("wmode", "transparent");
              so.addParam("menu", "false");
              so.write("webcover_content");
            </script>
          </xsl:if>
          <xsl:if test="$coverFType=''">
            <div style="width: {//coverimgswf/@imgswfwidth}px; height: {//coverimgswf/@imgswfheight}px; text-align: center; vertical-align: middle; margin: 0px auto; margin-top: 20px;">
              <xsl:value-of select="//coverremark" disable-output-escaping="yes"/>
            </div>
          </xsl:if>
        </div>
        <div class="the_languagelist">
          <xsl:call-template name="import_languagebar">
            <xsl:with-param name="iscoverUse" select="1" />
          </xsl:call-template>
        </div>
        <div class="the_copyright">
          <xsl:call-template name="import_copyright"/>
        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>