﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="TopNewsDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/indexNewsList', '.xml'))"/>
  <xsl:variable name="isTopNews" select="$TopNewsDoc/newslists"/>
  <xsl:template name="import_indexnews">
    <dl class="i_n_t">
      <dt>
        <xsl:value-of select="//pagemodules/news_toptitle" />
      </dt>
      <dd>
        <a href="{//pagemodules/news_toptitle/@modulelink}"><xsl:value-of select="//pagemodules/view_more"/></a>
      </dd>
    </dl>
    <div class="clear"></div>
    <ul>
      <xsl:for-each select="$isTopNews/newsitem">
        <xsl:if test="position()&lt;6">
          <li>
            <a href="{urlpath}" title="{newstopic}"><xsl:value-of select="newstopic" /></a>
            <span><xsl:value-of select="newstime" /></span>
          </li>
        </xsl:if>
      </xsl:for-each>
    </ul>
    <h1>
      <img src="/templates/images/line1.jpg" />
    </h1>
  </xsl:template>
  <xsl:template name="import_indexpicnews">
    <script src="/templates/jscript/imgflash_ads.js" language="javascript" type="text/javascript"></script>
    <div id="flashcontent_news"></div>
    <script language="javascript" type="text/javascript">
      var pic_width=187;
      var pic_height=131;
      var button_pos=4;
      var stop_time=3000;
      var show_text=1;
      var txtcolor="000000";
      var bgcolor="DDDDDD";
      var imag=new Array();
      var thelink=new Array();
      var text=new Array();
      <xsl:for-each select="$isTopNews/newsitem[newsimage!='']">
        <xsl:if test="position()&lt;10">
          imag[<xsl:value-of select="position()" />]=&quot;<xsl:value-of select="newsimage" />&quot;;
          thelink[<xsl:value-of select="position()" />]=&quot;<xsl:value-of select="urlpath" />&quot;;
          text[<xsl:value-of select="position()" />]=&quot;<xsl:value-of select="newstopic" />&quot;;
        </xsl:if>
      </xsl:for-each>
      var swf_height=show_text==1?pic_height+20:pic_height;
      var pics="", links="", texts="";
      for(var i=1; i<xsl:text disable-output-escaping="yes">&lt;</xsl:text>imag.length; i++){
      pics=pics+("|"+imag[i]);
      links=links+("|"+thelink[i]);
      texts=texts+("|"+text[i]);
      }
      pics=pics.substring(1);
      links=links.substring(1);
      texts=texts.substring(1);
      var sohuFlash2 = new sohuFlash("/templates/flash/images_focus.swf","sohuFlashId01",pic_width,swf_height,"7","#ffffff");
      sohuFlash2.addParam("quality", "high");
      sohuFlash2.addParam("wmode", "opaque");
      sohuFlash2.addVariable("pics", pics);
      sohuFlash2.addVariable("links",links);
      sohuFlash2.addVariable("texts",texts);
      sohuFlash2.addVariable("pic_width",pic_width);
      sohuFlash2.addVariable("pic_height",swf_height);
      sohuFlash2.addVariable("show_text",show_text);
      sohuFlash2.addVariable("txtcolor",txtcolor);
      sohuFlash2.addVariable("bgcolor",bgcolor);
      sohuFlash2.addVariable("button_pos",button_pos);
      sohuFlash2.addVariable("stop_time",stop_time);
      sohuFlash2.write("flashcontent_news");
    </script>
  </xsl:template>
</xsl:stylesheet>