﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="TopProductsDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/indexProductList', '.xml'))"/>
  <xsl:variable name="isTopProducts" select="$TopProductsDoc/productlists"/>
  <xsl:template name="import_indexproducts">
    <xsl:param name="productViewTitle" select="'View Products'"/>
    <script src="/templates/jscript/scrollpics.js" language="javascript" type="text/javascript"></script>
    <ul class="up" id="LeftArr" >
      <img src="/templates/images/left.jpg" />
    </ul>
    <div id="ISL_Cont_1">
      <ul class="plist">
        <xsl:for-each select="$isTopProducts/productitem">
          <dl>
            <dt>
              <a href="{urlpath}"><img src="{productimage}" alt="{producttopic}" class="border1"/></a>
            </dt>
            <dd class="color5">
              <a href="{urlpath}" alt="{producttopic}"><xsl:value-of select="producttopic" /></a>
            </dd>
          </dl>
        </xsl:for-each>
      </ul>
    </div>
    <ul class="next" id="RightArr">
      <img src="/templates/images/rig.jpg" />
    </ul>
    <script language="javascript" type="text/javascript">
      var scrollPic_02 = new ScrollPic();
      scrollPic_02.scrollContId = "ISL_Cont_1";
      scrollPic_02.arrLeftId = "LeftArr";
      scrollPic_02.arrRightId = "RightArr";
      scrollPic_02.frameWidth = 855;
      scrollPic_02.pageWidth = 840;
      scrollPic_02.speed = 60;
      scrollPic_02.space = 320;
      scrollPic_02.autoPlay = true;
      scrollPic_02.autoPlayTime = 3;
      scrollPic_02.initialize();
    </script>
  </xsl:template>
</xsl:stylesheet>