<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="TopVideosDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/indexVideosList', '.xml'))"/>
  <xsl:variable name="isTopVideos" select="$TopVideosDoc/videolists"/>
  <xsl:template name="import_indexvideos">
    <div>
      <xsl:for-each select="$isTopVideos/videoitem">
        <xsl:if test="position()&lt;2">
          <object type="application/x-shockwave-flash" data="/flv_player/vcastr3.swf" width="242" height="183" id="vcastr3">
            <param name="movie" value="/flv_player/vcastr3.swf"/>
            <param name="quality" value="high"/>
            <param name="allowFullScreen" value="true"/>
            <param name="FlashVars" value="xml=&lt;vcastr&gt;&lt;channel&gt;&lt;item&gt;&lt;source&gt;{videofile}&lt;/source&gt;&lt;/item&gt;&lt;/channel&gt;&lt;config&gt;&lt;controlPanelBgColor&gt;0x000033&lt;/controlPanelBgColor&gt;&lt;isAutoPlay&gt;true&lt;/isAutoPlay&gt;&lt;/config&gt;&lt;/vcastr&gt;"/>
          </object>
        </xsl:if>
      </xsl:for-each>
    </div>
    <xsl:choose>
      <xsl:when test="//pagemodules/recentreview!=''">
        <h4>
          <xsl:value-of select="//pagemodules/recentreview"/>
        </h4>
      </xsl:when>
      <xsl:otherwise>
      </xsl:otherwise>
    </xsl:choose>
    <div class="p_video">
      <ul>
        <xsl:for-each select="$isTopVideos/videoitem">
          <xsl:if test="position()&lt;6">
            <li>
              <a href="{urlpath}" title="{videotopic}"><xsl:value-of select="videotopic"/></a>
            </li>
          </xsl:if>
        </xsl:for-each>
      </ul>
    </div>
  </xsl:template>
</xsl:stylesheet>