<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="TopProductsDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/indexProductList', '.xml'))"/>
  <xsl:variable name="isTopProducts" select="$TopProductsDoc/productlists"/>
  <xsl:template name="import_pindexproducts">
    <xsl:param name="productViewTitle" select="//pagemodules/showdetails"/>
    <xsl:param name="productPriceUnit" select="//pagemodules/price_unit"/>
    <ul>
      <xsl:for-each select="$isTopProducts/productitem">
        <xsl:if test="position() &lt; 5">
          <li>
            <img src="{productimage}" alt="{producttopic}" class="imgborder" />
            <br />
            <a href="{urlpath}" title="{producttopic}">[<xsl:value-of select="producttopic"/>]</a>
          </li>
        </xsl:if>
      </xsl:for-each>
    </ul>
  </xsl:template>
</xsl:stylesheet>