<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="rssReaderDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/indexRssReader', '.xml'))"/>
  <xsl:variable name="rssReaderLists" select="$rssReaderDoc/rssreaderlists"/>
  <xsl:template name="import_onlinerssreader">
    <xsl:param name="readerType" select="1"/>
    <xsl:param name="readerList" select="$rssReaderLists/rssreaderlistitem[readertype=$readerType]"/>
    <h3>
      <xsl:value-of select="//pagemodules/rssonline"/>
    </h3>
    <div class="online_rssreader">
      <ul>
        <xsl:for-each select="$readerList">
          <xsl:if test="position()&lt;6">
            <li>
              <a href="{readerurl}" title="{readertopic}" target="_blank"><img src="{readerlogo}" alt="{readertopic}" /></a>
            </li>
          </xsl:if>
        </xsl:for-each>
      </ul>
    </div>
    <div>
      <img src="/templates/images/bot1.gif" />
    </div>
  </xsl:template>
  <xsl:template name="import_rssreadersoft">
    <xsl:param name="readerType" select="2"/>
    <xsl:param name="readerList" select="$rssReaderLists/rssreaderlistitem[readertype=$readerType]"/>
    <div class="rssreader">
      <xsl:value-of select="//pagemodules/rsssoft"/>
    </div>
    <div class="soft_rssreader">
      <ul>
        <xsl:for-each select="$readerList">
          <xsl:if test="position()&lt;6">
            <li>
              <a href="{readerurl}" title="{readertopic}" target="_blank"><img src="{readerlogo}" alt="{readertopic}" /></a>
            </li>
          </xsl:if>
        </xsl:for-each>
      </ul>
    </div>
  </xsl:template>
  <xsl:template name="import_whatisrss">
    <xsl:choose>
      <xsl:when test="//indexsingles/whatisrss/@singleshort!=''">
        <h3>
          <xsl:value-of select="//indexsingles/whatisrss/@singleshort" />
        </h3>
        <div class="p_u_cont1">
          <xsl:value-of select="//indexsingles/whatisrss" disable-output-escaping="yes"/>
        </div>
        <div>
          <img src="/templates/images/bot1.gif" />
        </div>
      </xsl:when>
      <xsl:otherwise>
        <div class="whatisrss_tit">whatisrss</div>
        <div class="whatisrss_main">
          提示：<br />请在网站“图文信息管理”增加(单图文信息标识为：whatisrss)的信息标识并填写内容！
        </div>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>