﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="baseInfoDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/webBaseInfo', '.xml'))"/>
  <xsl:variable name="baseInfo" select="$baseInfoDoc/web_baseinfo"/>
  <xsl:variable name="baseFileDoc2" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/webBaseFile', '.xml'))"/>
  <xsl:variable name="baseFile2" select="$baseFileDoc2/web_basefile"/>
  <xsl:param name="web_sitename">
    <xsl:value-of select="$baseInfo/webname"/>
  </xsl:param>
  <xsl:param name="web_siteurl">
    <xsl:value-of select="$baseInfo/websiteurl"/>
  </xsl:param>
  <xsl:param name="web_wordkeys">
    <xsl:value-of select="$baseInfo/webwordkeys"/>
  </xsl:param>
  <xsl:param name="web_description">
    <xsl:value-of select="$baseInfo/webdescription"/>
  </xsl:param>
  <xsl:param name="web_author">
    <xsl:value-of select="$baseInfo/webauthor"/>
  </xsl:param>
  <xsl:template name="import_copyright">
    <xsl:value-of select="$baseInfo/webcopyright" disable-output-escaping="yes"/>
  </xsl:template>
  <xsl:template name="import_doctype">
    <xsl:value-of select="document('')/*/xsl:template[@name='DOCTYPE']/node()" disable-output-escaping="yes"/>
  </xsl:template>
  <xsl:template name="DOCTYPE">
    <![CDATA[<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">]]>
  </xsl:template>
  <xsl:template name="import_htmlheader">
    <xsl:variable name="web_pagetitle" select="//nowpagetitle" />
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="pragma" content="no-cache" />
    <title>
      <xsl:value-of select="$web_sitename"/>
      <xsl:if test="$web_pagetitle!=''"> - <xsl:value-of select="$web_pagetitle"/>
      </xsl:if>
    </title>
    <meta name="keywords" content="{$web_wordkeys}"/>
    <meta name="description" content="{$web_description}"/>
    <meta name="author" content="{$web_author}" />
    <link rel="shortcut icon" href="{$baseFile2/webfavicon}" type="image/x-icon" />
    <link rel="icon" href="{$baseFile2/webfavicon}" type="image/x-icon" />
    <xsl:choose>
      <xsl:when test="$web_pagetitle/@pindexvar='company' or $web_pagetitle/@pindexvar='contact' or $web_pagetitle/@pindexvar='about'">
        <link rel="alternate" type="application/rss+xml" href="/{$web_editionfolder}/rss/rss_single.xml" title="RSS 2.0 for ({$web_sitename}){$web_pagetitle}" />
        <link rel="alternate" type="application/atom+xml" href="/{$web_editionfolder}/atom/atom_single.xml" title="Atom 1.0 for ({$web_sitename}){$web_pagetitle}" />
      </xsl:when>
      <xsl:when test="$web_pagetitle/@pindexvar='sitemap' or $web_pagetitle/@pindexvar='siterss'">
        <link rel="alternate" type="application/rss+xml" href="/{$web_editionfolder}/rss/rss_index.xml" title="RSS 2.0 for ({$web_sitename}){$web_pagetitle}" />
        <link rel="alternate" type="application/atom+xml" href="/{$web_editionfolder}/atom/atom_index.xml" title="Atom 1.0 for ({$web_sitename}){$web_pagetitle}" />
      </xsl:when>
      <xsl:otherwise>
        <link rel="alternate" type="application/rss+xml" href="/{$web_editionfolder}/rss/rss_{$web_pagetitle/@pindexvar}.xml" title="RSS 2.0 for ({$web_sitename}){$web_pagetitle}" />
        <link rel="alternate" type="application/atom+xml" href="/{$web_editionfolder}/atom/atom_{$web_pagetitle/@pindexvar}.xml" title="Atom 1.0 for ({$web_sitename}){$web_pagetitle}" />
      </xsl:otherwise>
    </xsl:choose>
    <link rel="stylesheet" type="text/css" href="/templates/css_style/layout.css"/>
    <script type="text/javascript" src="/jscript/png.js"></script>
    <script type="text/javascript" src="/jscript/more_sort.js"></script>
    <script type="text/javascript" src="/jscript/public.js"></script>
    <script type="text/javascript" src="/jscript/usefor_user.js"></script>
    <script type="text/javascript" src="/jscript/ajax.js" language="javascript"></script>
    <script type="text/javascript" src="/jscript/new_common.js" language="javascript"></script>
    <script type="text/javascript" src="/jscript/swfobject.js"></script>
    <script type="text/javascript" src="/jscript/domtab.js" language="javascript"></script>
    <script type="text/javascript" src="/templates/jscript/temp_public.js" language="javascript"></script>
  </xsl:template>
</xsl:stylesheet>