﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:user="http://www.Qianbo.org/" exclude-result-prefixes="msxsl user">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="nmIndexTopDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/nmIsIndexList', '.xml'))"/>
  <xsl:variable name="nmIsIndexTop" select="$nmIndexTopDoc/nmindextoplists"/>
  <xsl:template name="import_isindextop_newsdll">
    <xsl:param name="productPriceUnit" select="//pagemodules/price_unit"/>
    <xsl:param name="productSellUnitTit" select="//pagemodules/sell_unittit"/>
    <xsl:param name="nmIndexVar"/>
    <xsl:param name="nmIsTopItem" select="$nmIsIndexTop/indextoplistitem[@mindexvar=$nmIndexVar]"/>
    <xsl:choose>
      <xsl:when test="$nmIsTopItem!=''">
        <ul class="imtit1">
          <div class="n_title">
            <dl>
              <dt>
                <xsl:value-of select="$nmIsTopItem/@menushort"/>
              </dt>
              <dd>
                <a href="{$nmIsTopItem/@menuurl}">>><xsl:value-of select="//pagemodules/view_more"/></a>
              </dd>
            </dl>
          </div>
        </ul>
        <div class="clear"></div>
        <div class="n_list clearfix">
          <ul>
            <xsl:for-each select="$nmIsTopItem/viewitem">
              <xsl:if test="position() &lt;= 8">
                <li>
                  <a href="{urlpath}" title="{viewtopic}"><xsl:value-of select="viewtopic"/></a>
                </li>
                <li class="nline"/>
              </xsl:if>
            </xsl:for-each>
          </ul>
        </div>
      </xsl:when>
      <xsl:otherwise>
        <div title="{$nmIndexVar}">
          提示：请在网站“菜单管理”增加(标识栏目参数为<xsl:value-of select="$nmIndexVar"/>)的菜单栏目！
        </div>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="import_isindextop_cases">
    <xsl:param name="nmIndexVar" select="'cases'" />
    <xsl:param name="nmIsTopItem" select="$nmIsIndexTop/indextoplistitem[@mindexvar=$nmIndexVar]" />
    <xsl:choose>
      <xsl:when test="$nmIsTopItem!=''">
        <dl>
          <dt>
            <span class="color">
              <xsl:value-of select="$nmIsTopItem/@menushort"/>
            </span>
            <span class="color1">PRODUCT</span>
          </dt>
          <dd class="color2">
            <a href="{$nmIsTopItem/@menuurl}">MORE</a>
          </dd>
        </dl>
        <div class="clear"></div>
        <div class="clearfix">
          <div class="training_img">
            <style type="text/css">
                .sslide_axx
                {
                    padding: 1px 6px;
                    border-left: #cccccc 1px solid;
                }
                a.sslide_axx:link, a.sslide_axx:visited
                {
                    text-decoration: none;
                    color: #fff;
                    line-height: 12px;
                    font: 9px sans-serif;
                    background-color: #343434;
                }
                a.sslide_axx:active, a.sslide_axx:hover
                {
                    text-decoration: none;
                    color: #fff;
                    line-height: 12px;
                    font: 9px sans-serif;
                    background-color: #D50239;
                }
                .sslide_bxx
                {
                    padding: 1px 6px;
                    border-left: #cccccc 1px solid;
                }
                a.sslide_bxx:link, a.sslide_bxx:visited
                {
                    text-decoration: none;
                    color: #fff;
                    line-height: 12px;
                    font: 9px sans-serif;
                    background-color: #D50239;
                }
                a.sslide_bxx:active, a.sslide_bxx:hover
                {
                    text-decoration: none;
                    color: #fff;
                    line-height: 12px;
                    font: 9px sans-serif;
                    background-color: #D50239;
                }
                .sslide_outer
                {
                    overflow: hidden;
                    text-overflow: clip;
                    position: relative;
                }
                #sslide_pic
                {
                    border: 0px;
                    filter: progid:dximagetransform.microsoft.wipe(gradientsize=1.0,wipestyle=4, motion=forward);
                }
                .sslide_abtn
                {
                    filter: background:#ffffff;
                    width: 100%;
                    text-align: right;
                    position: absolute;
                    right: 0px;
                    bottom: 0px;
                    height: 12px;
                    padding: 0px;
                    margin: 0px;
                    border: 0px;
                }
            </style>
            <script language="javascript">
              var sslide_widths=169;
              var sslide_heights=187;
              var sslide_times=5500;
              var sslide_counts=0;
              <xsl:for-each select="$nmIsTopItem/viewitem">
                <xsl:if test="position()=1">
                  <xsl:if test="last()&lt;9">
                    sslide_counts=<xsl:value-of select="last()" />;
                  </xsl:if>
                  <xsl:if test="last()&gt;=9">
                    sslide_counts=8;
                  </xsl:if>
                </xsl:if>
                <xsl:if test="position()&lt;=last() and position()&lt;9">
                  var sslide_img<xsl:value-of select="position()" />=new Image();
                  sslide_img<xsl:value-of select="position()" />.src=&quot;<xsl:value-of select="viewimage" />&quot;;
                  var sslide_url<xsl:value-of select="position()" />=new Image();
                  sslide_url<xsl:value-of select="position()" />.src=&quot;<xsl:value-of select="urlpath" disable-output-escaping="yes" />&quot;;
                  var sslide_txt<xsl:value-of select="position()" />=new Image();
                  sslide_txt<xsl:value-of select="position()" />.alt=&quot;<xsl:value-of select="viewtopic" />&quot;;
                </xsl:if>
              </xsl:for-each>
              var sslide_nn=1;
              var sslide_key=0;
              function sslide_change_img()
              {
              if(sslide_key==0){
              sslide_key=1;
              }
              else if(document.all){
              document.getElementById("sslide_pic").filters[0].Apply();
              document.getElementById("sslide_pic").filters[0].Play(duration=2);
              }
              eval('document.getElementById("sslide_pic").src=sslide_img'+sslide_nn+'.src');
              eval('document.getElementById("sslide_pic").alt=sslide_txt'+sslide_nn+'.alt');
              eval('document.getElementById("sslide_url").href=sslide_url'+sslide_nn+'.src');
              for (var i=1;i<xsl:text disable-output-escaping="yes">&lt;</xsl:text>=sslide_counts;i++){
              document.getElementById("sslide_ao"+i).className='sslide_axx';
              }
              document.getElementById("sslide_ao"+sslide_nn).className='sslide_bxx';
              sslide_nn++;
              if(sslide_nn<xsl:text disable-output-escaping="yes">&gt;</xsl:text>sslide_counts){sslide_nn=1;}
              sslide_tt=setTimeout('sslide_change_img()',sslide_times);
              }
              function sslide_changeimg(the_sliden){
              sslide_nn=the_sliden;
              window.clearInterval(sslide_tt);
              sslide_change_img();
              }
              document.write('<div class="sslide_outer" style="width: ' + sslide_widths + 'px; height: ' + sslide_heights + 'px;">
                ');
                document.write('<div>
                  <a id="sslide_url" target="_top">
                    ');
                    document.write('<img id="sslide_pic" width="' + sslide_widths + '" height="' + sslide_heights + '" />');
                    document.write('
                  </a>
                </div>');
                document.write('<div class="sslide_abtn">
                  ');
                  for(var i=1;i<xsl:text disable-output-escaping="yes">&lt;</xsl:text>sslide_counts+1;i++){
                  document.write('<a href="javascript:sslide_changeimg(' + i + ');" id="sslide_ao' + i + '" class="sslide_axx" target="_self">' + i + '</a>');
                  }
                  document.write('
                </div>
              </div>');
              sslide_change_img();
            </script>
          </div>
          <div class="training_text">
            <div class="tt1">
              <xsl:for-each select="$nmIsTopItem/viewitem">
                <xsl:if test="position()&lt;2">
                  <span class="color3">
                    <a href="{urlpath}"><xsl:value-of select="viewtopic" /></a>
                  </span>
                  <div class="i_view_infos">
                    <xsl:value-of select="viewinfos" disable-output-escaping="yes"/>
                  </div>
                </xsl:if>
              </xsl:for-each>
            </div>
          </div>
        </div>
      </xsl:when>
      <xsl:otherwise>
        <ul class="show">
          <li class="sh1 fb f14px">
            <xsl:value-of select="$nmIndexVar" />
          </li>
          <li class="sh2">
            提示：请在网站“菜单管理”增加(标识栏目参数为<xsl:value-of select="$nmIndexVar" />)的菜单栏目！
          </li>
        </ul>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <msxsl:script language="JavaScript" implements-prefix="user">
    <![CDATA[
        function getReplacedStr(str,old_chr,new_chr){if(str){return str.replace(old_chr,new_chr)}else{return ""}}
        ]]>
  </msxsl:script>
</xsl:stylesheet>