﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="indexSortDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/indexSortList', '.xml'))"/>
  <xsl:variable name="indexSortList" select="$indexSortDoc/indexsortlist"/>
  <xsl:template name="import_indexsortbar_news">
    <xsl:param name="parentId" select="0"/>
    <xsl:param name="nmIndexVar" select="'news'"/>
    <xsl:param name="sortUlClass" select="'i_n_title'"/>
    <xsl:element name="ul">
      <xsl:if test="$sortUlClass!=''">
        <xsl:attribute name="class">
          <xsl:value-of select="$sortUlClass"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:for-each select="$indexSortList/sortitem[@nmindexvar=$nmIndexVar and @parentid=$parentId]">
        <xsl:if test="position() &lt;= 2">
          <li class="in0{position()}">
            <xsl:element name="a">
              <xsl:attribute name="href">
                <xsl:value-of select="@urlpath"/>
              </xsl:attribute>
              <xsl:value-of select="@sorttopic" disable-output-escaping="yes"/>
              <xsl:if test="@urltarget=''">
                <xsl:attribute name="target">
                  <xsl:value-of select="@urltarget"/>
                </xsl:attribute>
              </xsl:if>
            </xsl:element>
          </li>
        </xsl:if>
      </xsl:for-each>
      <li class="in03">
        <a href="{$nmIndexVar}.htm"><img src="/templates/images/more.jpg" /></a>
      </li>
    </xsl:element>
  </xsl:template>
  <xsl:template name="import_indexsortbar_cases">
    <xsl:param name="parentId" select="0"/>
    <xsl:param name="nmIndexVar" select="'cases'"/>
    <xsl:for-each select="$indexSortList/sortitem[@nmindexvar=$nmIndexVar and @parentid=$parentId]">
      <xsl:if test="position() &lt;= 6">
        <li class="ltext">
          <xsl:element name="a">
            <xsl:attribute name="href">
              <xsl:value-of select="@urlpath"/>
            </xsl:attribute>
            <xsl:value-of select="@sorttopic" disable-output-escaping="yes"/>
            <xsl:if test="@urltarget=''">
              <xsl:attribute name="target">
                <xsl:value-of select="@urltarget"/>
              </xsl:attribute>
            </xsl:if>
          </xsl:element>
        </li>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>