﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:template name="import_nmdefined01">
    <xsl:variable name="definedsItem" select="//userdefineds/definedsitem[@definedkeys='definedkeys_1']"/>
    <xsl:if test="$definedsItem!=''">
      <div class="i_content">
        <dl class="i_c_t">
          <dt>
            <xsl:value-of select="$definedsItem/@definedtopic"/>
          </dt>
          <dd>
            <a href="{$definedsItem/@moreurl}">
              <xsl:value-of select="//pagemodules/view_more"/>
            </a>
          </dd>
        </dl>
        <xsl:if test="$definedsItem/@definedtype=0">
          <div class="i_u_cont1">
            <xsl:value-of select="$definedsItem" disable-output-escaping="yes"/>
          </div>
        </xsl:if>
        <xsl:if test="$definedsItem/@definedtype=1">
          <ul class="i_u_list1">
            <xsl:for-each select="$definedsItem/singleitem">
              <li><a href="{urlpath}" title="{itemtopic}"><xsl:value-of select="itemtopic"/></a> <span><xsl:value-of select="itemtime"/></span>
              </li>
            </xsl:for-each>
          </ul>
        </xsl:if>
        <div class="clear"></div>
        <h1>
          <img src="/templates/images/line.jpg" />
        </h1>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template name="import_nmdefined02">
    <xsl:variable name="definedsItem" select="//userdefineds/definedsitem[@definedkeys='definedkeys_2']"/>
    <xsl:if test="$definedsItem!=''">
      <div class="i_n_list">
        <dl class="i_n_t">
          <dt>
            <xsl:value-of select="$definedsItem/@definedtopic"/>
          </dt>
          <dd>
            <a href="{$definedsItem/@moreurl}"><xsl:value-of select="//pagemodules/view_more"/></a>
          </dd>
        </dl>
        <div class="clear"></div>
        <xsl:if test="$definedsItem/@definedtype=0">
          <div class="i_u_cont1">
            <xsl:value-of select="$definedsItem" disable-output-escaping="yes"/>
          </div>
        </xsl:if>
        <xsl:if test="$definedsItem/@definedtype=1">
          <ul>
            <xsl:for-each select="$definedsItem/singleitem">
              <li><a href="{urlpath}" title="{itemtopic}"><xsl:value-of select="itemtopic"/></a> <span><xsl:value-of select="itemtime"/></span></li>
            </xsl:for-each>
          </ul>
        </xsl:if>
        <h1>
          <img src="/templates/images/line1.jpg" />
        </h1>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template name="import_nmdefined03">
    <xsl:variable name="definedsItem" select="//userdefineds/definedsitem[@definedkeys='definedkeys_3']"/>
    <xsl:if test="$definedsItem!=''">
      <div class="i_contact">
        <ul>
          <h1>
            <a href="{$definedsItem/@moreurl}"><xsl:value-of select="$definedsItem/@definedtopic"/></a>
          </h1>
          <xsl:if test="$definedsItem/@definedtype=0">
            <div class="contact">
              <xsl:value-of select="$definedsItem" disable-output-escaping="yes"/>
            </div>
          </xsl:if>
          <xsl:if test="$definedsItem/@definedtype=1">
            <div class="i_u_list3">
              <xsl:for-each select="$definedsItem/singleitem">
                <xsl:if test="position() &lt;= 5">
                  <li><a href="{urlpath}" title="{itemtopic}"><xsl:value-of select="itemtopic"/></a> <span><xsl:value-of select="itemtime"/></span></li>
                </xsl:if>
              </xsl:for-each>
            </div>
          </xsl:if>
        </ul>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template name="import_nmdefined04">
    <xsl:variable name="definedsItem" select="//userdefineds/definedsitem[@definedkeys='definedkeys_4']"/>
    <xsl:if test="$definedsItem!=''">
      <div class="i_u_def4">
        <ul class="i_u_topic4">
          <li class="top01">
            <xsl:value-of select="$definedsItem/@definedtopic"/>
          </li>
          <li class="top02">
            <a href="{$definedsItem/@moreurl}" style="color: #FFFFFF;"><xsl:value-of select="//pagemodules/view_more"/></a>
          </li>
        </ul>
        <xsl:if test="$definedsItem/@definedtype=0">
          <div class="i_u_cont4">
            <xsl:value-of select="$definedsItem" disable-output-escaping="yes"/>
          </div>
        </xsl:if>
        <xsl:if test="$definedsItem/@definedtype=1">
          <ul class="i_u_list4">
            <xsl:for-each select="$definedsItem/singleitem">
              <li><a href="{urlpath}" title="{itemtopic}"><xsl:value-of select="itemtopic"/></a> <span><xsl:value-of select="itemtime"/></span></li>
            </xsl:for-each>
          </ul>
        </xsl:if>
      </div>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>