<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:template name="import_nmdefined01">
    <xsl:variable name="definedsItem" select="//userdefineds/definedsitem[@definedkeys='definedkeys_1']" />
    <xsl:choose>
      <xsl:when test="$definedsItem!=''">
        <div class="nm_defined01">
          <div class="nm_defined01">
            <div class="i_p_list">
              <xsl:if test="$definedsItem/@definedtype=0">
                <div class="defined_content" title="{$definedsItem/@definedtopic}">
                  <xsl:value-of select="$definedsItem" disable-output-escaping="yes"/>
                </div>
              </xsl:if>
              <xsl:if test="$definedsItem/@definedtype=1">
                <ul class="iptit">
                  <li class="ip01">
                    <img src="/templates/images/titl.gif" />
                  </li>
                  <li class="ip02">
                    <xsl:value-of select="$definedsItem/@definedtopic"/>
                  </li>
                  <li class="ip03">
                    <a href="{$definedsItem/@moreurl}"><xsl:value-of select="//pagemodules/view_more"/>>></a>
                  </li>
                  <li class="right">
                    <img src="/templates/images/titr.gif" />
                  </li>
                </ul>
                <div class="content03 clearfix">
                  <div class="mtop01"></div>
                  <ul class="defined_ul_list">
                    <xsl:for-each select="$definedsItem/singleitem">
                      <li>
                        <a href="{urlpath}" title="{itemtopic}"><xsl:value-of select="itemtopic"/></a>
                        <span>
                          [<xsl:value-of select="itemtime"/>]
                        </span>
                      </li>
                    </xsl:for-each>
                  </ul>
                  <div class="mtop01"></div>
                </div>
              </xsl:if>
            </div>
          </div>
        </div>
      </xsl:when>
      <xsl:otherwise>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="import_nmdefined02">
    <xsl:variable name="definedsItem" select="//userdefineds/definedsitem[@definedkeys='definedkeys_2']" />
    <xsl:if test="$definedsItem!=''">
      <div class="nm_defined02">
        <div class="i_content mtop01">
          <ul class="ictit">
            <li class="ic01">
              <img src="/templates/images/titl.gif" />
            </li>
            <li class="ic02">
              <xsl:value-of select="$definedsItem/@definedtopic"/>
            </li>
            <li class="ic03">
              <a href="{$definedsItem/@moreurl}"><xsl:value-of select="//pagemodules/view_more"/>>></a>
            </li>
            <li class="right">
              <img src="/templates/images/titr.gif" />
            </li>
          </ul>
          <div class="content01 clearfix">
            <div class="mtop01"></div>
            <xsl:if test="$definedsItem/@definedtype=0">
              <div class="defined_content" title="{$definedsItem/@definedtopic}">
                <xsl:value-of select="$definedsItem" disable-output-escaping="yes"/>
              </div>
            </xsl:if>
            <xsl:if test="$definedsItem/@definedtype=1">
              <ul class="indexleft_list">
                <xsl:for-each select="$definedsItem/singleitem">
                  <li>
                    <a href="{urlpath}" title="{itemtopic}"><xsl:value-of select="itemtopic"/></a>
                  </li>
                </xsl:for-each>
              </ul>
            </xsl:if>
            <div class="mtop01"></div>
          </div>
        </div>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template name="import_nmdefined03">
    <xsl:variable name="definedsItem" select="//userdefineds/definedsitem[@definedkeys='definedkeys_3']" />
    <xsl:if test="$definedsItem!=''">
      <div class="nm_defined03">
        <div class="i_content mtop01">
          <ul class="ictit">
            <li class="ic01">
              <img src="/templates/images/titl.gif" />
            </li>
            <li class="ic02">
              <xsl:value-of select="$definedsItem/@definedtopic"/>
            </li>
            <li class="ic03">
              <a href="{$definedsItem/@moreurl}"><xsl:value-of select="//pagemodules/view_more"/>>></a>
            </li>
            <li class="right">
              <img src="/templates/images/titr.gif" />
            </li>
          </ul>
          <div class="content01 clearfix">
            <div class="mtop01"></div>
            <xsl:if test="$definedsItem/@definedtype=0">
              <div class="defined_content" title="{$definedsItem/@definedtopic}">
                <xsl:value-of select="$definedsItem" disable-output-escaping="yes"/>
              </div>
            </xsl:if>
            <xsl:if test="$definedsItem/@definedtype=1">
              <ul class="indexleft_list">
                <xsl:for-each select="$definedsItem/singleitem">
                  <li>
                    <a href="{urlpath}" title="{itemtopic}"><xsl:value-of select="itemtopic"/></a>
                  </li>
                </xsl:for-each>
              </ul>
            </xsl:if>
            <div class="mtop01"></div>
          </div>
        </div>
      </div>
    </xsl:if>
  </xsl:template>
  <xsl:template name="import_nmdefined04">
    <xsl:variable name="definedsItem" select="//userdefineds/definedsitem[@definedkeys='definedkeys_4']" />
    <xsl:if test="$definedsItem!=''">
      <div class="nm_defined04">
        <div class="i_p_list">
          <xsl:if test="$definedsItem/@definedtype=0">
            <div class="defined_content" title="{$definedsItem/@definedtopic}">
              <xsl:value-of select="$definedsItem" disable-output-escaping="yes"/>
            </div>
          </xsl:if>
          <xsl:if test="$definedsItem/@definedtype=1">
            <ul class="iptit">
              <li class="ip01">
                <img src="/templates/images/titl.gif" />
              </li>
              <li class="ip02">
                <xsl:value-of select="$definedsItem/@definedtopic"/>
              </li>
              <li class="ip03">
                <a href="{$definedsItem/@moreurl}"><xsl:value-of select="//pagemodules/view_more"/>>></a>
              </li>
              <li class="right">
                <img src="/templates/images/titr.gif" />
              </li>
            </ul>
            <div class="content03 clearfix">
              <div class="mtop01"></div>
              <ul class="defined_ul_list">
                <xsl:for-each select="$definedsItem/singleitem">
                  <li>
                    <a href="{urlpath}" title="{itemtopic}"><xsl:value-of select="itemtopic"/></a>
                    <span>
                      [<xsl:value-of select="itemtime"/>]
                    </span>
                  </li>
                </xsl:for-each>
              </ul>
              <div class="mtop01"></div>
            </div>
          </xsl:if>
        </div>
      </div>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>