﻿function Node(id,indent,text,target,url,tooltip,nmindex,nohidden,parentid,iconOpen,iconClose,isOpen) {
 this.id        = id;                 this.indent    = indent;
 this.text      = text;               this.target    = target;
 this.url       = url;                this.tooltip   = tooltip;
 this.iconOpen  = iconOpen;           this.iconClose = iconClose;
 this.menuid  = tooltip;           this.nmindex = nmindex;
 this.parent    = null;               this.childs    = [];
 this.isOpen    = isOpen;           this.nohidden = nohidden;
 this.parentid = parentid }
function treemenu(name, showLines, showIcons, useCookies) {
 this.name      = name;               this.showLines = showLines;
 this.showIcons = showIcons;          this.useCookies= useCookies;
 this.nodes     = [];                 this.root      = new Node(-1,-1,'root');
 this.selected  = -1;                 this.maxIndent = 0;
 this.expire    = 1;                  this.openNodes = '';
 this.classDepth= 2;
 this.readCookies();
 if (!navigator.cookieEnabled) this.useCookies = false;
 this.defaults = {
   iconRoot  : 'sort_menus/menu_img/root.gif',        iconItem  : 'sort_menus/menu_img/item.gif',
   iconOpen  : 'sort_menus/menu_img/open.gif',        iconClose : 'sort_menus/menu_img/close.gif',
   passLine  : 'sort_menus/menu_img/passline.gif',    empty     : 'sort_menus/menu_img/empty.gif',
   tieLine   : 'sort_menus/menu_img/tieline.gif',     tiePlus   : 'sort_menus/menu_img/tieplus.gif',
   endLine   : 'sort_menus/menu_img/endline.gif',     endPlus   : 'sort_menus/menu_img/endplus.gif',
   rectPlus  : 'sort_menus/menu_img/rectplus.gif',    tieMinus  : 'sort_menus/menu_img/tieminus.gif',
   rectMinus : 'sort_menus/menu_img/rectminus.gif',   endMinus  : 'sort_menus/menu_img/endminus.gif',
   minIcon   : 'sort_menus/menu_img/minicon.gif',   iconHidden  : 'sort_menus/menu_img/hidden_item.gif'  } }
treemenu.prototype.put = function(open, label, target, url,
                                  tooltip, nmindex, nohidden, parentid, iconOpen, iconClose) {
 if (this.selected==-1) this.selected = this.nodes.length;
 this.add(open, label, target, url, tooltip, nmindex, nohidden, parentid, iconOpen, iconClose); }
treemenu.prototype.add = function(open, label, target, url,
                                  tooltip, nmindex, nohidden, parentid, iconOpen, iconClose) {
 var indent = 0;
 while (label.charAt(indent)==' ') indent++;
 if (this.maxIndent<indent) this.maxIndent = indent;
 var id     = this.nodes.length;
 var isOpen = (open==0) ? false : true;
 if (this.openNodes && id<this.openNodes.length)
     isOpen = (this.openNodes.charAt(id)=='1') ? true : false;
 var node   = new Node(id, indent, label.substr(indent),
                       target, url, tooltip, nmindex, nohidden, parentid, iconOpen, iconClose, isOpen);
 this.nodes[this.nodes.length] = node;
 for (i=this.nodes.length-1; i>=0; i--)
   if (this.nodes[i].indent < indent) { node.parent = this.nodes[i];   break; }
 if (!node.parent) node.parent = this.root;
 node.parent.childs[node.parent.childs.length] = node; }
treemenu.prototype.toString = function() {
 var str = '<div class="TreeMenu">';
 var lastIndent = 0;
 for (id=0; id<this.nodes.length; id++) {
   var node = this.nodes[id]
   if (lastIndent < node.indent) lastIndent = node.indent;
   while (lastIndent>node.indent) { str += '</div>';   lastIndent--; }
   str += this.writeNode(node);
   if (0<node.childs.length) {
     str += '<div id="' + this.name + 'SubTree_' + id
         +  '" style="display:'
         +  ((node.isOpen) ? 'block' : 'none') + '">'; } }
 for (i=lastIndent; i>0; i--) str += '</div>';
 str += '</div>';
 this.setCookies(this.expire);
 return str;  }
treemenu.prototype.writeNode = function(node) {
 if (node.target=='hide') return '';
 var str = '<div>'
         + this.writeIndenting(node)  + this.writeTieUpIcon(node)
         + this.writeNodeSymbol(node) + this.writeNodeText(node) + '</div>';
 return str; }
treemenu.prototype.writeIndenting = function(node) {
 if (node.indent < 2) return '';
 var str      = '';
 var icons    = [];
 var ancestor = node.parent;
 for (i=node.indent-2; i>=0; i--, ancestor=ancestor.parent) {
      icons[i] = (this.isLastChild(ancestor) ? 'empty' : 'passLine');  }
 for (i=0; i<=node.indent-2; i++) {
      var icon = this.defaults.empty;
      if (this.showLines && icons[i]!='empty') icon = this.defaults.passLine;
      str += '<img name="' + icons[i] + '" src="' + icon + '" alt="" />'; }
 return str;  }
treemenu.prototype.writeTieUpIcon = function(node)  {
 if (node.indent < 1) return '';
 var icon = this.getTieUpIcon(node);
 var str  = '';
 if (0==node.childs.length)
      str = '<img id="' + this.name + 'TieUp_' + node.id
          + '" src="' + icon + '" alt="" />';
 else str = '<a href="javascript: parent.document.frames[1].' + this.name + '.toggle(' + node.id + ')">'
          +  '<img id="' + this.name + 'TieUp_' + node.id
          +  '" src="' + icon + '" alt="" /></a>';
 return str; }
treemenu.prototype.getTieUpIcon = function(node) {
 if (0 == node.childs.length) {
   if      (!this.showLines)        return this.defaults.empty;
   else if (this.isLastChild(node)) return this.defaults.endLine;
   else                             return this.defaults.tieLine;  }
 else if (node.isOpen) {
   if      (!this.showLines)        return this.defaults.rectMinus;
   else if (this.isLastChild(node)) return this.defaults.endMinus;
   else                             return this.defaults.tieMinus; }
 else {
   if      (!this.showLines)        return this.defaults.rectPlus;
   else if (this.isLastChild(node)) return this.defaults.endPlus;
   else                             return this.defaults.tiePlus;  } }
treemenu.prototype.writeNodeSymbol = function(node) {
 var icon = this.getNodeSymbol(node) ;
 if (0==node.childs.length) {
   var str = '';
   if (node.url) {    str += '<a href="' + node.url + '"';
     if (node.target) str += ' target="' + node.target + '")';
     if (node.menuid>0) str += ' oncontextmenu="javascript: show_acontextmenu(' + node.menuid + ',\'' + node.nmindex + '\',' + node.parentid + ');"';
                      str += '">'; }
   str += '<img id="' + this.name + 'Symbol_' + node.id
       +  '" src="'   + icon + '" alt="" />';
   if (node.url) str += '</a>';
   return str; }
 if (node.menuid>0){
     return   '<a href="javascript: parent.document.frames[1].' + this.name + '.toggle(' + node.id + ')" oncontextmenu="javascript: show_acontextmenu(' + node.menuid + ',\'' + node.nmindex + '\',' + node.parentid + ');">'
              + '<img id="' + this.name + 'Symbol_' + node.id
              + '" src="' + icon + '" alt="" /></a>';
 }
 else
 {
     return   '<a href="javascript: parent.document.frames[1].' + this.name + '.toggle(' + node.id + ')">'
              + '<img id="' + this.name + 'Symbol_' + node.id
              + '" src="' + icon + '" alt="" /></a>';
 }
}
treemenu.prototype.getNodeSymbol = function(node) {
 if (!this.showIcons)  return this.defaults.minIcon;
 if (0==node.childs.length) {
   if (node.iconOpen){
       return node.iconOpen;
   }
   else
   {
       if(node.nohidden==0)  return this.defaults.iconHidden;
       else return this.defaults.iconItem;
   }
   }
 else if (node.isOpen) {
   if (node.iconOpen)  return node.iconOpen;
   else                return this.defaults.iconOpen;  }
 else {
   if (node.iconClose) return node.iconClose;
   else                return this.defaults.iconClose; } }
treemenu.prototype.writeNodeText = function(node) {
 var cls = this.getNodeTextClass(node, this.selected);
 var str = '<a id="' + this.name + 'Node_' + node.id + '" class="' + cls + '"';
 if (node.url) str += ' href="' + node.url + '"';
 else          str += ' href="javascript: parent.document.frames[1].'+this.name+'.toggle('+node.id+')"';
 if (node.url && node.target)  str += ' target="' + node.target   + '"';
 if (node.nohidden==0) str += ' style="color: #aaaaaa;"';
 if (node.menuid>0) str += ' oncontextmenu="javascript: show_acontextmenu(' + node.menuid + ',\'' + node.nmindex + '\',' + node.parentid + ');"';
 str += ' onclick="javascript: ' + this.name + '.pick(' + node.id + ')"';
 str += '>' + node.text + ((node.url) ? '</a>' : '</a>') ;
 return str; }
treemenu.prototype.getNodeTextClass = function(node, selectID) {
 var cls = (node.id==selectID) ? 'Selected' : 'Node';
 if (!node.url) cls = 'Item';
 return cls + '_' + Math.min(node.indent, this.classDepth); }
treemenu.prototype.writeCreatedWithTreeMenu = function() {
 var path = '',    target ='';
 var elem = document.getElementById('treepath');
 var str = '<br>Created with <a class="CreatedBy" target="' + target +'"'
         + ' href="' + path + '">TreeMenu</a>';
 return str; }
treemenu.prototype.loadSelected = function() { this.loadNode(this.selected); }
treemenu.prototype.loadNode = function(id) {
 if (id<0) return;
 if (this.nodes[id].target=='hide') return;
 for (var i=0; i<parent.frames.length; i++) {
   if (parent.frames[i].name==this.nodes[id].target) {
     parent.frames[i].location.href = this.nodes[id].url;
     break; } } }
treemenu.prototype.pick = function(id) {
 var node = this.nodes[id];
 if (node.url) {
   if      (node.indent==0       && this.showIcons==false) this.toggle(id);
   else if (node.childs.length>0 && node.isOpen==false)    this.toggle(id); }
 this.select(id); }
treemenu.prototype.select = function(id) {
 if (!this.nodes[id].url) return;
 if (this.selected >= 0) {
   node = document.getElementById(this.name + 'Node_' + this.selected);
   if (node && name) node.className = name;
   this.selected  = -1;  }
 node = document.getElementById(this.name + 'Node_' + id);
 if (node && name) node.className = name;
 this.selected  = id;
 this.openAncestors(id);
 this.setCookies(this.expire); }
treemenu.prototype.openAncestors = function(id) {
 if (id<0) return;
 var ancestor = this.nodes[id].parent;
 while(ancestor.indent>=0) {
   if (!ancestor.isOpen) { ancestor.isOpen=true;  this.updateNode(ancestor); }
   ancestor = ancestor.parent;   } }
treemenu.prototype.selectPath = function(path) {
 path = this.pathWithSlash(path);
 if (this.selected>=0) {
   var url = this.pathWithSlash(this.nodes[this.selected].url);
   if (url==path) return;  }
 for (id=0; id<this.nodes.length; id++) {
   var url = this.pathWithSlash(this.nodes[id].url);
   if (url && url==path) { this.select(id);    break; } } }
treemenu.prototype.pathWithSlash = function(path) {
 var parts = path.split("\\");
 var str   = parts[0];
 for (i=1; i<parts.length; i++) str = str + '/' + parts[i];
 return str; }
treemenu.prototype.toggle = function(id) {
 if (this.nodes[id].childs.length==0) return;
 this.nodes[id].isOpen = !this.nodes[id].isOpen;
 this.updateNode(this.nodes[id]);
 this.setCookies(this.expire); }
treemenu.prototype.updateNode = function(node) {
 subTree = document.getElementById(this.name + 'SubTree_' + node.id);
 tieUp   = document.getElementById(this.name + 'TieUp_'   + node.id);
 symbol  = document.getElementById(this.name + 'Symbol_'  + node.id);
 if (subTree) subTree.style.display = (node.isOpen) ? 'block' : 'none';
 if (tieUp)   tieUp.src   = this.getTieUpIcon(node);
 if (symbol)  symbol.src  = this.getNodeSymbol(node); }
treemenu.prototype.isLastChild = function(node) {
 var parent = node.parent;
 return ((node == parent.childs[parent.childs.length-1]) ? true : false); }
treemenu.prototype.level = function(level) {
 for (id=0; id<this.nodes.length; id++) {
   this.nodes[id].isOpen = (this.nodes[id].indent<level) ? true : false;
   this.updateNode(this.nodes[id]); }
 this.setCookies(this.expire); }
treemenu.prototype.lines = function(bool) {
 if (this.showLines == bool) return;
 this.showLines = bool;
 var passLines = document.getElementsByName("passLine");
 if (!passLines) return;
 for (i=0; i<passLines.length; i++) {
   passLines[i].src = (bool) ? this.defaults.passLine : this.defaults.empty; }
 for (id=0; id<this.nodes.length; id++) {
   if (this.nodes[id].indent < 1) continue;
   var tieUp = document.getElementById(this.name + 'TieUp_' + id);
   if (tieUp) tieUp.src = this.getTieUpIcon(this.nodes[id]);  }
 this.setCookies(this.expire); }
treemenu.prototype.icons = function(bool) {
 if (this.showIcons == bool) return;
 this.showIcons = bool;
 for (id=0; id<this.nodes.length; id++) {
   var icon  = this.getNodeSymbol(this.nodes[id]);
   var image = document.getElementById(this.name + 'Symbol_' + id)
   if (image)  image.src = icon; }
 this.setCookies(this.expire); }
treemenu.prototype.expiration = function(expire) {
 this.expire = expire;          this.setCookies(this.expire); }
treemenu.prototype.cookies = function(bool) {
 if (bool) { this.useCookies = bool;  this.setCookies(this.expire);   }
 else      { this.setCookies(-1);     this.useCookies = bool;         } }
treemenu.prototype.setCookies = function(expire) {
 this.openNodes = '';
 for (i=0; i<this.nodes.length; i++)
   this.openNodes += (this.nodes[i].isOpen) ? '1' : '0';
 this.setCookie("OpenNodes", this.openNodes, expire);
 this.setCookie("ShowLines", this.showLines, expire);
 this.setCookie("ShowIcons", this.showIcons, expire);
 this.setCookie("Selected",  this.selected,  expire);
 this.setCookie("Expire"   , this.expire,    expire); }
treemenu.prototype.readCookies = function() {
 var lines  = this.getCookie("ShowLines");
 var icons  = this.getCookie("ShowIcons");
 var select = this.getCookie("Selected");
 var open   = this.getCookie("OpenNodes");
 var expire = this.getCookie("Expire");
 if (lines)   this.showLines = (lines=='true') ? true : false;
 if (icons)   this.showIcons = (icons=='true') ? true : false;
 if (select)  this.selected  = select;
 if (open)    this.openNodes = open;
 if (expire)  this.expire    = expire;
 if (lines || icons || select ||  open) this.useCookies = true;  }
treemenu.prototype.setCookie = function(name, value, expire) {
 if (!this.useCookies) return;
 var exp = new Date();
 var end = exp.getTime() + (expire * 24 * 60 * 60 * 1000);
 exp.setTime(end);
 document.cookie =  name + '=' + value + '; expires=' + exp.toGMTString(); }
treemenu.prototype.getCookie = function(name) {
 var cookies  = document.cookie;
 var posName  = cookies.indexOf(name + '=');
 if (posName == -1) return '';
 var posValue = posName + name.length + 1;
 var endValue = cookies.indexOf(';',posValue);
 if (endValue !=-1) return cookies.substring(posValue, endValue);
 return cookies.substring(posValue); }