<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="TopProductsDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/indexProductList', '.xml'))"/>
  <xsl:variable name="isTopProducts" select="$TopProductsDoc/productlists"/>
  <xsl:template name="import_indexproducts">
    <xsl:param name="productViewTitle" select="'View Products'" />
    <xsl:for-each select="$isTopProducts/productitem">
      <xsl:if test="position() &lt;= 4">
        <div style="float: left; padding-top: 6px;" class="Products_list">
          <table width="200" border="0" align="center" cellpadding="0" cellspacing="0">
            <tr>
              <td width="70" rowspan="2" align="center" valign="top">
                <table width="70" border="0" cellspacing="0" cellpadding="0">
                  <tr>
                    <td>
                      <a href="{urlpath}"><img src="{productimage}" title="{producttopic}" width="75" /></a>
                    </td>
                  </tr>
                  <tr>
                    <td height="40" align="right" valign="bottom">
                      <a href="#"><img src="/templates/images/Ico_Enlargement.gif" width="23" height="19" /></a>
                    </td>
                  </tr>
                </table>
              </td>
              <td width="124" colspan="2" align="left" valign="top">
                <table width="120" border="0" cellspacing="0" cellpadding="0">
                  <tr>
                    <td height="75" colspan="2">
                      <a href="{urlpath}" class="Pd_Tit f14 fbold"><xsl:value-of select="producttopic"/></a>
                      <br />
                      <span class="fbold">
                        <xsl:value-of select="productcode"/>
                      </span>
                      <br />
                      <span class="Web_TRH">
                        <xsl:value-of select="productinfos" disable-output-escaping="yes" />
                      </span>
                    </td>
                  </tr>
                  <tr>
                    <td width="109" height="30" align="right">
                      <a href="{urlpath}" class="White"><xsl:value-of select="$productViewTitle"/></a>
                    </td>
                    <td width="11" rowspan="2"></td>
                  </tr>
                  <tr>
                    <td height="10" align="right"></td>
                  </tr>
                </table>
              </td>
            </tr>
          </table>
        </div>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>