<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="webCounterDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/webCounter', '.xml'))"/>
  <xsl:variable name="counterVar" select="$webCounterDoc/web_counter"/>
  <xsl:template name="import_webcounter">
    <xsl:variable name="counterSwitch" select="$counterVar/counterswitch"/>
    <xsl:variable name="counterMedian" select="$counterVar/countermedian"/>
    <xsl:variable name="nowCounter" select="$counterVar/nowcounter"/>
    <xsl:variable name="counterStyle" select="$counterVar/counterstyle"/>
    <xsl:if test="$counterSwitch='1'">
      <xsl:choose>
        <xsl:when test="$counterStyle=''">
          <xsl:value-of disable-output-escaping="yes" select="$counterVar/countercode"></xsl:value-of>
        </xsl:when>
        <xsl:when test="$counterStyle='0'">
          <script language="javascript" src="/webcounter/counter.js"></script>
          <script language="javascript">document.write(now_wcounter.toString());</script>
        </xsl:when>
        <xsl:otherwise>
          <script language="javascript" src="/webcounter/counter.js"></script>
          <script language="javascript" src="/webcounter/show_counter.js"></script>
          <script language="javascript">
            var the_newwcounter=now_wcounter.toString();
            var ncounter_len=the_newwcounter.length;
            var show_counternum=<xsl:value-of select="$counterMedian" />;
            var counter_imgpath=&quot;/webcounter/<xsl:value-of select="$counterStyle" />/&quot;;
            document.write(get_imgcounter());
          </script>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>