﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="nmSubMenuDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/webSubMenuList', '.xml'))"/>
  <xsl:variable name="nmSubMenuList" select="$nmSubMenuDoc/web_mainmenu"/>
  <xsl:variable name="nmMainMenuDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/webMainMenu', '.xml'))"/>
  <xsl:variable name="nmMainMenuList" select="$nmMainMenuDoc/web_mainmenu"/>
  <xsl:template name="import_nmsubmenubar">
    <xsl:param name="pIndexVar" select="//nowpagetitle/@pindexvar"/>
    <xsl:variable name="mParentId" select="$nmMainMenuList/menuitem[@pindexvar=$pIndexVar]/@parentid"/>
    <xsl:variable name="menuId" select="$nmMainMenuList/menuitem[@pindexvar=$pIndexVar]/@menuid"/>
    <xsl:variable name="sortUlClass" select="'ullist_sortnav'"/>
    <xsl:choose>
      <xsl:when test="$mParentId &lt;= 0">
        <xsl:choose>
          <xsl:when test="$nmSubMenuList/menuitem[@menuid=$menuId]/@menuname!=''">
            <h1>
              <xsl:value-of select="$nmSubMenuList/menuitem[@menuid=$menuId]/@menuname"/>
            </h1>
            <xsl:element name="ul">
              <xsl:if test="$sortUlClass!=''">
                <xsl:attribute name="class">
                  <xsl:value-of select="$sortUlClass"/>
                </xsl:attribute>
              </xsl:if>
              <xsl:for-each select="$nmSubMenuList/menuitem[@menuid=$menuId]/sortitem">
                <li class="p_s_li0">
                  <xsl:element name="a">
                    <xsl:attribute name="href">
                      <xsl:value-of select="@urlpath"/>
                    </xsl:attribute>
                    <xsl:attribute name="class">
                      <xsl:value-of select="'p_s_li0_a'"/>
                    </xsl:attribute>
                    <xsl:value-of select="@sorttopic"/>
                    <xsl:if test="@urltarget!=''">
                      <xsl:attribute name="target">
                        <xsl:value-of select="@urltarget"/>
                      </xsl:attribute>
                    </xsl:if>
                  </xsl:element>
                </li>
              </xsl:for-each>
            </xsl:element>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="import_nmsubmenubar_01"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="$nmSubMenuList/menuitem[@menuid=$mParentId]/@menuname!=''">
            <h1>
              <xsl:value-of select="$nmSubMenuList/menuitem[@menuid=$mParentId]/@menuname"/>
            </h1>
            <xsl:element name="ul">
              <xsl:if test="$sortUlClass!=''">
                <xsl:attribute name="class">
                  <xsl:value-of select="$sortUlClass"/>
                </xsl:attribute>
              </xsl:if>
              <xsl:for-each select="$nmSubMenuList/menuitem[@menuid=$mParentId]/sortitem">
                <li class="p_s_li0">
                  <xsl:element name="a">
                    <xsl:attribute name="href">
                      <xsl:value-of select="@urlpath"/>
                    </xsl:attribute>
                    <xsl:attribute name="class">
                      <xsl:value-of select="'p_s_li0_a'"/>
                    </xsl:attribute>
                    <xsl:value-of select="@sorttopic"/>
                    <xsl:if test="@urltarget!=''">
                      <xsl:attribute name="target">
                        <xsl:value-of select="@urltarget"/>
                      </xsl:attribute>
                    </xsl:if>
                  </xsl:element>
                </li>
              </xsl:for-each>
            </xsl:element>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="import_nmsubmenubar_01"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="import_nmsubmenubar_01">
    <xsl:param name="pMenuId" select="1"/>
    <xsl:param name="starNum" select="1"/>
    <xsl:param name="sortUlClass" select="'ullist_sortnav'"/>
    <xsl:if test="$nmSubMenuList/menuitem[@pmenuid=$pMenuId]/@menuname!=''">
      <h1>
        <xsl:value-of select="$nmSubMenuList/menuitem[@pmenuid=$pMenuId]/@menuname"/>
      </h1>
      <xsl:element name="ul">
        <xsl:if test="$sortUlClass!=''">
          <xsl:attribute name="class">
            <xsl:value-of select="$sortUlClass"/>
          </xsl:attribute>
        </xsl:if>
        <xsl:for-each select="$nmSubMenuList/menuitem[@pmenuid=$pMenuId]/sortitem[@sortstarnum=$starNum]">
          <li class="p_s_li0">
            <xsl:element name="a">
              <xsl:attribute name="href">
                <xsl:value-of select="@urlpath"/>
              </xsl:attribute>
              <xsl:attribute name="class">
                <xsl:value-of select="'p_s_li0_a'"/>
              </xsl:attribute>
              <xsl:value-of select="@sorttopic"/>
              <xsl:if test="@urltarget!=''">
                <xsl:attribute name="target">
                  <xsl:value-of select="@urltarget"/>
                </xsl:attribute>
              </xsl:if>
            </xsl:element>
          </li>
        </xsl:for-each>
      </xsl:element>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>