<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:template match="/">
    <link rel="stylesheet" type="text/css" href="/templates/css_style/layout.css" />
<style type="text/css">
body {
        background: none;
}
.p_p_item {
        display: table;
        height: 120px;
        float: left;
        margin-top: 14px;
        margin-left: 6px;
}
.p_p_frame {
        width: 170px;
        overflow: hidden;
        text-align: center;
        float: left;
}
.p_p_frame img {
        height: 100px;
        border: 1px solid #ddd;
        background: #fff;
        padding: 3px;
        float: left;
}
.p_p_info {
        font-size: 12px;
        line-height: 20px;
        float: left;
        overflow: hidden;
        padding: 0px 4px;
        width: 530px;
}
.p_p_topic {
        width: 160px;
        line-height: 24px;
        padding-left: 2px;
        clear: both;
        font-weight: bold;
        text-align: center;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        display: block;
}
</style>
    <ul class="p_p_list_s">
      <xsl:for-each select="productlists/productitem">
        <li class="p_p_item">
          <div class="p_p_frame"><a href="{urlpath}" target="_top"><img src="{productimage}" alt="{producttopic}"/></a><a class="p_p_topic" href="{urlpath}" title="{producttopic}" target="_top"><xsl:value-of select="producttopic"/></a></div>
          <div class="p_p_info"><xsl:value-of select="productinfos" disable-output-escaping="yes"/></div>
        </li>
      </xsl:for-each>
    </ul>
  </xsl:template>
</xsl:stylesheet>