function ChineseCalendar(dateObj){
    this.dateObj = (dateObj != undefined) ? dateObj : new Date();
    this.SY = this.dateObj.getFullYear();
    this.SM = this.dateObj.getMonth();
    this.SD = this.dateObj.getDate();
	this.lunarInfo = [0x04bd8,0x04ae0,0x0a570,0x054d5,0x0d260,0x0d950,0x16554,0x056a0,0x09ad0,0x055d2,
		0x04ae0,0x0a5b6,0x0a4d0,0x0d250,0x1d255,0x0b540,0x0d6a0,0x0ada2,0x095b0,0x14977,
		0x04970,0x0a4b0,0x0b4b5,0x06a50,0x06d40,0x1ab54,0x02b60,0x09570,0x052f2,0x04970,
		0x06566,0x0d4a0,0x0ea50,0x06e95,0x05ad0,0x02b60,0x186e3,0x092e0,0x1c8d7,0x0c950,
		0x0d4a0,0x1d8a6,0x0b550,0x056a0,0x1a5b4,0x025d0,0x092d0,0x0d2b2,0x0a950,0x0b557,
		0x06ca0,0x0b550,0x15355,0x04da0,0x0a5b0,0x14573,0x052b0,0x0a9a8,0x0e950,0x06aa0,
		0x0aea6,0x0ab50,0x04b60,0x0aae4,0x0a570,0x05260,0x0f263,0x0d950,0x05b57,0x056a0,
		0x096d0,0x04dd5,0x04ad0,0x0a4d0,0x0d4d4,0x0d250,0x0d558,0x0b540,0x0b6a0,0x195a6,
		0x095b0,0x049b0,0x0a974,0x0a4b0,0x0b27a,0x06a50,0x06d40,0x0af46,0x0ab60,0x09570,
		0x04af5,0x04970,0x064b0,0x074a3,0x0ea50,0x06b58,0x055c0,0x0ab60,0x096d5,0x092e0,
		0x0c960,0x0d954,0x0d4a0,0x0da50,0x07552,0x056a0,0x0abb7,0x025d0,0x092d0,0x0cab5,
		0x0a950,0x0b4a0,0x0baa4,0x0ad50,0x055d9,0x04ba0,0x0a5b0,0x15176,0x052b0,0x0a930,
		0x07954,0x06aa0,0x0ad50,0x05b52,0x04b60,0x0a6e6,0x0a4e0,0x0d260,0x0ea65,0x0d530,
		0x05aa0,0x076a3,0x096d0,0x04bd7,0x04ad0,0x0a4d0,0x1d0b6,0x0d250,0x0d520,0x0dd45,
		0x0b5a0,0x056d0,0x055b2,0x049b0,0x0a577,0x0a4b0,0x0aa50,0x1b255,0x06d20,0x0ada0,
		0x14b63];
	this.Gan = new Array("", "", "", "", "", "", "", "", "", "");
	this.Zhi = new Array("", "", "", "î", "", "", "", "δ", "", "", "", "");
    //ũ yĸ 1-12 , û򴫻 0
    this.leapMonth = function(y){
        return this.lunarInfo[y - 1900] & 0xf;
    };
    //ũ ymµ
    this.monthDays = function(y, m){
        return (this.lunarInfo[y - 1900] & (0x10000 >> m)) ? 30 : 29;
    };
    //ũ yµ
    this.leapDays = function(y){
        if (this.leapMonth(y)) {
            return (this.lunarInfo[y - 1900] & 0x10000) ? 30 : 29;
        }
        else {
            return 0;
        }
    };
    //ũ y
    this.lYearDays = function(y){
        var i, sum = 348;
        for (i = 0x8000; i > 0x8; i >>= 1) {
            sum += (this.lunarInfo[y - 1900] & i) ? 1 : 0;
        }
        return sum + this.leapDays(y);
    };
    //ũ, ڶ, ũڶ
    //ö .year .month .day .isLeap .yearCyl .dayCyl .monCyl
    this.Lunar = function(dateObj){
        var i, leap = 0, temp = 0, lunarObj = {};
        var baseDate = new Date(1900, 0, 31);
        var offset = (dateObj - baseDate) / 86400000;
        lunarObj.dayCyl = offset + 40;
        lunarObj.monCyl = 14;
        for (i = 1900; i < 2050 && offset > 0; i++) {
            temp = this.lYearDays(i);
            offset -= temp;
            lunarObj.monCyl += 12;
        }
        if (offset < 0) {
            offset += temp;
            i--;
            lunarObj.monCyl -= 12;
        }
        
        lunarObj.year = i;
        lunarObj.yearCyl = i - 1864;
        leap = this.leapMonth(i);
        lunarObj.isLeap = false;
        for (i = 1; i < 13 && offset > 0; i++) {
            if (leap > 0 && i == (leap + 1) && lunarObj.isLeap == false) {
                --i;
                lunarObj.isLeap = true;
                temp = this.leapDays(lunarObj.year);
            }
            else {
                temp = this.monthDays(lunarObj.year, i)
            }
            if (lunarObj.isLeap == true && i == (leap + 1)) {
                lunarObj.isLeap = false;
            }
            offset -= temp;
            if (lunarObj.isLeap == false) {
                lunarObj.monCyl++;
            }
        }
        
        if (offset == 0 && leap > 0 && i == leap + 1) {
            if (lunarObj.isLeap) {
                lunarObj.isLeap = false;
            }
            else {
                lunarObj.isLeap = true;
                --i;
                --lunarObj.monCyl;
            }
        }
        
        if (offset < 0) {
            offset += temp;
            --i;
            --lunarObj.monCyl
        }
        lunarObj.month = i;
        lunarObj.day = offset + 1;
        return lunarObj;
    };
    //
    this.cDay = function(m, d){
        var nStr1 = ['', 'һ', '', '', '', '', '', '', '', '', 'ʮ'];
        var nStr2 = ['', 'ʮ', 'إ', 'ئ', ''];
        var s;
        if (m > 10) {
            s = 'ʮ' + nStr1[m - 10];
        }
        else {
            s = nStr1[m];
        }
        s += '';
        switch (d) {
            case 10:
                s += 'ʮ';
                break;
            case 20:
                s += 'ʮ';
                break;
            case 30:
                s += 'ʮ';
                break;
            default:
                s += nStr2[Math.floor(d / 10)];
                s += nStr1[d % 10];
        }
        return s;
    };
	this.cyclical=function(num) {
		return (this.Gan[num % 10] + this.Zhi[num % 12])
	};	
    this.solarDay = function(){
		var sTermInfo = new Array(0, 21208, 42467, 63836, 85337, 107014, 128867, 150921, 173149, 195551, 218072, 240693, 263343, 285989, 308563, 331033, 353350, 375494, 397447, 419210, 440795, 462224, 483532, 504758) 
		var solarTerm = new Array("С", "", "", "ˮ", "", "", "", "", "", "С", "â", "", "С", "", "", "", "¶", "", "¶", "˪", "", "Сѩ", "ѩ", "") 
		var lFtv = new Array("0101*", "0115 Ԫ", "0505 ", "0707 Ϧ", "0715 Ԫ", "0815 ", "0909 ", "1208 ˽", "1224 С", "0100*Ϧ") 	
		var sFtv = new Array("0101*Ԫ", "0214 ˽", "0308 Ů", "0312 ֲ", "0401 ˽", "0501 Ͷ", "0504 ", "0512 ʿ", "0515 ʼͥ", "0516 ȫ", "0517 ʵ", "0518 ʲ", "0520 ȫѧӪ", "0523 ţ", "0531 ", "0601 ͯ", "0701 ", "0801 ", "0910 ʦ", "1001*", "1101 ʥ", "1108 ", "1225 ʥ", "0620 ׽", "0606 ")		
        var sDObj = new Date(this.SY, this.SM, this.SD);
        var lDObj = this.Lunar(sDObj);
		var lDPOS = new Array(3) 
		var festival = '',solarTerms = '',solarFestival = '',lunarFestival = '',solarTerms = '',tmp1, tmp2;	
		for (i in lFtv) if (lFtv[i].match(/^(\d{2})(.{2})([\s\*])(.+)$/)) {
			tmp1 = Number(RegExp.$1) - lDObj.month 
			tmp2 = Number(RegExp.$2) - lDObj.day
			if (tmp1 == 0 && tmp2 == 0) lunarFestival = RegExp.$4
		}		
		if (lunarFestival == '') {
			for (i in sFtv) if (sFtv[i].match(/^(\d{2})(\d{2})([\s\*])(.+)$/)){
				tmp1 = Number(RegExp.$1) - (this.SM + 1) 
				tmp2 = Number(RegExp.$2) - this.SD
				if (tmp1 == 0 && tmp2 == 0) solarFestival = RegExp.$4
			}
			if (solarFestival == '') {
				tmp1 = new Date((31556925974.7 * (this.SY - 1900) + sTermInfo[this.SM * 2 + 1] * 60000) + Date.UTC(1900, 0, 6, 2, 5)) 
				tmp2 = tmp1.getUTCDate() 
				if (tmp2 == this.SD) solarTerms = solarTerm[this.SM * 2 + 1] 
				tmp1 = new Date((31556925974.7 * (this.SY - 1900) + sTermInfo[this.SM * 2] * 60000) + Date.UTC(1900, 0, 6, 2, 5)) 
				tmp2 = tmp1.getUTCDate()	
				if (tmp2 == this.SD) solarTerms = solarTerm[this.SM * 2]
				if (solarTerms == '') sFtv = '';
				else sFtv = solarTerms
			} else sFtv = solarFestival
		} else sFtv = lunarFestival
		if (sFtv == '') sTermInfo = this.cyclical(lDObj.year - 1900 + 36) + ' ' + this.cDay(lDObj.month, lDObj.day)
		else sTermInfo = this.cDay(lDObj.month, lDObj.day) + ' ' + sFtv + ''
		return (sTermInfo)
    };	
    this.solarDay2 = function(){
        var sDObj = new Date(this.SY, this.SM, this.SD);
        var lDObj = this.Lunar(sDObj);
        var tt = 'ũ' + this.cDay(lDObj.month, lDObj.day);
        lDObj = null;
        return tt;
    };
    this.weekday = function(){
        var day = ["", "һ", "ܶ", "", "", "", ""];
        return day[this.dateObj.getDay()];
    };
    this.YYMMDD = function(){
        var dateArr = [this.SY, '', this.SM + 1, '', this.SD, ''];
        return dateArr.join('');
    }
}