/*********************
author : vellen
create : 2011-09-21
update : 2011-11-24
email : xpow@yahoo.cn
**********************/

(function(){
	
	xQuery = window.xQuery = window.Fn = function( selector, context ) {
		return new xQuery.fn.init( selector, context );
	};
	
	var regHtmlTag = /^<[^>]+>$/g;
	var regAttr = /\[\s*([\w\-]+)\s*([!~|^$*]?\=)?\s*(?:(["']?)([^\]'"]*)\3)?\s*\]/g;
	
	xQuery.fn = xQuery.prototype = {
		version : '2.2.0',
		init : function(selector, content){
			selector = selector || document;
			if (selector.nodeType) {
				this[0] = this.elem = selector;
				this.length = 1;
				this.context = selector;
				return this;
			}
			
			if (typeof selector == 'string'){
				selector = selector.trim();
				if (regHtmlTag.test(selector)){
					regHtmlTag = /^<[^>]+>$/g;
					return xQuery(document).append(selector);
				}
				
				if (regAttr.test(selector)){
					
					return ;
				}
				
				var re = xQuery(this.obj(selector) || []);
				re.context = document;
				re.selector = selector;
				return re;
			}
			
			if (this.isArray(selector) || this.isObjArray(selector) || this.isObjArray(selector) || this.isJSON(selector) || !this.isUndefined(selector.length)){
				this.elem = selector;
				this.length = selector.length;
				this.context = selector;
				var _self = this;
				this.each(selector, function(o, i){ _self[i] = this; });
				return this;
			}
			
		},
		
		obj : function (id){
			if (this.is(id, 'Object')) return id;
			var obj = document.getElementById(id);
			if (obj){
				if (obj.id != id){
					if (document.all){
						var obj;
						for(var i=0; i<document.all.length; i++){
							if (xQuery(document.all[i]).attr('id') == id){
								obj = document.all[i];
								break;
							}
						}
						return obj;
					}
				}
			}
			return obj;
		},
		
		bind : function(){},
		unbind : function(){},
		one : function(){},
		ready : function( fun ){
			this.fx.ready.bind(this.elem, fun);
			return this;
		},
		
		is : function(o, type){
			switch((type || '').toLowerCase()){
				case 'object' : return (o && (typeof o === "object" || this.is(o, 'Function'))) || false; break;
				case 'json' : return (o && (this.is(o, 'Object') || o.isJSON())) || false; break;
				case 'array' : return Object.prototype.toString.call(o) === '[object Array]'; break;
				case 'objarray' : return Object.prototype.toString.call(o) === '[object HTMLCollection]' || (this.is(o, 'Object') && !this.is(o.length, 'Undefined')); break;
				case 'empty' : return (o === null || o === '' || typeof o === 'undefined' || o === false); break;
				case 'element' : try{return o.tagName? (o.nodeType == 1 && !xQuery(['html','head','title','meta','script','style']).contains(xQuery(o).tag())) : false}catch(e){return false}; break;
				case 'tableie6' : return (xQuery(o).tag() == 'table' && this.Browser.version*1 < 9 && this.Browser.ie) ? true : false; break;
				case 'tableie' : return (xQuery(['table','tbody','tr','td']).contains(xQuery(o).tag()) && this.Browser.version*1 < 9 && this.Browser.ie) ? true : false; break;
				default: return typeof o === type.toLowerCase(); break;
			}
		},

		cookie : function(name, val, expire, host){
			if (!this.isUndefined(val)){
				expire = expire ? expire : '';
				if(expire){
					expire = new Date((new Date()).getTime() + expire * 3600000);
					expire = '; expires=' + expire.toGMTString();
				}
				host = host ? host : location.host.replace('www','');
				document.cookie = name + '=' + escape(val) + expire+';path=/;domain='+host; 
			}else{
				var cookieValue = '';
				var search = name + '=';
				if(document.cookie.length > 0){ 
					offset = document.cookie.indexOf(search);
					if (offset != -1){ 
						offset += search.length;
						end = document.cookie.indexOf(';', offset);
						if (end == -1) end = document.cookie.length;
						cookieValue = unescape(document.cookie.substring(offset, end));
					}
				}
				return cookieValue;
			}
		},

		cache : {
			D : {},
			set : function(key, val, type){
				if (type){
					if (xQuery.fn.isObject(type)){
						return type['_cache_'+key] = val;
					}
					if (!this.D[type]) this.D[type] = {};
					this.D[type][key] = val;
					return true;
				}
				return this.D[key] = val;
			},
			get : function(key, type){
				if (xQuery.fn.isObject(type)){
					return type['_cache_'+key];
				}
				return type ? (!this.D[type] ? '' : this.D[type][key]) : this.D[key];
			},
			remove : function(key, type){
				if (xQuery.fn.isObject(type)){
					return type['_cache_'+key] = '';
				}
				return key && type ? this.D[type][key] = '' : this.D[key] = '';
			}
		},
		
		event : {
			evt : '',
			set : function(t){if (!this.evt) this._catch(); try{this.evt.keycode=t; if (t=='false'){ this.evt.returnValue = false }}catch(e){}},
			get : function(){ return this._catch(); },
			add : function(elem, evt, func){
				if (!elem['_event_'+evt+'_'+func] && elem.tagName){
					elem['_event_'+evt+'_'+func] = function(){ return func.call(elem, window.event) };
					var cc = elem['_event_'+evt+'_'+func];
					elem.attachEvent ? elem.attachEvent('on'+evt, cc) : elem.addEventListener(evt, cc, false);
				}
				return xQuery(elem);
			},
			remove : function(elem, evt, func, bol){
				var cc = elem['_event_'+evt+'_'+func];
				elem['_event_'+evt+'_'+func] = '';
				elem.detachEvent ? elem.detachEvent( bol ? evt : 'on'+evt, cc) : elem.removeEventListener(evt, cc, false);
				return xQuery(elem);
			},
			trigger : function(elem, etp){
				if (document.createEvent && !xQuery.Browser.ie){
					var Event = document.createEvent('MouseEvent');
					Event.initEvent(etp, false, true);
					return elem.dispatchEvent(Event);
				}else if (document.createEventObject){
					return elem.fireEvent('on'+etp);
				}
			},
			fire : function(elem, etp, evt){
				var Event = document.createEvent ? document.createEvent('MouseEvent') : document.createEventObject('MouseEvent');
				var elem = xQuery.fn.isObject(elem) ? elem : xQuery(elem)[0] ;
				var event = evt || this._catch();
                if (Event.initMouseEvent && !xQuery.Browser.ie) {
                    Event.initMouseEvent (
						etp, true, true, window, 0, 
						event.screenX, event.screenY, 
						event.clientX, event.clientY, 
						event.ctrlKey, event.altKey, 
						event.shiftKey, event.metaKey, 
						0, null);
					return elem.dispatchEvent(Event);
                } else {
                    if (document.createEventObject) {
                        var Event = document.createEventObject('MouseEvent');
                        Event.button = 1;
						return elem.fireEvent('on'+etp, Event);
					}
				}
			},
			stop : function(type, data, event){
				var event = event || this._catch();
				if (this.elem) {
					event.preventDefault();
					event.stopPropagation();
					return this.trigger(event, data, this.elem);
				}
			},
			_search : function(){
				var func = this._search.caller;
				var KeyboardEvent = KeyboardEvent ? KeyboardEvent : 'function Event()';
				while(func != null){
					var arg0 = func.arguments[0];
					if(arg0){
						if(arg0.constructor == MouseEvent) return arg0;
						if(arg0.constructor == KeyboardEvent || arg0.constructor.toString().indexOf(KeyboardEvent)>-1 ){this.keycode = arg0.which; return arg0}
					}
					func = func.caller;
				}
				return null;
			},
			_catch : function(){
				if (window.event){
					this.evt = window.event;
				}else{
					var evt = this._search() || {};
					this.evt = {
						keyCode : evt.keyCode || evt.keycode,
						x : evt.x || evt.pageX,
						y : evt.y || evt.pageY,
						pageX : this.x,
						pageY : this.y,
						srcElement : evt.srcElement || evt.target
					}
				};
				return this.evt;
			}
		},
		
		name : function( elemName, tag ){
			return this.NAME( elemName, tag );
		},

		NAME : function( elemName, tag ){
			var elems = [];
			if (this.is(this.elem, 'element')){
				// var childs = this.getNodes(this.elem, tag);
				this.each(this.tag(tag), function(){
					if (this.nodeType == 1){
						if (xQuery.fn.fx.attr(this, 'name') == elemName){
							elems.push(this);
						}
					}
				})
				return xQuery(elems);
			}
			
			var elem = document.getElementsByName(elemName);
			if (elem.length || (tag || '').toLowerCase() == 'input'){
				elems = elem;
			}else{
				if (document.all){
					var array = tag ? document.getElementsByTagName(tag) : document.all;
					xQuery(array).each(function(){
						if (xQuery.fn.isElement(this)){
							if (xQuery.fn.fx.attr(this, 'name') == elemName){
								elems.push(this);
							}
						}
					});
				}
			}
			return xQuery(elems);
		},
		
		getNodes : function(elem, node, parent){
			var childs = elem.childNodes, elems = xQuery.fn.cache.get('_nodes_'+node, parent || elem) || [], node = node ? node : '';
			xQuery.fn.cache.remove('_nodes_'+node, parent || elem);
			if (childs.length>0){
				this.each(childs, function(){
					if (this.nodeType == 1){
						elems.push(this);
						xQuery.fn.cache.set('_nodes_'+node, elems, elem);
						xQuery.fn.getNodes(this, node, elem);
					}
				});
			}
			return xQuery.fn.cache.get('_nodes_'+node, parent || elem);
		},

		parseClass : function( elem, className ){
			var css = elem.className || '', cary = css.split(/\s+/), ccary = [];
			this.each(cary, function(){ if (this != className.trim()){ ccary.push(this); } })
			return ccary.join(' ');
		},
		hasClass: function( className ) {
			return this.inArray(className, (this.elem.className || '').toString().split(/\s+/)) > -1;
		},		
		addClass : function( className ){
			this.elem.className = this.parseClass(this.elem, className)+' '+className;
			return this;
		},
		removeClass : function( className ){
			var _self = this;
			var elem = this.isArray(this.elem) || this.isObjArray(this.elem) ? this.elem : [this.elem]
			this.each(elem,function(){
				this.className = _self.isEmpty(className) ? '' : _self.parseClass(this, className);
			})
			return this;
		},
		attr : function( json, val ){ var ore = this.fx.attr(this.elem, json, val); return ore ? ore : this; },
		removeAttr : function( val ){ this.elem.removeAttribute(val); return this },
		html : function( val ){ if (!this.isUndefined(val)) {this.elem.innerHTML = val.toString();}else{ return this.elem.innerHTML }; return this; },
		empty : function(){
			if (!this.isElement(this.elem)) return this;
			if (!this.isTableIE(this.elem)) {
				if (xQuery(['input', 'select']).contains(this.elem.tagName.toLowerCase())) { return this.value(''); }else{ return this.html(''); }
			}
			
			var len = this.elem.childNodes.length;
			if (len<1) return this;
			switch(this.elem.tagName.toLowerCase()){
				case 'tr' :
					for(var i=len-1; i>=0; i--){
						this.elem.deleteCell(i);
					}
					break;
				case 'tbody' :
					for(var i=len-1; i>=0; i--){
						this.elem.deleteRow(i);
					}
					break;
				case 'table' :
					len = this.elem.childNodes[0].childNodes.length;
					for(var i=len-1; i>=0; i--){
						this.elem.childNodes[0].deleteRow(i);
					}
					break;
			}
			return this;
		},
		text : function( val ){
			if (!this.isUndefined(val)) {
				if (this.Browser.firefox){ this.elem.textContent = val.toString() }else{ this.elem.innerText = val.toString(); };
				return this;
			}else{
				return this.Browser.firefox ? this.elem.textContent : this.elem.innerText;
			}
		},
		disable : function(o){
			if (this.isElement(this.elem)){
				this.attr({'disabled':'disabled'});
				if(this.tag() == 'a'){
					this.cache.set('_xQuery_attr_href', this.attr('href'), this.elem);
					this.elem.removeAttribute('href').click(function(){return false});
				}
			}
			return this;
		},
		enable : function(o){
			this.removeAttr('disabled');
			Fn.event.remove(this.elem, 'click', function(){return false})
			if (this.cache.get('_xQuery_attr_href', this.elem)){
				this.attr({'href' : this.cache.get('_xQuery_attr_href', this.elem)});
			};
			return this;
		},
		hide : function(){
			var elem = this.makeElementArray(this.elem), _self = this;
			this.each(elem, function(){
				var _css = xQuery(this).css('display');
				if (_css != 'none'){
					if (_css) _self.cache.set('_xQuery_css', {'display' : _css}, this);
					xQuery(this).css({'display':'none'});
				}
			})
			return this;
		},
		show : function(){
			var elem = this.makeElementArray(this.elem), _self = this;
			this.each(elem, function(){
				var _css = xQuery(this).css('display');
				if (_css == 'none'){
					_css = _self.cache.get('_xQuery_css', this);
					if (_css) _css = _css['display'];
					xQuery(this).css({'display': _css ? _css : ''});
				}
			})
			return this;
		},
		
		makeElementArray : function(elem){
			var elem = this.isArray(elem) || this.isObjArray(elem) ? elem : [elem]
			return elem;
		},

		xor : function(){
		
		
		},

		orx : function(){
		
		
		},

		toggle : function(json){
			var elems = this.isArray(this.elem) || this.isObjArray(this.elem) ? this.elem : [this.elem], json = json ? json : '';
			if (this.isString(json) && json){
				var toset = 0;
				if (xQuery(['width','height']).contains(json)) {
					var _self = this;
					this.each(elems, function(o){
						var nElem = xQuery(this);
						if (nElem[json]() == toset) {
							var orgiAttr = _self.cache.get('css_'+json, this).evalJSON();
							nElem[json](orgiAttr[json]);
							return _self;
						}
						_self.cache.set('css_'+json, '{"'+json +'":"'+ nElem[json]()+'px"}' , this);
						nElem[json](toset);
					})
				}
				return this;
			}

			if (this.isJSON(json) && !this.nodeType){
				this.each(json, function(o, orgi){

				})
			}
			this.each(elems, function(){
				if (xQuery(this).css('display') == 'none'){
					xQuery(this).show();
				}else{
					xQuery(this).hide();
				}
			});
			return this;
		},
		tag : function( node ){return node ? xQuery(this.elem.getElementsByTagName(node)) : this.elem.tagName.toLowerCase(); },
		css : function( json, val, extra ){
			var _slef = this, isHW = false;
			if (this.isString(json)){
				if (xQuery(['width','height']).contains(json.toLowerCase())) { isHW = true; extra = extra ? extra : 'rect';}
			}
			if (this.isEmpty(val) && extra && isHW){
				var offset = json.toLowerCase() == 'width' ? ['Left','Right'] : ['Top','Bottom'], val = 0;
				var reExtra = extra == 'rect' ? 'padding' : extra;
				this.each(offset, function(o, i){
					//val -= parseFloat(_slef.css(reExtra + o));
					var bow = parseFloat(_slef.css('border'+o+'Width'));
					bow.toString() == 'NaN' ? 0 : bow;
					if (extra == 'margin'){
						//val += bow;
						//val += parseFloat(_slef.css('margin'+o));
						alert('extra='+extra +'\n padding'+o+_slef.css('padding'+o))
						val += parseFloat(_slef.css('padding'+o));
						val += parseFloat(_slef.css('border'+o+'Width'));
					} else if(extra == 'padding'){
						val += parseFloat(_slef.css('padding'+o));
						val -= bow;
					} else if(extra == 'rect'){
						val -= bow;
					}
				});
				return this.fx.css(this.elem, json)+val;
			}
			return this.fx.css(this.elem, json, val); 
		},
		value : function( val ){
			if (this.elem.nodeType != 1) return this;
			if(!this.isUndefined(val)){
				this.elem.value = val.toString();
			}else{
				return this.elem.value.toString().trim();
			}
			return this;
		},
		
		contains : function( val ){
			if (this.isArray(this.elem)){
				return this.inArray(val, this.elem) === false ? false : true;
			}
			
			if (this.isObject(this.elem)){
				var newElem = this.isString(val) ? xQuery(val)[0] : val;
				if (this.elem.compareDocumentPosition){
					return this.elem !== newElem || !!(this.elem.compareDocumentPosition(newElem) & 16);
				}
				if (this.elem.contains && newElem.nodeType === 1){
					return this.elem.contains(newElem) && this.elem !== newElem;
				}

				while ((vElem = newElem.parentNode)) {
					if (vElem === this.elem && vElem !== newElem) return true;
				}
				return false;
			}
		},
		
		Try : {
			sn : 0, emssage : '', isreport : 0, _err_ : {location:'',line:0,name:''}, foundErr : false,
			these: function() {
				var returnValue;
				this.Clear();
				this.isreport = (arguments[0]==1);
				if(arguments[1] == 1 && this.isreport){ this._err_ = _arg }
				for (var i = 0, length = arguments.length; i < length; i++) {
					if (typeof arguments[i] == 'function'){
						try {
							returnValue = arguments[i]();
							break;
						} catch (e) {
							this.sn += 1;
							this.foundErr = true;
							this.emssage += 'error #'+this.sn+': '+e.message+'\n';
						}
					}
				}
				if (this.isreport){this.outErr()}
				return returnValue;
			},
			outErr : function(){
				var _msg = '[xQuery.Try] catch these errors:\n'
				if (this.foundErr){ for (var i in this._err_){ _msg += i+': '+this._err_[i]+'\n' }
				this.emssage = _msg + '\n' + this.emssage; alert(this.emssage); }
				this.Clear();
			},
			Clear : function(){
				this.emssage = '';
				this._err_ = {location:'',line:0,name:''};
				this.isreport = 0;
				this.sn = 0;
				this.foundErr = false;
			}
		},
		
		load : function(url, callback, mode){
			var elem = this.elem;
			if (!elem) return false;
			this.ajax({
				query : url,
				onbefor : '',
				onsucc : function(data){
					if (elem.nodeType){
						if (elem.nodeType == 1){
							switch( elem.tagName.toLowerCase() ){
								case 'input' : xQuery(elem).value(data); break;
								default : mode ? xQuery(elem).html(data) : xQuery(elem).text(data);
							}
						}
					}else{
						elem = data;
					}
					if (typeof callback == 'function') return callback.call(elem);
				},
				onfaild : function(){}
			});
			return this;
		},

		loadScript : function(url, callback, mode){
			if (this.isArray(url)){
				var _self = this, length = url.length;
				this.each(url, function(){
					_self.loadSrc(this, callback, length, 'javascript', mode);
				})
			}else{
				this.loadSrc(url, callback, '', 'javascript', mode);
			}
			return this;
		},

		loadSrc : function(url, callback, length, type, mode, target){
			var murl = this.md5(url), sn = this.cache.get(type, type) || 0, msn = this.cache.get(type, murl) || 0;
			var attr = {}, isloaded = false, length = length ? length : 1, _self = this;
			switch(type){
				case 'css' : tag = '<link>'; attr = {'type':'text/css', 'rel':'stylesheet', 'href':url, 'id':'__load.'+type+'.'+sn}; break;
				case 'img' : tag = '<img>'; attr = {'src':url, 'id':'__load.'+type+'.'+sn}; break;
				case 'javascript' :
				default : tag = '<script>'; attr = {'type':'text/javascript', 'src':url, 'id':'__load.'+type+'.'+sn}; break;
			}

			if (sn == 0 || msn == 0) {
				sn += 1;
				this.cache.set(type, sn, murl);
				this.cache.set(type, sn, type);
				xQuery(tag)
					.attr(attr)
					.appendTo(target ? target : xQuery(document).tag('head'))
					.ready(function(){
						var loaded = _self.cache.get('srcloaded', 'srcloadlength') || 0;
						loaded += 1;
						_self.cache.set('srcloaded', loaded, 'srcloadlength');
						if (loaded == length) isloaded = true;
						if (typeof callback == 'function' && isloaded) {
							_self.cache.remove('srcloaded', 'srcloadlength');
							return callback(length);
						}
					});
			} else {
				var loaded = _self.cache.get('srcloaded', 'srcloadlength') || 0;
				if (loaded == length) isloaded = true;
				if (typeof callback == 'function' && isloaded){
					this.cache.remove('srcloaded', 'srcloadlength');
					return callback(length);
				}
			}
		},

		getJSON : {},
		ajax : function(json){var o = new this.xhr; return o.get(json)},
		regExps : {
			patrn : '', regStr : '', regMode : 0, result : '', res : '', reArry : '', oReg : '', debug : 0,
			init : function(p,re,md){
				this.patrn = p;
				this.regStr = re;
				this.regMode = md;
			},
			Create : function(){
				this.oReg = this.regMode ? new RegExp(this.patrn,'ig') : this.patrn;
			},
			Match : function(re){
				this.Create();
				if ( xQuery.fn.isEmpty(re) || xQuery.fn.isUndefined(re) )re='$1';
				if (re.indexOf(',')>0){
					this.oReg.exec(this.regStr);
					this.reArry = re.split(',');
					for (i=0; i<this.reArry.length; i++){this.result += eval('xQuery.fn.regExps.oReg.'+re) + ','}
				}else{
					this.result = this.regStr.match(this.patrn);// eval('RegExp.'+re)
				}
				if (this.debug)this.test();
				return (this.result==null)?'':this.result;
			},
			Light : function(node,key){
				var thtml;
				xQuery(node).each(function(){
					xQuery(this).children().each(function(){
						if (this.innerHTML){
							thtml = this.innerHTML;
							this.innerHTML = thtml.replace(eval('/'+key+'/ig'),'<font class="light">'+key+'</font>')
						}
					})
				})
			},
			replaceTo : function(tostr){
				return this.regStr.replace(this.oReg,tostr);
			},
			test : function(){
				var re = '',tBr='\n\n';
				re += 'regMode : '+ this.regMode + tBr;
				re += 'patrn : '+ this.patrn + tBr;
				re += (this.regMode)?'express : RegExp("'+this.patrn+'","ig")':'';
				re += tBr + 'result : '+this.result + tBr;
				re += 'regStr : '+ this.regStr;
				alert(re);
			}
		},
		inArray : function( val, array, cmode ) {
			for (var i = 0, length = array.length; i < length; i++){
				if (cmode){ 
					if (array[i] === val) return i;
				} else {
					if (array[i] == val) return i;
				}
			}
			return false;
		},
		append : function( val,spl ){ return this.topend(val, spl, false, false ) },
		appendText : function( val,spl ){ return this.topend(val, spl, false, true ) },
		prepend : function( val, spl ){ return this.topend(val, spl, true, false) },
		prependText : function( val,spl ){ return this.topend(val, spl, true, true ) },
		appendTo : function( target, mode ){
			var newElem = this.elem;
			var regHtmlTag = /^<[^>]+>$/g;
			var target = target.nodeType ? target : this.isObject(target[0]) ? target[0] : xQuery(target)[0];
			if (newElem.parentNode && newElem.parentNode.nodeType == 1){
				target.appendChild(newElem.cloneNode(true));
				newElem.parentNode.removeChild(newElem);
			}else{
				this.isTableIE6(target) ? target.childNodes[0].appendChild(newElem) : target.appendChild(newElem);
			}
			return mode ? xQuery(target) : this;
		},
		prependTo : function( target, mode ){
			var newElem = this.elem;
			var target = target.nodeType ? target : this.isObject(target[0]) ? target[0] : xQuery(target)[0];
			xQuery(target)[0].insertBefore(newElem.cloneNode(true),xQuery(target)[0].childNodes[0]);
			if (newElem.parentNode && newElem.parentNode.nodeType == 1) newElem.parentNode.removeChild(newElem);
			return mode ? xQuery(target) : this;
		},
		clone : function(){
			
		},
		topend : function( val, args, mode, nodtype ){
			var args = args ? args : '';
			var regHtmlTag = /^<[^>]+>$/g;
			if (this.elem == document || regHtmlTag.exec(val)==val){
				var oReg = new RegExp("^<([^>]+)>$", 'ig');
				var newElem = document.createElement(val.replace(oReg,'$1'));
				if (newElem.tagName == 'TABLE') newElem.appendChild(document.createElement('TBODY'));
				if (this.isJSON(args)) this.each(args, function(o){ xQuery(newElem)[o](args[o]) });
				if (this.elem != document){ this.isTableIE6(this.elem) ? this.elem.childNodes[0].appendChild(newElem) : this.elem.appendChild(newElem); return this; }
				return xQuery(newElem);
			}
			if (!this.isObject(val) && (this.elem.nodeType == 1 || this.elem.nodeType == 3)){
				switch(this.elem.tagName.toLowerCase()){
				case 'input' :
				case 'textarea':
					var rev = xQuery(this.elem).value();
					return xQuery(this.elem).value((mode ? [val,rev] : [rev,val]).join(args));
					break;
				default :
					var rev = xQuery(this.elem).html();
					var val = nodtype ? document.createTextNode(val) : val
					nodtype ? xQuery(this.elem)[0].appendChild(val) : xQuery(this.elem).html( (mode ? [val,rev] : [rev,val + '']).join(args) );
					return this;
					break;
				}
			}
			
			if (this.isObject(val)){
				
			}
		},
		extend : function(source){
			Object.extend(Fn, source);
			Object.extend(xQuery.fn, source);
			Object.extend(xQuery.fn.init.prototype, source);
		},
		Browser : {},
		Extend : function(){
			if (this.isExtend)return; this.isExtend = true;
			Object.extend = function(destination, source) {for (var property in source) {destination[property] = source[property];};return destination}
			Object.extend(String.prototype,{
				each : function(func,context){ for (var i=0; i < this.length; i++) { func.call(context, this.charAt(i), i, this); } },
				trim : function(){ return this.replace(/^[ ]*(.*?)[ ]*$/g,'$1'); }, //(/^\s*|\s*$/g,'');
				htmlTrim : function(){
					var str = this,
						isnb = true,
						isbr = true,
						reg = /(^&nbsp;*)|(&nbsp;*$)/g,regbr = /(<br \/>*$)/g;
					do{
						str = str.trim()
						str = str.replace('\r','').replace('\n','').trim();
						str = str.replace('\r\n','').trim();

						reg = /(^&nbsp;*)|(&nbsp;*$)/ig;
						isnb = reg.test(str);
						
						str = str.replace(reg, "").trim()
						str = str.replace('\r','').replace('\n','').trim();
						str = str.replace('\r\n','').trim();

						regbr = /(.?<br \/>$)/ig;
						isbr = regbr.test(str);
						
						str = str.replace(regbr, "").trim();
						str = str.replace('\r','').replace('\n','').trim();
						str = str.replace('\r\n','').trim();

						//alert('isbr='+isbr +' isnb='+isnb + ' str=['+str.indexOf('\r')+'-'+str.indexOf('\n')+']')

					}while(isbr == true || isnb == true);
					return str;
				},
				evalJSON : function(){ return eval('('+this+')'); },
				PxtoInt : function(){
					var px = /[0-9]\s?px$/g;
					if (px.test(this)) return parseFloat(this.replace('px',''));
					return this;
				},
				isJSON : function(){
					json = this.replace(/\\["\\\/bfnrtu]/g, '@');
					json = json.replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g, ']');
					json = json.replace(/(?:^|:|,)(?:\s*\[)+/g,'');
					return (/^[\],:{}\s]*$/.test(json));
				},
				toMid : function(len){ return this.substr(len,this.length-len-len)},
				toLen : function(){
					var len = 0;
					for(var i = 0; i < this.length; i++){ 
						len += !(this.charCodeAt(i)>255)? 1 : 2;
					}
					return len; 
				}
			})
			
			this.each(['Undefined', 'Function', 'Object', 'ObjArray', 'Empty', 'Number', 'JSON', 'Array', 'String', 'Element', 'TableIE6', 'TableIE'],function(){
				var type = this;
				xQuery.fn['is'+type] = function(o){
					return xQuery.fn.is(o, type);
				}
			});
			
			this.each(['Width','Height'],function(name,i){
				var type = name.toLowerCase();
				xQuery.fn['outer'+name] = function(){
					return this.css(type, false, 'margin');
				}
				xQuery.fn['inner'+name] = function(){
					return this.css(type, false, 'padding');
				}
				xQuery.fn[type] = function(size){
					return this.elem == window ?
					document.compatMode == "CSS1Compat" && document.documentElement["client" + name] || document.body["client" + name] :
					this.elem == document ?
						Math.max(
						document.documentElement["client" + name],
						document.body["scroll" + name],
						document.documentElement["scroll" + name],
						document.body["offset" + name],
						document.documentElement["offset" + name]
						) :
						size === undefined ? (this.length ? this.css(type, false, '') : null) : this.css(type, typeof size === "string" ? size: size + "px")
				}
			});
			
			
			this.each(['click','mousedown','mouseup','mouseover','mouseout','mousemove','keydown','keyup','blur','focus','scroll'],function(){
				var type = this;
				xQuery.fn[type] = function(func){
					return xQuery.fn.isFunction(func) ? xQuery.fn.event.add(this.elem, type, func) : xQuery.fn.event.trigger(this.elem, type); 
				}
			});

			var bw = navigator.userAgent.toLowerCase();
			Object.extend(this.Browser,{
				version: (bw.match(/.+(?:rv|it|ra|ie)[\/: ]([\d.]+)/) || [0, '0'])[1],
				safari: /webkit/i.test(bw) && !(/chrome/i.test(bw) && /webkit/i.test(bw) && /mozilla/i.test(bw)),
				sogou: /webkit/i.test(bw) && /chrome/i.test(bw) && /safari/i.test(bw) && /mozilla/i.test(bw),
				opera: /opera/i.test(bw),
				firefox:/firefox/i.test(bw.toLowerCase()),
				ie: /msie/i.test(bw) && !/opera/.test(bw),
				ie6 : ( /msie/i.test(bw) && !/opera/.test(bw) )? bw.match(/msie (\d)\.0/i)[1]==6:false ,
				mozilla: /mozilla/i.test(bw) && !/(compatible|webkit)/.test(bw) && !(/chrome/i.test(bw) && /webkit/i.test(bw) && /mozilla/i.test(bw)),
				chrome: /chrome/i.test(bw) && /webkit/i.test(bw) && /mozilla/i.test(bw),
				google: /chrome/i.test(bw) && /mozilla/i.test(bw) && /applewebkit/i.test(bw) && /safari/i.test(bw)
			})
			
			xQuery.fn['xhr'] = function(){ }
			Object.extend(xQuery.fn.xhr.prototype, {
					xmlHttp : '', q :'', inprocess : [],
					init : function(){ },
					create : function(t){
						if (this.xmlHttp && !xQuery.fn.Browser.ie6 && t!='newinall') return;
						this.xmlHttp = xQuery.fn.Try.these(
						function() {return new XMLHttpRequest()},
						function() {return new ActiveXObject('Msxml2.XMLHTTP')},
						function() {return new ActiveXObject('Microsoft.XMLHTTP')}
						) || false;
					},
					set : function(json){ //query,target,waite,callback,method,data,onbefor,onsucc,onfaild,ontimeout
						this.q = json;
					},
					get : function(json){
						this.set(json);
						this.create(this.q['newinall']);
						this.parseItem();
						this.send();
					},
					parseItem : function(){
						this.q['query'] += (this.q['query'].indexOf('?') >=0 ? '&' :'?') + 'timeStamp=' + new Date().getTime();
						this.q['process'] = this.q['query'];
						if (this.q['waite']) xQuery(this.q['target']).html(this.q['waite']);
						this.q['method'] = this.q['method'] ? this.q['method'] : 'GET';
						this.q['data'] = this.q['data'] ? this.q['data'] : null;
						if (this.q['onbefor'])this.q['onbefor']();
					},
					send : function(){
						var _self = this;
						if (this.inprocess[this.q['process']]) return;
						this.inprocess[this.q['process']] = true;
						this.xmlHttp.onreadystatechange = function(){_self.handleStateChange();}
						this.xmlHttp.open(this.q['method'], this.q['query'], true);
						this.xmlHttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
						this.xmlHttp.send(this.q['data']);
					},
					handleStateChange : function(){
						if(this.xmlHttp.readyState == 4) {
							if(this.xmlHttp.status == 200) {this.parseResults()}
							else if (this.xmlHttp.status == 404){if (this.q['onfaild']){ return this.q['onfaild']('404',this.xmlHttp.responseText) } alert('AJAX Error (error:404): \n\nRequest Server Page Not Found! ')}
							else if (this.xmlHttp.status == 500){if (this.q['onfaild']){ return this.q['onfaild']('500',this.xmlHttp.responseText) } alert('AJAX Error (error:500): \n\nRequest Server Return Error! \n\n'+this.xmlHttp.responseText)}
						}
					},
					parseResults : function(){
						var vdata = this.xmlHttp.responseText;
						var nreg = '',tsctag=/\[script\](.+?)\[\/script\]/ig,tscstag = /\[script\](.+?)\[\/script\]/ig;
						this.inprocess[this.q['process']] = false;
						if (vdata){
							xQuery.fn.regExps.init(tsctag,vdata,0);
							nreg = xQuery.fn.regExps.Match().toString();
						}
						vdata = vdata.replace(tscstag,'');
						nreg = nreg.replace(/\[script\]/ig,'').replace(/\[\/script\]/ig,'');
						this.q['target'] ? xQuery(this.q['target']).html(vdata) : '';
						if (nreg != null){ var tSyb = ';'; if (nreg.indexOf(tSyb)>0){var scAry = nreg.split(tSyb);for (var i=0; i<scAry.length;i++){if (scAry[i] != ''){try{eval(scAry[i])}catch(e){}}}}else{eval(nreg)}}
						if (this.q['onsucc']) this.q['onsucc'](vdata);
					}
			});
			this.support.init();
			Object.extend(Fn, xQuery.fn);
			Object.extend(xQuery.fn.init.prototype, xQuery.fn);
		},
		each : function(o, func, args){
			if (this.is(o, 'Function') && !(func)){ func = o; o = this.elem; }
			return this.fx.each(o || this.elem, func, args);
		},
		support : {
			isattr : true,
			isname : true,
			attr : [],
			init : function(){
				if (this.isinit) return;
				this.isinit = true;
				var input = document.createElement('input');
				input.setAttribute('class','__support_attr_class');
				if (input.className != '__support_attr_class'){
					this.isattr = false;
					this.attr = {
						'tabindex': 'tabIndex',
						'readonly': 'readOnly',
						'for': 'htmlFor',
						'class': 'className',
						'maxlength': 'maxLength',
						'cellspacing': 'cellSpacing',
						'cellpadding': 'cellPadding',
						'rowspan': 'rowSpan',
						'colspan': 'colSpan',
						'usemap': 'useMap',
						'frameborder': 'frameBorder',
						'contenteditable': 'contentEditable'
					}
				}

				if (typeof this.name != 'function') this.isname = false;
			}
		},
		
		md5 : function(val, mode){
			return val ? mode ? this.fx.MD5.get(val).toMid(8) : this.fx.MD5.get(val) : '';
		},

		slideDown : function(val, speed, callback){
		
		},

		slideUp : function(){},

		slideLeft : function(val, speed, callback){
			this.fx.animate.init(this.elem, 0-val, '', speed, callback);
		},

		slideRight : function(val, speed, callback){
			this.fx.animate.init(this.elem, val, '', speed, callback);
		},

		
		fx : {

			speed : {
			
				start : 0,
				distance : 0,
				timer : 0,
				timeoffset : 20,

				clearTimer : function(o){
					xQuery.fn.cache.remove('_animate_timeoffset', o);
				},
				
				swing: function( p, n, firstNum, diff ) {
					return ((-Math.cos(p*Math.PI)/2) + 0.5) * diff + firstNum;
				},

				init : function(obj, xpos, ypos, x, y, speed, callback, timeoffset){
					
					if (obj[0].movement) { clearTimeout(obj[0].movement); }

					if (xQuery.fn.isEmpty(y)){
						if (Math.round(xpos) == x ) {
							this.clearTimer(obj[0]);
							return callback ? callback.call(obj[0]) : true;
						}
					}else if (xQuery.fn.isEmpty(x)){
						if (Math.round(ypos) == y) {
							this.clearTimer(obj[0]);
							return callback ? callback.call(obj[0]) : true;
						}
					}else{
						if (xpos == x && ypos == y) {
							this.clearTimer(obj[0]);
							return callback ? callback.call(obj[0]) : true;
						}
					}
					
					if (!xQuery.fn.isEmpty(x)){
						var _s = speed/10;
						var dist = xQuery.fn.cache.get('_animate_xpos_dist', obj[0]);
						if (!dist) {
							dist = parseFloat((xpos < x) ? ((x - xpos)/_s).toFixed(2) : ((xpos - x)/_s).toFixed(2));
							xQuery.fn.cache.set('_animate_xpos_dist', dist, obj[0]);
						}
						xpos = (xpos < x) ? xpos = xpos + dist : xpos = xpos - dist;
						obj.css({'left' : xpos + 'px'}).html('left:'+xpos + '<br> dist :' +dist);
					}
					
					if (!xQuery.fn.isEmpty(y)){
						if (ypos < y) {
							var dist = Math.cos((y - ypos)/speed);
							ypos = ypos + dist;
						}
						if (ypos > y) {
							var dist = Math.cos((ypos - y)/speed);
							ypos = ypos - dist;
						}
						
						obj.css({'top' : ypos + 'px'}).html('top:'+ypos);
					}
					

					var _self = this;
					//var _timeout = xQuery.fn.cache.get('_animate_timeoffset', obj[0]);
					//if (xQuery.fn.isEmpty(_timeout)){
					//	_timeout = this.timeoffset - 1; //this.timeoffset -= 1;
					//}
					//_timeout = _timeout >0 ? _timeout -= 1 : _timeout += 1;
					//xQuery.fn.cache.set('_animate_timeoffset', _timeout, obj[0]);
					
					obj[0].movement = setTimeout(function(){
						_self.init(obj, xpos, ypos, x, y, speed, callback, timeoffset);
					},timeoffset);
				}
			},

			animate : {
				
				init : function(elem, x, y, speed, callback){
					var elem = xQuery.fn.isObject(elem) ? elem.id : elem
					var obj = xQuery(elem);
					if (!obj[0]) return false;
					if (obj[0].movement) { clearTimeout(obj[0].movement); }
					
					var xpos = obj.css('left'), ypos = obj.css('top');
					
					if ((xpos == 0 || xpos == 'auto') && (!xQuery.fn.isEmpty(x))) { obj.css({'left' : '0px'}) }
					if ((ypos == 0 || ypos == 'auto') && (!xQuery.fn.isEmpty(y))) { obj.css({'top' : '0px'}) }
					
					var xpos = parseFloat(obj.css('left')), ypos = parseFloat(obj.css('top'));

					if (xQuery.fn.isEmpty(x) && xQuery.fn.isEmpty(y)){
						return true;
					}

					var timeoffset = xQuery.fn.Browser.firefox ? 1 : 13;
					 //p, n, firstNum, diff 
					//alert(xQuery.fn.fx.speed.swing(1, 1, 0, 2))
					//alert(xQuery.fn.fx.speed.swing(1.9, 1, 0, 2))
					//alert(xQuery.fn.fx.speed.swing(2, 1, 0, 2))
					//alert(xQuery.fn.fx.speed.swing(2.9, 1, 0, 2))
					xQuery.fn.fx.speed.init(obj, xpos, ypos, x, y, speed, callback, timeoffset);					
				}
			},
			

			MD5 : {
				hashChr : '0123456789abcdef',
				rehex : function(num){str='';for(j=0;j<=3;j++)str+=this.hashChr.charAt((num>>(j*8+4))&0x0F)+this.hashChr.charAt((num>>(j*8))&0x0F);return str;},
				str2bytes : function(str){nbts=((str.length+8)>>6)+1;bts=new Array(nbts*16);for(i=0;i<nbts*16;i++)bts[i]=0;for(i=0;i<str.length;i++)bts[i>>2]|=str.charCodeAt(i)<<((i%4)*8);bts[i>>2]|=0x80<<((i%4)*8);bts[nbts*16-2]=str.length*8;return bts;},
				ff : function(a,b,c,d,x,s,t){return this.cmn((b&c)|((~b)&d),a,b,x,s,t)},
				gg : function(a,b,c,d,x,s,t){return this.cmn((b&d)|(c&(~d)),a,b,x,s,t)},
				hh : function(a,b,c,d,x,s,t){return this.cmn(b^c^d,a,b,x,s,t)},
				ii : function(a,b,c,d,x,s,t){return this.cmn(c^(b|(~d)),a,b,x,s,t)},
				add : function(x,y){var ts=(x&0xFFFF)+(y&0xFFFF);var tw=(x>>16)+(y>>16)+(ts>>16);return(tw<<16)|(ts&0xFFFF)},
				rol : function(num,cnt){return(num<<cnt)|(num>>>(32-cnt))},
				cmn : function(q,a,b,x,s,t){return this.add(this.rol(this.add(this.add(a,q),this.add(x,t)),s),b)},
				get : function(str){
					var a=1732584193,b=-271733879,c=-1732584194,d=271733878,x=this.str2bytes(str);
					for(i=0; i<x.length; i+=16){
						var olda=a, oldb=b, oldc=c, oldd=d;
						a=this.ff(a,b,c,d,x[i+0],7,-680876936);d=this.ff(d,a,b,c,x[i+1],12,-389564586);
						c=this.ff(c,d,a,b,x[i+2],17,606105819);b=this.ff(b,c,d,a,x[i+3],22,-1044525330);
						a=this.ff(a,b,c,d,x[i+4],7,-176418897);d=this.ff(d,a,b,c,x[i+5],12,1200080426);
						c=this.ff(c,d,a,b,x[i+6],17,-1473231341);b=this.ff(b,c,d,a,x[i+7],22,-45705983);
						a=this.ff(a,b,c,d,x[i+8],7,1770035416);d=this.ff(d,a,b,c,x[i+9],12,-1958414417);
						c=this.ff(c,d,a,b,x[i+10],17,-42063);b=this.ff(b,c,d,a,x[i+11],22,-1990404162);
						a=this.ff(a,b,c,d,x[i+12],7,1804603682);d=this.ff(d,a,b,c,x[i+13],12,-40341101);
						c=this.ff(c,d,a,b,x[i+14],17,-1502002290);b=this.ff(b,c,d,a,x[i+15],22,1236535329);
						a=this.gg(a,b,c,d,x[i+1],5,-165796510);d=this.gg(d,a,b,c,x[i+6],9,-1069501632);
						c=this.gg(c,d,a,b,x[i+11],14,643717713);b=this.gg(b,c,d,a,x[i+0],20,-373897302);
						a=this.gg(a,b,c,d,x[i+5],5,-701558691);d=this.gg(d,a,b,c,x[i+10],9,38016083);
						c=this.gg(c,d,a,b,x[i+15],14,-660478335);b=this.gg(b,c,d,a,x[i+4],20,-405537848);
						a=this.gg(a,b,c,d,x[i+9],5,568446438);d=this.gg(d,a,b,c,x[i+14],9,-1019803690);
						c=this.gg(c,d,a,b,x[i+3],14,-187363961);b=this.gg(b,c,d,a,x[i+8],20,1163531501);
						a=this.gg(a,b,c,d,x[i+13],5,-1444681467);d=this.gg(d,a,b,c,x[i+2],9,-51403784);
						c=this.gg(c,d,a,b,x[i+7],14,1735328473);b=this.gg(b,c,d,a,x[i+12],20,-1926607734);
						a=this.hh(a,b,c,d,x[i+5],4,-378558);d=this.hh(d,a,b,c,x[i+8],11,-2022574463);
						c=this.hh(c,d,a,b,x[i+11],16,1839030562);b=this.hh(b,c,d,a,x[i+14],23,-35309556);
						a=this.hh(a,b,c,d,x[i+1],4,-1530992060);d=this.hh(d,a,b,c,x[i+4],11,1272893353);
						c=this.hh(c,d,a,b,x[i+7],16,-155497632);b=this.hh(b,c,d,a,x[i+10],23,-1094730640);
						a=this.hh(a,b,c,d,x[i+13],4,681279174);d=this.hh(d,a,b,c,x[i+0],11,-358537222);
						c=this.hh(c,d,a,b,x[i+3],16,-722521979);b=this.hh(b,c,d,a,x[i+6],23,76029189);
						a=this.hh(a,b,c,d,x[i+9],4,-640364487);d=this.hh(d,a,b,c,x[i+12],11,-421815835);
						c=this.hh(c,d,a,b,x[i+15],16,530742520);b=this.hh(b,c,d,a,x[i+2],23,-995338651);
						a=this.ii(a,b,c,d,x[i+0],6,-198630844);d=this.ii(d,a,b,c,x[i+7],10,1126891415);
						c=this.ii(c,d,a,b,x[i+14],15,-1416354905);b=this.ii(b,c,d,a,x[i+5],21,-57434055);
						a=this.ii(a,b,c,d,x[i+12],6,1700485571);d=this.ii(d,a,b,c,x[i+3],10,-1894986606);
						c=this.ii(c,d,a,b,x[i+10],15,-1051523);b=this.ii(b,c,d,a,x[i+1],21,-2054922799);
						a=this.ii(a,b,c,d,x[i+8],6,1873313359);d=this.ii(d,a,b,c,x[i+15],10,-30611744);
						c=this.ii(c,d,a,b,x[i+6],15,-1560198380);b=this.ii(b,c,d,a,x[i+13],21,1309151649);
						a=this.ii(a,b,c,d,x[i+4],6,-145523070);d=this.ii(d,a,b,c,x[i+11],10,-1120210379);
						c=this.ii(c,d,a,b,x[i+2],15,718787259);b=this.ii(b,c,d,a,x[i+9],21,-343485551);
						a=this.add(a,olda);b=this.add(b,oldb);c=this.add(c,oldc);d=this.add(d,oldd);
					}
					return this.rehex(a)+this.rehex(b)+this.rehex(c)+this.rehex(d);
				}
			},
			
			ready : {
				isready : [],
				events : [],
				timer : [],
				bind : function(elem, func){
					var elem = elem || document, args = elem;
					if (xQuery.fn.isElement(elem)){
						elem = xQuery(['script', 'link', 'img', 'iframe']).contains(xQuery(elem).tag()) ? elem : document;
					}
					this.doLoad(elem, func, args);
				},
				
				set : function(elem, t){
					this.isready[elem] = true;
				},
				get : function(elem){
					xQuery(this.isready).each(function(){
						if (this == elem){
							return true;
						}
					})
					return this.isready[this.isready.length] = this.elem;
				},
					
				reset : function(elem){
					this.isReady[elem] = false;
				},				

				doLoad : function(elem, func, args){
					var callElem = args? args : elem, _self = this;
					if (this.get(elem)){ return func.call(callElem) }
					if (elem.attachEvent){
						elem.attachEvent("onreadystatechange",
						function() {
							if (xQuery(['complete','loaded']).contains(elem.readyState)) {
								elem.detachEvent("onreadystatechange", arguments.callee);
								_self.set(callElem);
								return func.call(callElem);
							}
						});
					}else if (elem.addEventListener) {
						if (elem == document){
							var isreadystatechange = false;
							elem.addEventListener('readystatechange',
							function() {
								if (xQuery(['complete','interactive']).contains(elem.readyState)) {
									elem.removeEventListener("readystatechange", arguments.callee);
									if (isreadystatechange) return;
									isreadystatechange = true;
									_self.set(callElem);
									return func.call(callElem);
								}
							}, false);
							
							elem.addEventListener('DOMContentLoaded',
							function() {
								try{elem.removeEventListener("DOMContentLoaded", arguments.callee)}catch(e){}
								if (isreadystatechange) return;
								isreadystatechange = true;
								_self.set(callElem);
								return func.call(callElem);
							}, false);

						}else if ((xQuery(['script']).contains(("" || elem.tagName).toLowerCase()))){
							elem.onload = function(){ return func.call(this)}
						}else if ((xQuery(['link']).contains(("" || elem.tagName).toLowerCase()))){
							var isLoaded = false;
							try{
								if (xQuery.fn.isObject(elem.sheet) || (elem.sheet && elem.sheet.cssRules)){
									isLoaded = true;
								}else if (elem.styleSheet && elem.styleSheet.cssText.length > 0){
									isLoaded = true;
								}else if (elem.innerHTML && elem.innerHTML.length > 0){
									isLoaded = true;
								}
							} catch(ex){alert(ex.code); if (ex.code == 1000) isLoaded = true; }
							
							
							if (isLoaded){
								if (this.timer[elem.href]) clearTimeout(this.timer[elem.href]);
								return func.call(callElem);
							}else{
								this.timer[elem.href] = setTimeout(function(){ xQuery(elem).ready(func); }, 100);
							}
						}else{
							xQuery.event.add(elem, 'load', function(){_self.set(callElem); return func.call(callElem); });
						}
					}
				},
				
				onLoad : function(){
					xQuery.fn.each(this.events,function(o,i){
						return o.call(document,xQuery);
					});
					this.set(this.events);
				}
			},
			
			getoffset : function(elem) {
				var obj = this.obj(elem);
				var et = obj.offsetTop,el = obj.offsetLeft,eh = obj.offsetHeight,ew = obj.offsetWidth;
				while(obj = obj.offsetParent){
					et += obj.offsetTop;
					el += obj.offsetLeft;
					eh += obj.offsetHeight;
					ew += obj.offsetWidth;
				}
				return {top:et,left:el,height:eh,width:ew}
			},
			each : function(o, func, args){
				if (o == null) return false;
				var re = '';
				if (xQuery.fn.is(args, 'Undefined')) {
					if (xQuery.fn.is(o, 'Function') && o.call) {
						
					} else if (!xQuery.fn.is(o.length, 'Undefined')) {
						for (i = 0; i < o.length; i++) {
							re = func.call(o[i], xQuery.fn.is(o, 'String')? o.charAt(i) : o[i] , i, o);
							if (re === false) break; 
						}
					} else if(xQuery.fn.is(o, 'JSON')){
						for (var i in o) {
							re = func.call(o[i], i, o[i], o);
							if (re === false) break; 
						}
					} /*else if (xQuery.fn.isFunction(o.forEach) && o.forEach != arguments.callee) {
						return o.forEach(func, args);
					}*/
				}else{
					
					for (var i in o) {
						if (o.hasOwnProperty(i)) {
							re = func.call(args ? args : o[i], o[i], i, o);
							if (re === false) break; 
						}
					}
				}
				return o;
			},
			attr : function( elem, json, val ){
				var obj = elem;
				if (!xQuery.fn.isObject(obj)) return false;
				if (!xQuery.fn.isUndefined(val)){
					obj.setAttribute(json, ''+val);
				}else{
					if (xQuery.fn.isJSON(json)){
						if (!xQuery.fn.isObject(json)) json = json.evalJSON();
						var _attr = xQuery.fn.support.isattr ? [] : xQuery.fn.support.attr;
						for(var i in json){ obj.setAttribute( _attr[i] || i, ''+json[i]); }
					}else{
						try{return obj.getAttribute(json)}catch(e){ alert((obj.name || obj.id || 'nodetype=' + obj.nodeType) +' ['+ typeof obj +'] : '+ e.message)};
					}
				}
				return false;
			},
			getCss : function( elem, node ){
				var obj = elem;
				if (!xQuery.fn.isObject(obj) || !node) return false;
				if (obj.style[node]){
					return obj.style[node].toString().PxtoInt();
				}else if (obj.currentStyle) {
					re = obj.currentStyle[node];
					unode = node.replace(node.substring(0,1), node.substring(0,1).toUpperCase());
					return (re?(re=='auto'?obj['offset'+unode]?obj['offset'+unode]:0:re):0).toString().PxtoInt(); 
				}else if (document.defaultView && document.defaultView.getComputedStyle) {
					if (node.match(/float/i)) node = "float";
					node = node.replace(/([A-Z])/g,'-$1').toLowerCase();
					if (node.indexOf('-')==0){ node = node.substr(1)}
					var s = document.defaultView.getComputedStyle(obj,'');
					return s && s.getPropertyValue(node).PxtoInt();
				} else {
					return null;
				}
			},
			css : function( elem, json, val ){
				var obj = elem;
				if (!xQuery.fn.isObject(obj) || !json || obj.nodeType != 1) return obj;
				if (val){
					obj.style[json.toLowerCase()] = val;
				}else{
					var isjson = false;
					if (!xQuery.fn.isJSON(json)) {
						if (typeof json =='string'){
							if (json.indexOf(':')>0){
								try{ json = json.evalJSON();isjson = true; }catch(e){ isjson = false }
							}
						}else{
							
						}
						if (!isjson) return this.getCss(obj, json);
					}
					for(var i in json){obj.style[i] = json[i]}
				}
			}
		}
	}
	
})();

xQuery.fn.Extend();
