var suggest =
{
	line : 0,
	count : 0,
	keyword : "",
	type : "all",
	move : function (_evt)
	{
		switch (_evt.keyCode)
		{
			case 38: //up
				if (this.line > 1)
				{
					document.getElementById("suggest_"+this.line).className = "";
					this.line = this.line - 1;
					document.getElementById("suggest_"+this.line).className = "table_current";
				}
				break;
			case 40: //down
				if (this.line > 0 && this.line < this.count)
				{
					document.getElementById("suggest_"+this.line).className = "";
				}
				if (this.line < this.count)
				{
					this.line = this.line + 1;
					document.getElementById("suggest_"+this.line).className = "table_current";
				}
				break;
			case 13: //enter
				if (this.line >= 1 && this.line <= this.count)
				{
					document.finance_search.select_type.disabled = false;
					document.finance_search.select_code.disabled = false;
					
					document.getElementById("keyword").value = suggest_json[this.line-1]["n"];
					
					document.finance_search.select_type.value = suggest_json[this.line-1]["t"];
					document.finance_search.select_code.value = suggest_json[this.line-1]["c"];
					
				}	
				break;
			default:
				
				break;
		}

	},
	display : function (_display)
	{
		if (_display == "inline")
		{
			var table_html = document.getElementById("suggest_list_finance").innerHTML;
			if (table_html != "")
			{
				document.getElementById("suggest_list_finance").style.display = _display;
			}
		}
		else if (_display == "none")
		{
			document.getElementById("suggest_list_finance").style.display = _display;
		}
	},
	mark_keyword : function (_str, _keyword)
	{
		return _str.replace(_keyword, "<span style=\"color:red;\">"+_keyword+"</span>");
	},
	work : function ()
	{
		var _type_conf = {"stock":"股票","fund":"基金"};

		var table_html = "";

		this.line = 0;
		this.count = 0;

		document.finance_search.select_type.disabled = true;
		document.finance_search.select_code.disabled = true;
		document.finance_search.select_type.value = "";
		document.finance_search.select_code.value = "";
		
		for(var i=0; i<suggest_json.length; i++)
		{
			this.count++;

			var code = suggest_json[i]["c"];
			var symbol = suggest_json[i]["s"];
			var name = suggest_json[i]["n"];
			var pinyin = suggest_json[i]["p"];
			var type = suggest_json[i]["t"];
			
			var _type = _type_conf[type];

			var bgcolor = "";

			if (type == "forex")
			{
				table_html += "  <tr id=\"suggest_"+(parseInt(i)+1)+"\" onmouseover=\"javascript:this.className='current';this.style.cursor='pointer'\" onmouseout=\"javascript:this.className=''\" onclick=\"javascript:window.open('http://finance.ifeng.com/app/hq/"+type+"/"+symbol+"/')\" >";
			}
			else 
			{
				var code_begin = code.substring(0,4);
				var open_url = null;

				table_html += "  <tr id=\"suggest_"+(parseInt(i)+1)+"\" onmouseover=\"javascript:this.className='table_current';this.style.cursor='pointer'\" onmouseout=\"javascript:this.className=''\" onclick=\"suggest.go(this);\" >";
			}
			table_html += "    <td "+bgcolor+">"+suggest.mark_keyword(symbol.toUpperCase(), this.keyword.toUpperCase())+"</td>";
			table_html += "    <td "+bgcolor+">"+suggest.mark_keyword(name, this.keyword)+"</td>";
			table_html += "    <td "+bgcolor+">"+suggest.mark_keyword(pinyin.toUpperCase(), this.keyword.toUpperCase())+"</td>";
			//table_html += "    <td "+bgcolor+">"+_type+"</td>";
			table_html += "  </tr>";

		}
		if (table_html != "")
		{
			table_html = "<div style=\"opacity: 0.95; position: absolute; width: 220px; z-index: 999; top: 0px; left: 71px; margin-top: 26px; \"><table style=\"border-collapse:collapse; line-height:18px; border:1px solid #dcdcdc; border-bottom:2px solid #dcdcdc; background-color:#FFF; font-size:12px; text-align:center; color:#333; width:218px;\"><tr class=\"head\" style=\"background-color:#eee;\"><td width=\"54\">代码</td><td width=\"70\">名称</td><td width=\"60\">拼音</td>"+table_html+"</table></div>";
		}
		document.getElementById("suggest_list_finance").innerHTML = table_html;
		if (table_html != "")
		{
			suggest.display("inline");
		}
		else
		{
			suggest.display("none");
		}
	},
	typewrite : function (_keyword)
	{
		if (_keyword != this.keyword)
		{
			this.keyword = _keyword;
			
			var oHead = document.getElementsByTagName('HEAD').item(0);
			var oScript = document.createElement("script");
			oScript.type = "text/javascript";
			oScript.src = "http://app.finance.china.com.cn/search/suggest.php?type="+this.type+"&keyword="+_keyword+"&cb=suggest.work();&rid="+Math.random();
			oHead.appendChild(oScript); 
		}
	},
	
	go : function (current_obj)
	{
		var item_id = jQuery(current_obj).attr("id");
		var line = item_id.split("_");
		
		if (line[1] >= 1 && line[1] <= this.count)
		{
			document.finance_search.select_type.disabled = false;
			document.finance_search.select_code.disabled = false;
					
			document.getElementById("keyword").value = suggest_json[line[1]-1]["n"];
					
			document.finance_search.select_type.value = suggest_json[line[1]-1]["t"];
			document.finance_search.select_code.value = suggest_json[line[1]-1]["c"];
		}
	} 
}
