var J1616 = window.J1616 || {};
J1616 = {
    obj2str: function(o) {
        var r = [];
        if (typeof o == "string") return quote(o);
        if (typeof o == "undefined") return "undefined";
        if (typeof o == "object") {
            if (o === null) return "null";
            else if (!o.sort) {
                for (var i in o) r.push(this.obj2str(i) + ":" + this.obj2str(o[i]));
                r = "{" + r.join() + "}";
            } else {
                for (var i = 0; i < o.length; i++) r.push(this.obj2str(o[i]));
                r = "[" + r.join() + "]";
            }
            return r;
        }
        return o.toString();
        function quote(string) {
           //*change*/ var escapable = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g;
			var escapable = /[\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g;
            var meta = {
                '\b': '\\b',
                '\t': '\\t',
                '\n': '\\n',
                '\f': '\\f',
                '\r': '\\r',
                '"': '\\"',
                '\\': '\\\\'
            };
            escapable.lastIndex = 0;
            return escapable.test(string) ? '"' + string.replace(escapable,
            function(a) {
                var c = meta[a];
                return typeof c === 'string' ? c: '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice( - 4);
            }) + '"': '"' + string + '"';
        }
    },
    str2obj: function(str) {
        try {
            if (str) {
                return eval('(' + str + ')');
            }
        } catch(ex) {}
        return null;
    },
    getType: function(o) {
        var s = Object.prototype.toString,
        t = {
            'undefined': 'undefined',
            'number': 'number',
            'boolean': 'boolean',
            'string': 'string',
            "[object Function]": "function",
            "[object RegExp]": "regexp",
            "[object Array]": "array",
            "[object Date]": "date",
            "[object Error]": "error"
        };
        return t[typeof o] || t[s.call(o)] || (o ? 'object': 'null');
    },
    unique: function(array) {
        var l = array.length;
        if (l < 2) return [array[0]] || [];
        var o = {};
        for (var i = 0,
        j = 0; i < l; i++) {
            if (typeof o[array[i]] === 'undefined') {
                o[array[i]] = j++;
            }
        }
        array.length = 0;
        for (var k in o) {
            array[o[k]] = k;
        }
        return array;
    },
    sortNum: function(array, f) {
        if (!f) f = 0;
        if (f == 1) return array.sort(function(a, b) {
            return b - a;
        });
        return array.sort(function(a, b) {
            return a - b;
        });
    },
    getMax: function(array) {
        return this.sortNum(array, 1)[0];
    },
    cutStr: function(s, length, postfix) {
        if (typeof(s) != "string") return s;
        postfix = postfix ? postfix: "";
        if (!s || !length) {
            return "";
        }
        var len = 0,
        temp = "";
        for (var i = 0; i < s.length; i++) {
            if (s.charCodeAt(i) > 255) {
                len += 2;
            } else {
                len++;
            }
            if (len > length) {
                return temp + postfix;
            }
            temp += s.charAt(i);
        }
        if (s.length > length) {
            return s.substr(0, length) + postfix;
        } else {
            return s;
        }
    },
    getRandom: function(a, b) {
        var a = parseFloat(a);
        var b = parseFloat(b);
        return Math.random() * (a - b) + b;
    },
    removeArrayItem: function(array, dx) {
        if (isNaN(dx) || dx > array.length || dx < 0) {
            return false;
        }
        return array.splice(dx, 1);
    }
};
J1616.Util = {
    _import: function() {
        var h = document.getElementsByTagName("head")[0],
        self = arguments.callee,
        T = arguments.length,
        n = 0,
        fnback;
        J1616.getType(arguments[arguments.length - 1]) == "function" ? (fnback = arguments[arguments.length - 1], T--) : null;
        for (var i = 0; i < T; i++) {
            var arg = arguments[i];
            var sp = arg["src"].indexOf("?") == -1 ? "?": "&";
            var _src = arg["src"] + sp + "v=" + arg["version"];
            if (!self[_src]) {
                var s = document.createElement("SCRIPT");
                s.src = _src;
                h.insertBefore(s, h.firstChild);
                s.onload = s.onreadystatechange = function() {
                    if (s.readyState) {
                        if (s.readyState == 'loaded' || s.readyState == 'complete') {++n == T && fnback();
                        }
                    } else {++n == T && fnback();
                    }
                };
                self[_src] = s;
            } else {++n == T && fnback();
            }
        }
    },
    _checkImport: function(src, version) {
        return !! this._import[src + "?v=" + version];
    },
    console: function(type, message) {
        if (window.console) window.console[type](message);
    },
    setCookie: function(n, v, e, p, d, s) {
        if (!e) e = 365;
        if (!p) p = '/';
        e = e * 1000 * 60 * 60 * 24;
        var e_date = new Date(new Date().getTime() + (e));
        document.cookie = n + '=' + encodeURIComponent(v) + ((e) ? ';expires=' + e_date.toGMTString() : '') + ((p) ? ';path=' + p: '') + ((d) ? ';domain=' + d: '') + ((s) ? ';secure': '');
    },
    getCookie: function(n) {
        var c = document.cookie.split("; ");
        for (var i = 0; i < c.length; i++) {
            var p = c[i].split("=");
            if (n == p[0]) try {
                return decodeURIComponent(p[1])
            } catch(e) {
                return null
            }
        }
        return null;
    },
    deleteCookie: function(name, path, domain) {
        if (this.getCookie(name)) document.cookie = name + "=" + encodeURIComponent(this.getCookie(name)) + ((path) ? ";path=" + path: "") + ((domain) ? ";domain=" + domain: "") + ";expires=Thu, 01-Jan-1970 00:00:01 GMT";
    },
    getDomain: function() {
        return "." + location.hostname.split(".").slice( - 2).join(".");
    },
    loadImage: function(srcs, callback) {
        var loadedNum = 0;
        for (var key in srcs) {
            var imageLoader = new Image();
            imageLoader.onload = function() {
                loadedNum++;
                if (loadedNum == srcs.length && callback) callback();
            };
            imageLoader.src = srcs[key];
        }
    },
    setHome: function(o, r) {
        o.target = "_self";
        var bbs = "http://bbs.1616.net/thread-1913-1-4.html";
        try {
            if (document.all && !external.max_version) {
                o.style.behavior = 'url(#default#homepage)';
                o.setHomePage(r ? r: location.href);
            } else window.open(bbs);
        } catch(e) {
            if (document.all) {
                o.style.behavior = 'url(#default#homepage)';
                o.setHomePage(r ? r: location.href);
            } else window.open(bbs);
        }
    },
    getQueryString: function(name) {
        var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
        var r = window.location.search.substr(1).match(reg);
        if (r != null) return r[2];
        return "";
    },
    showWindow: function(cfg) {
        var root = J1616.Const.getConst("root");
        var self = this;
        var Status = {
            normal: ["1616.net", "normal_pic.gif"],
            info: ["\u63D0\u793A", "normal_pic.gif"],
            success: ["\u6210\u529F", "success_pic.gif"],
            error: ["\u9519\u8BEF", "error_pic.gif"],
            alert: ["\u8B66\u544A", "alert_pic.gif"],
            confirm: ["\u8BF7\u786E\u8BA4", "confirm_pic.gif"],
            loading: ["\u52A0\u8F7D\u4E2D...", "loading_pic.gif"],
            nopic: ["", ""]
        };
        if (cfg.message) {
            var img = Status[cfg.infoType][1];
            cfg.html = "<table width='100%' height='100%' border='0'><tr><td valign='middle' align='center'>" + ["", "<img src='" + root + "style/others/alert_skin/status/" + img + "' />"][ + !!img] + "</td><td><p style='padding:0 10px; line-height:24px; font-size:12px;'>" + cfg.message + "</p></td></tr></table>";
            cfg.title = Status[cfg.infoType][0];
        }
        if (cfg.iframe) {
            cfg.html = "<img style='position:absolute;top:50%;margin-top:-40px;left:50%; margin-left:-40px;' src='http://i.9533.com/www/img/music/loadding.gif'/><iframe frameborder='0' scrolling='no' style='height:100%; width:100%;' src='" + cfg.iframe + "'></iframe>"
        }
        var ns = location.href.split('.')[1];
        cfg.root = root + "style" + ((ns == '1616' || ns == '1616dh' || ns == 'wo116') ? '': '_' + ns) + "/others/";
        if (self._checkImport(root + "js/control_dialog.js", "1.0.1")) {
            Action();
        } else {
            this._import({
                src: root + "js/control_dialog.js",
                version: "1.0.1"
            },
            Action);
        }
        function Action() {
            var Alert = new Alert1616(cfg);
            Alert._Set("root", cfg.root)._Set("Status", Status).Show().Theme(cfg.theme || "green");
            self.hideWindow = function() {
                Alert.Destroy();
            };
            if (Alert.options.autoClose && Alert.options.autoClose != 0) {
                Alert.timer = setTimeout(self.hideWindow, cfg.autoClose)
            }
            if (Alert.options.goUrl && Alert.options.goUrl != "") {
                Alert.timer = setTimeout('window.location.assign("' + cfg.goUrl + '")', Alert.options.autoClose);
            }
        }
    },
    hideWindow: function() {}
};
J1616.Const = (function() {
    var Constants = {
        root: "http://i.9533.com/",
        crossDomainSwfId: "clockswf",
        cookies: ["J1616_www_my1616", "J1616_www_appVersions", "", ""],
        preLoadImages: ["/img/loading_big.gif"]
    };
    var tmpObj = {};
    tmpObj.getConst = function(name) {
        return Constants[name];
    };
    return tmpObj;
})();