//搜索参数配置
var searchConfig = {
     baidu: {
        action: "http://www.baidu.com/s",
        name: "wd",
        btn: "百度一下",
        parm : {
            'tn':'ylmf_4_pg',
            'ch':7,
            'ie':'utf-8'
        }
    },
    sogou: {
        action: "http://www.sogou.com/sogou",
        name: "query",
        btn: "搜 索",
        parm : {
            'pid':'sogou-site-b432f34c5a997c8e'
        }
    }
}
// 项部搜索
var TopSearch = (function(){
    var search = function(){
        var sPar = $('#J_sType').find('span'),
            sChi = $('#J_sType').find('div.type-select'),
			sTips = $('#J_tips'),
			sIpt = $('#J_sKey');
        var over = false;
        sPar.click(function(){
            var state = sChi.css('display');
            (state == 'none' || state == '') ? sChi.show() : sChi.hide();
        });
        sChi.find('ul a').click(function(){
            var rel = $(this).attr('rel');
            setForm(searchConfig[rel]);
            $('#J_sClass').val(rel);
            sPar.html($(this).html());
            sChi.hide();
            return false;
        });
        $('#J_sType').hover(
            function(){ over = true;},
            function(){ over = false;}
        );
		sIpt.val('').focus(function(){
			sTips.hide();
		}).blur(function(){
			if($(this).val() === '' || $(this).val() === null){
				sTips.show();
			}
		})
        $(document).bind('click',function(){
            if(!over) sChi.hide();
        });
    }
    var setForm = function(data){
        $('#J_sForm').attr('action',data.action);
        $('#J_sKey').attr('name',data.name);
        $('#J_sBtn').val(data.btn);
        $('#J_sForm').find('input[type="hidden"]').remove();
        for (var item in data.parm) {
            $('#J_sForm').append('<input type="hidden" name="'+item+'" value="'+data.parm[item]+'" />');
        }
    }
    return {
        Init : function(){
            search();
        }
    }
})();
// TAB 切换
var Taber = {
    init : function(opt){
		var num = 0;
        if(!opt) 
		opt = {
			til:undefined,
			conClass:undefined,
			tilCur:'current' || undefined
		};
        opt.til.each(function(){
            var that = this;
            Taber.evtHover(that,function(){
                opt.conClass.hide();
                $('#'+$(that).attr('rel')).show();
                opt.til.removeClass(opt.tilCur);
                $(that).addClass(opt.tilCur);
            });
        });
    },
    evtHover : function(ele,fn){
        var evt = ["click", "mouseover"], 
            MouseDelayTime = 300, //鼠标延停时间
            waitInterval;
        for(var i=0;i<evt.length;i++){
            var element = evt[i];
            switch (element) {
                case "click":
                    if(waitInterval){
                        window.clearTimeout(waitInterval);
                    }
                    $(ele).bind('click',fn);
                    break;
                case "mouseover":
                    $(ele).bind('mouseover',function(){
                        if(waitInterval){
                            window.clearTimeout(waitInterval);
                        }
                        waitInterval = window.setTimeout(fn, MouseDelayTime);
                    });
                    $(ele).bind('mouseout',function(){
                        if (waitInterval != undefined) {
                            window.clearTimeout(waitInterval);
                        }
                    });
                    break;
            }
        }
    }
}

var goTop = function(){
$("div.J_goTop a").click(function() {
	var doc = $(document).find("html,body");
	if (doc.filter(":animated").size()) {
		doc.stop()
	}
	doc.animate({
		scrollTop: 0
	},
	600);
		return false;
	});
}
$(function(){
	TopSearch.Init();
	goTop(); 
	if(typeof($("#J_sB_tab li"))!='undefined'){
		$("#J_sB_tab li").click(function(){
			$(this).parent().find("li").removeClass("active");
			$(this).addClass("active");
		})
	}
});

/**ie6 png**/
var pngfix = function(img){
	if (window.XMLHttpRequest) {return}
	if($.browser.msie && $.browser.version == 6){
		var imgStyle = "display:inline-block; " + img.style.cssText;
		var strNewHTML = "<span class=\"" + img.className + "\" title=\"" + img.title + "\" style=\"width:" + img.clientWidth + "px; height:" + img.clientHeight + "px;" + imgStyle + ";" + "filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + img.src + "', sizingMethod='scale');\"></span>";
		img.outerHTML = strNewHTML;
    }
}