
/*----------------extend--------------------------------*/
(function () {

    function extend(destination, source) {
        for (var property in source)
            destination[property] = source[property];
        return destination;
    }

    extend(Object, {
        extend: extend
    });
})();
Object.extend(String, (function () {
    function format(exp) {
        var v = Array.prototype.slice.call(arguments, 1);

        return exp.replace(/{\d}/g, function (holder) {
            var index = holder.charAt(1);
            return v[index];
        });

    }
    return {
        format: format
    }
})());

/*--------------hao----------------------------*/
window.Hao = window.Hao || {};
Hao.DataLoader = function () {
    function createXHR() {
        if (typeof XMLHttpRequest != "undefined") {
            createXHR = function () { return new XMLHttpRequest(); }
        }
        else {
            createXHR = function () { return new ActiveXObject('Msxml2.XMLHTTP'); }
        }
        return createXHR();
    }
    function serialize(serealizeForm) {
        if (!serealizeForm) {
            return null;
        }
        var elems = serealizeForm.getElementsByTagName('*')
        result = [],
             formatString = '{0}={1}';
        for (var i = 0; i < elems.length; i++) {
            if (!elems[i].name) { continue; }
            switch (elems[i].type) {
                case 'textarea':
                case 'text':
                case 'hidden':
                    result.push(String.format(formatString, elems[i].name, encodeURIComponent(elems[i].value)));
                    break;
                case 'checkbox':
                case 'radio':
                    if (elems[i].checked) {
                        result.push(String.format(formatString, elems[i].name, encodeURIComponent(elems[i].value)));
                    }
                    break;
                case 'select':
                    result.push(String.format(formatString, elems[i].name, encodeURIComponent(elems[i].options[elems[i].selectedIndex].value)));
                    break;
                default:
                    break;
            }

        }
        return result.join('&');
    }
    return {
        load: function (arg) {
            var xhr = createXHR(),
                    requestURL = arg.requestURL,
                    callBack = arg.callBack,
                    errorCallBack = arg.errorCallBack,
                    isGet = arg.isGet === undefined ? true : arg.isGet,
                    parameter = arg.parameter,
                    isText = arg.isText === undefined ? true : arg.isText,
                    isAsyn = arg.isAsyn === undefined ? true : arg.isAsyn,
                    postForm = arg.postForm,
                    postValue=arg.postValue,
                    serverTime;
                 
            if (isGet) {
                xhr.open('get', requestURL, isAsyn);
                xhr.send(null);
            }
            else {
                xhr.open('post', requestURL, isAsyn);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                xhr.send(postForm?serialize(postForm):postValue);
            }

            if (!isAsyn) {
                if (xhr.status >= 200 && xhr.status < 300 || xhr.status == 304) {
                    serverTime = new Date(xhr.getResponseHeader('Date'));
                    if (isText) {
                        return { data: xhr.responseText, time: serverTime };
                    }
                    else {
                        return { data: xhr.responseXML, time: serverTime };
                    }
                }
                else {
                    return { data: null, status: xhr.status };
                }
            }

            xhr.onreadystatechange = function () {
            
                if (xhr.readyState == 4) {
                  
                    serverTime = new Date(xhr.getResponseHeader('Date'));
                    if (xhr.status >= 200 && xhr.status < 300 || xhr.status == 304) {
                        if (isText) {
                            callBack({ data: xhr.responseText, time: serverTime });
                        }
                        else {
                            callBack({ data: xhr.responseXML, time: serverTime });
                        }
                    }
                    else if (errorCallBack) {
                  
                        errorCallBack(xhr.status)
                    }
                }
            };
        }
    };
};
/* help: no*/
Hao.ScriptLoader = function (arg) {
    arg = arg || {};
    var doc = document, script = null, isIE = /\w/.test('\u0130'), head = doc.getElementsByTagName("head")[0], onSuccess = arg.onSuccess, onError = arg.onError, onRequest = arg.onRequest;
    function setScript(script) {
        script.type = "text/javascript";
        script.onload = script.onreadystatechange = function () {
            if (script.readyState && script.readyState == "loading") {
                return;
            }
            if (onSuccess && typeof onSuccess === 'function') {
                onSuccess();
            }

        };
        if (onError && typeof onError === 'function') {
            script.onerror = function () {
                onError();
            }
        }
    }
    return {
        request: function (url) {
            var newScript = null;
            if (script === null) {
                script = doc.createElement('script');
                setScript(script);
                script.src = url;

                head.appendChild(script);

            }
            else if (isIE) {
                script.src = url;
            }
            else {
                newScript = doc.createElement('script');
                setScript(newScript);
                newScript.src = url;
                head.replaceChild(newScript, script);
                script = newScript;
            }
            if (onRequest && typeof onRequest === 'function') {
                onRequest();
            }
        }
    };
};
/*---------from yuji--------------------*/

var UA = (function (WIN, UA) {
    var key = {		//关键字常量
        ie: "msie",
        sf: "safari",
        tt: "tencenttraveler"
    },

    //正则列表
		reg = {
		    browser: "(" + key.ie + "|" + key.sf + "|firefox|chrome|opera)",
		    shell: "(maxthon|360se|theworld|se|theworld|greenbrowser|qqbrowser)",
		    tt: "(tencenttraveler)",
		    os: "(windows nt|macintosh|solaris|linux)"
		},

    //ua匹配方法
		uaMatch = function (str) {
		    var reg = new RegExp(str + "\\b[ \\/]?([\\w\\.]*)", "i"),
				result = UA.match(reg);
		    return result ? result.slice(1) : ["", ""];
		},

    //特殊浏览器检测
		is360 = function () {

		    //高速模式
		    var result = UA.toLowerCase().indexOf("360chrome") > -1 ? !!1 : !1,
				s;

		    //普通模式
		    try {
		        if (WIN.external && WIN.external.twGetRunPath) {
		            s = WIN.external.twGetRunPath;
		            if (s && s.toLowerCase().indexOf("360se") > -1) {
		                result = !!1;
		            }
		        }
		    } catch (e) {
		        result = !1
		    }
		    return result;
		} (),

    //特殊检测maxthon返回版本号
		maxthonVer = function () {
		    try {
		        if (/(\d+\.\d)/.test(external.max_version)) {
		            return parseFloat(RegExp['\x241']);
		        }
		    } catch (e) { }
		} (),

		browser = uaMatch(reg.browser),
		shell = uaMatch(reg.shell),
		os = uaMatch(reg.os);

    //修正部分IE外壳浏览器
    if (browser[0].toLowerCase() === key.ie) {

        //360
        if (is360) {
            shell = ["360se", ""];
        } else if (maxthonVer) {
            shell = ["maxthon", maxthonVer];
        } else if (shell == ",") {
            shell = uaMatch(reg.tt);
        }
    } else if (browser[0].toLowerCase() === key.sf) {

        //特殊处理sf的version
        browser[1] = uaMatch("version") + "." + browser[1];
    }

    return {
        browser: browser.join(","),
        shell: shell.join(","),
        os: os.join(",")
    };
})(window, navigator.userAgent);

var indexSetHome = {

    //配置跳转锚点
    config: {

        //配置帮助页面地址
        helpUrl: "http://www.hao123.com/redian/sheshouyef.htm",

        //外壳浏览器
        shell: {
            //360
            "360se": "02",
            "maxthon": "03",
            //搜狗
            "se": "04",
            "qqbrowser": "05",
            "theworld": "10",
            "greenbrowser": "12"
        },

        //内核浏览器
        browser: {
            "firefox": "ff",
            "chrome": "08",
            "opera": "09",
            "safari": "11"
        }
    },

    //设置主页或跳转方法
    set: function (el, url) {

        //浏览器
        var browser = UA.browser.split(",")[0].toLowerCase(),

        //外壳
			shell = UA.shell.split(",")[0].toLowerCase(),

			config = this.config,

			helpUrl = config.helpUrl,

			errorTip = "您的浏览器不支持，请手动设置",

			setForIE = function () {
			    try {
			        el.style.behavior = 'url(#default#homepage)';
			        el.setHomePage(url);
			    } catch (e) {
			        alert(errorTip);
			    }
			};

        if (browser === "msie" && (!shell || shell === "tencenttraveler")) {
            setForIE();
            return false;
        } else if (shell && config.shell[shell]) {

            //alert(shell)
            helpUrl += "#" + config.shell[shell];

            //测试发现maxthon也会注入UA
            if (shell === "maxthon") {
                try {
                    if (external.max_version) {
                        window.open(helpUrl);
                        return false;
                    } else {
                        setForIE();
                        return false;
                    }
                } catch (e) {
                    setForIE();
                    return false;
                }
            } else {
                window.open(helpUrl);
                return false;
            }
        } else if (config.browser[browser]) {
            //测试发现maxthon3跳至chrome
            if (browser === "chrome") {
                try {
                    if (external.max_version) {
                        helpUrl += "#" + "03";
                        window.open(helpUrl);
                        return false;
                    } else {
                        helpUrl += "#" + config.browser[browser];
                        window.open(helpUrl);
                        return false;
                    }
                } catch (e) {
                    helpUrl += "#" + config.browser[browser];
                    window.open(helpUrl);
                    return false;
                }
            } else {
                helpUrl += "#" + config.browser[browser];
                window.open(helpUrl);
                return false;
            }
        } else {
            alert(errorTip);
            return false;
        }
    },

    //绑定对象接口
    bind: function (el, url) {

        //允许id或dom
        el = typeof el === "string" ? document.getElementById(el) : el;

        url = url || 'http://www.hao123.com';
       
        var that = this;
			on = document.addEventListener ? function (el, type, callback) {
			    el.addEventListener(type, callback, !1);
			} : function (el, type, callback) {
			    el.attachEvent("on" + type, callback);
			};

        on(el, "click", function () {
            that.set(el, url);
            return false;
        });

        //允许链式绑定多个dom对象
        return this;
    }
}

window.UT = {
    url: "http://th.hao123.com/img/gut.gif",
    send: function (data) {
        //fix
        data = data || {};

        var conf = this.conf,
			url = conf && conf.url || this.url,
			r = data.r = +new Date(),
			scope = window,
			encode = encodeURIComponent,
			needle = scope["UT" + r] = new Image(),
			_data = conf && conf.data,
			key,
			ret = [];

        //merge
        if (_data) for (var k in _data) _data[k] !== key && (data[k] = _data[k]);

        //toParams
        for (key in data) ret.push(encode(key) + "=" + encode(data[key]));

        needle.onload = needle.onerror = function () {
            scope["UT" + r] = null;
        }
        needle.src = url + "?" + ret.join("&");

        needle = ret = null;
    }
};

/*-----全局的不好，暂时这样-----*/
function fineEvent(e) {
    e = e || window.event;
    e.target = e.target || e.srcElement;
    return e;
}
/*classNames可以写成 'class1 class2'的形式，但要注意把顺序写正确如果写了第三个参数，返回结果是live的。*/
function getElementsByClassName(className, content, isLive) {
   
    content = content || document;
    var resultTempt = [], result = [];
    if (content.getElementsByClassName) {
        resultTempt = content.getElementsByClassName(className);
    }
    else {
        className = className.replace(/^\s+/, '').replace(/\s+$/, '');
        className = " " + className + " ";
        var tempt = content.getElementsByTagName('*');
     
        for (var i = 0; i < tempt.length; i++) {
            temptClassName = " " + tempt[i].className + " ";
            if (temptClassName.indexOf(className) > -1) {
                resultTempt.push(tempt[i]);
            }
        }
    }
    if (!isLive) {
        for (var j = 0; j < resultTempt.length; j++) {
            result.push(resultTempt[j]);
        }
    } else {
       result = resultTempt;
   }

    if (result.length == 0) {
        return null;
    }
    else {
        return result;
    }
}

function bindEvent(elem, type, handler) {
    if (elem.attachEvent) {
        elem.attachEvent('on' + type, handler);
    }
    else {
        elem.addEventListener(type, handler, false);
    }

}

