
var Public = {};

/*
* 
* ֤֤ʽ
* return 1 ȷ; 0; -1 18λĸʽ; -2 15λİзַ; -3 18λַȷ; -4 ַ
*/
Public.ValidateIdentityCard = function(pNumber){
	var error = 1;
	pNumber = pNumber.toUpperCase();
	var l = pNumber.length;
	switch(l){
		case 15:
			if(/^\d{15}$/.test(pNumber)){
				var year = '19' + pNumber.substring (6, 8 );
				var month = pNumber.substring (8, 10 );
				var day = pNumber.substring (10, 12 );
				if(!Public.CheckDate(Number(year),Number(month),Number(day))){
					error = 0;
				}
			}
			else{
				error = -2;
			}
			break;
		case 18:
			if(/^\d{17}(\d|X)$/.test(pNumber)){
				var year = pNumber.substring(6, 10);
				var month = pNumber.substring(10, 12 );
				var day = pNumber.substring(12, 14);
				if(Public.CheckDate(Number(year),Number(month),Number(day))){
					var sigma = 0;
					var st = pNumber.substring (0, pNumber.length-1);
					var wi = new Array (7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2 );
					var ai = new Array ('1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2' );
					var _st,_wi;
					for(var i = 0; i < 17; i++)
					{
						_st =  st.substring(i,i+1);
						_wi = wi [i];
						sigma += (Number(_st) * _wi);
					}
					if ((pNumber.substring(pNumber.length-1)) != ai [sigma % 11]){
						error = -1;
					}
				}
				else{
					error = 0;
				}
			}
			else{
				error = -3;
			}
			break;
		case 6:
			if(!(/^\d{6}$/.test(pNumber))){
				error = -5;
			}
			break;
		default:
			error = -4;
			break;
	}
	return error;
}

/*
* 
* ֤URL
* return true ȷ; false 
*/
Public.ValidateUrl = function(pUrl){
	var str_url = pUrl;
	var regular = /^\b(((https?|ftp):\/\/)?[-a-z0-9]+(\.[-a-z0-9]+)*\.(?:com|edu|gov|int|mil|net|org|biz|info|name|museum|coop|aero|[a-z][a-z]|((25[0-5])|(2[0-4]\d)|(1\d\d)|([1-9]\d)|\d))\b(\/[-a-z0-9_:\@&?=+,.!/~%\$]*)?)$/i
	if(regular.test(str_url)){
		return true; 																																																							 		}
	else{
		return false; 
	}
}

/*
* 
* ֻ֤
* return 1 ȷ; 0ֻ;
*/
Public.ValidateMoblie = function(pNumber){
	var l = pNumber.length;
	var error = 1;
	switch(l){
		case 7:
			if(!/^(13[0-9]|15[0-9]|18[7|8|9|6|5])\d{4}$/.test(pNumber)){
				error = 0;
			}
			break;
		case 11:
			if(!/^(13[0-9]|15[0-9]|18[7|8|9|6|5])\d{4,8}$/.test(pNumber)){
				error = 0;
			}
			break;
		default:
			error = -1;
			break;
	}
	return error;
}

Public.ValidateChinaChar = function(pChar){
	if(!/^[\u4e00-\u9fa5\s]+$/.test(pChar)){
		return false;
	}
	return true;
}

/*
* 
* ֤ʱ
* return true ȷ;false;
*/
Public.ValidateZip = function(pNumber){
	if(!/^(\d{3,6})$|^([\u4e00-\u9fa5\s]{2,})$/.test(pNumber)){
		return false;
	}
	return true;
}

/*
* 
* ֤ڸʽ
* return True ȷ False 
*/
Public.CheckDate = function (year, month, day ) {
	var myDate = new Date();
	myDate.setFullYear( year, (month - 1), day );
	return ((myDate.getMonth()+1) == month && day<32); 
}

/*
* 
* 
*/
Public.Copy = function(pStr,msg){
  //IE            
  if(window.clipboardData)
  {
	window.clipboardData.clearData();
	window.clipboardData.setData("Text", pStr);
  }
  //Opera
  else if(navigator.userAgent.indexOf("Opera") != -1)
  {
	  window.location = txt;
  }
  //FireFox
  else if (window.netscape)
  {
	  try
	  {
		  netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
	  }
	  catch (e)
	  {
		  alert("firefoxȫм'about:config'signed.applets.codebase_principal_support'Ϊtrue'֮");
		  return false;
	  }
	  var clip = Components.classes["@mozilla.org/widget/clipboard;1"].createInstance(Components.interfaces.nsIClipboard);
	  if (!clip)
		  return;
	  var trans = Components.classes["@mozilla.org/widget/transferable;1"].createInstance(Components.interfaces.nsITransferable);
	  if (!trans)
		  return;
	  trans.addDataFlavor('text/unicode');
	  var str = new Object();
	  var len = new Object();
	  var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
	  var copytext = pStr;
	  str.data = copytext;
	  trans.setTransferData("text/unicode",str,copytext.length*2);
	  var clipid = Components.interfaces.nsIClipboard;
	  if (!clip)
	  return false;
	  clip.setData(trans,null,clipid.kGlobalClipboard);
  }
  var showMsg = msg ? msg:"ѸƵа壡";
  alert(showMsg);
}

/*
* 
* ַ
*/
Public.String = {};
Public.String.HtmlSpecialChars = function(string){
	var data = [];
	for(var i = 0 ;i <string.length;i++) {
		data.push( "&#"+string.charCodeAt(i)+";");
	}
	return data.join("");
}
Public.String.Cut = function(str,long){
	str = str.trim();
	if(str.length <= (long + 1)){
		return Public.String.HtmlSpecialChars(str);
	}else{
		return str.substring(0,long) + "..";
	}
}

/*
* 
* ʷ¼
*/
Public.History = {};
Public.History.length = 10;
Public.History.Set = function(pKey,value){
	value = value.trim();
	//value = value.trim();
	var hisCol = Public.History.Get(pKey);
	if(hisCol.length > 0){
		var index = -1;
		for(var i = 0; i < hisCol.length; i++){
			if(hisCol[i] == value){
				index = i;
			}
		}
		if(index > -1){
			hisCol.splice(index,1);
		}
		else{
			var l = hisCol.length;
			if(l == Public.History.length){
				hisCol.splice(0,1);
			}
		}
		hisCol.push(value);
		Public.Cookie.Set("history_" + pKey,hisCol.toString(),24);
	}
	else{
		Public.Cookie.Set("history_" + pKey,value,24);
	}
}
Public.History.Get = function(pKey){
	var name = "history_" + pKey;
	var c = Public.Cookie.Get(name);
	var hisCol;
	if(c != ""){
		hisCol = c.split(',');
	}
	else{
		hisCol = [];
	}
	return hisCol;
}
Public.History.Clear = function(pKey){
	Public.Cookie.Set("history_" + pKey,'');
}

Public.MyTools = {};
Public.MyTools.IsExist = function(pToolId){
	var result = -1;
	var name = "tools_my";
	var v = Public.Cookie.Get(name);
	var col;
	if(v != ""){
		col = v.split(',');
	}
	else{
		col = [];
	}
	for(var i = 0; i < col.length; i++){
		if(col[i] == pToolId.toString()){
			result = i;
			break;
		}
	}
	return result;
}

Public.MyTools.Set = function(pToolId){
	var name = "tools_my";
	var i = Public.MyTools.IsExist(pToolId);
	
	var exist = (i != -1);
	var state = 1;
	if(!exist){
		var v = Public.Cookie.Get(name);
		var col;
		if(v != ""){
			col = v.split(',');
		}
		else{
			col = [];
		}
		col.push(pToolId);
		Public.Cookie.Set(name,col.toString(),30*24);
	}
	else{
		state = 0;
	}
	return state;
}

Public.MyTools.Delete = function(pToolId){
	var name = "tools_my";
	var index = Public.MyTools.IsExist(pToolId);
	if(index != -1){
		var v = Public.Cookie.Get(name);
		var col;
		if(v != ""){
			col = v.split(',');
		}
		else{
			col = [];
		}
		col.splice(index,1);
		Public.Cookie.Set("tools_my",col.toString(),30*24);
		return 1;
	}
	else{
		return 0;
	}
}

/*
* 
* Cookie 
*/
Public.Cookie = {};
Public.Cookie.Set = function(name, value, hours){
  var expire = "";
  if(hours != null){
    expire = new Date((new Date()).getTime() + hours * 3600000);
    expire = "; expires=" + expire.toGMTString();
  }
  document.cookie = name + "=" + escape(value) + expire;
}

Public.Cookie.Get = function(name){
  var cookieValue = "";
  var search = name + "=";
  if(document.cookie.length > 0){ 
    offset = document.cookie.indexOf(search);
    if (offset != -1){ 
      offset += search.length;
      end = document.cookie.indexOf(";", offset);
      if (end == -1) end = document.cookie.length;
      cookieValue = unescape(document.cookie.substring(offset, end))
    }
  }
  return cookieValue;
}

/*
* 
* ڲ飬ҳ
*/
Public.BoxDisplayControl = function(obj){
	var _obj = obj;
	var _pageCol = [];

	var bindingEvent = function(){
		_obj.PreBox.bind("click",function(){
			if(_obj.ActiveStep > 0 && _cutState){
				endCorss();
				_obj.ActiveStep -= 1;
				display();
				startCorss();
			}
		});
		_obj.NextBox.bind("click",function(){
			if(_obj.ActiveStep < _pageCol.length - 1 && _cutState){
				endCorss();
				_obj.ActiveStep += 1;
				display();
				startCorss();
			}
		});
	}
	
	var _cutState = true;

	var display = function(pFast){
		if(_pageCol.length > 0){
			displayBtn();
			for(var i = 0; i < _pageCol.length; i++){
				_pageCol[i].hide();
			}
			_cutState = false;
			if(pFast){
				_pageCol[_obj.ActiveStep].show();
				_cutState = true;
			}
			else{
				_pageCol[_obj.ActiveStep].show("slow",function(){
					_cutState = true;
				});
			}
		}
	}
	
	var displayBtn = function(){
		if(_obj.ActiveStep > 0){
			_obj.PreBox.addClass(_obj.PreStyle);
			_obj.PreBox.removeClass(_obj.PreDisableStyle);
		}
		else{
			_obj.PreBox.addClass(_obj.PreDisableStyle);
			_obj.PreBox.removeClass(_obj.PreStyle);
		}
		
		if(_obj.ActiveStep < _pageCol.length - 1){
			_obj.NextBox.addClass(_obj.NextStyle);
			_obj.NextBox.removeClass(_obj.NextDisableStyle);
		}
		else{
			_obj.NextBox.addClass(_obj.NextDisableStyle);
			_obj.NextBox.removeClass(_obj.NextStyle);
		}
	}
	
	var corssPage = function(){
		if(_cutState){
			_obj.ActiveStep++;
			if(_obj.ActiveStep > _pageCol.length - 1){
				_obj.ActiveStep = 0;
			}
			display();
		}
	}
	
	var _timer;
	var startCorss = function(){
		if(_pageCol.length > 1){
			_timer = window.setInterval(corssPage,4000);
		}
	}
	
	var endCorss = function(){
		if(_pageCol.length > 1){
			window.clearInterval(_timer);
		}
	}
	
	this.AddPageBox = function(pBox){
		_pageCol.push(pBox);
	},
	this.init = function(){
		bindingEvent();
		_obj.ActiveStep = 0;
		display(true);
		//Զҳ
		startCorss();
	}
}
