<?php

namespace App\Http\Controllers\Main;

use App\Http\Controllers\Support\BaseController;
use App\Types\EventShowStatus;
use Carbon\Carbon;
use Edwin404\Banner\Services\BannerService;
use Edwin404\Base\Support\ModelHelper;
use Edwin404\Forum\Services\ForumService;
use Edwin404\Tecmz\Traits\MemberAccountTrait;
use Illuminate\Support\Facades\Log;
use Jenssegers\Agent\Agent;

class IndexController extends BaseController
{
    use MemberAccountTrait;

    public function index(BannerService $bannerService)
    {
        if ($this->isMobile()) {
            $banners = $bannerService->listByPositionWithCache('mHome');
        } else {
            $banners = $bannerService->listByPositionWithCache('pcHome');
        }
        $eventCategories = ModelHelper::model('event_category')->where(['pid' => 0])->orderBy('sort', 'asc')->get()->toArray();
        foreach ($eventCategories as &$eventCategory) {
            $eventCategory['_events'] = ModelHelper::model('event')
                ->where(['categoryId' => $eventCategory['id'], 'showStatus' => EventShowStatus::SHOW])
                ->orderBy('id', 'desc')
                ->limit(4)
                ->get()
                ->toArray();
        }

        return $this->_view('index', compact('banners', 'eventCategories'));
    }

}