<?php

namespace App\Http\Controllers\Support;

use Edwin404\Article\Services\ArticleService;
use Edwin404\Common\Support\TemplateViewTrait;
use Edwin404\Member\Support\MemberTrait;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\View;

class BaseController extends Controller
{
    protected $articleService;

    use MemberTrait;
    use TemplateViewTrait;

    public function __construct(ArticleService $articleService)
    {
        $this->articleService = $articleService;
        $this->memberUserSetup();
        $this->basicSetup();
    }

    protected function basicSetup()
    {
        $footerArticles = $this->articleService->listByPosition('footer');
        View::share('footerArticles', $footerArticles);
    }

}