<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class Migrate20171224 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $events = \Edwin404\Base\Support\ModelHelper::find('event');
        \Edwin404\Base\Support\ModelHelper::decodeRecordsJson($events, 'applyInfo');
        foreach ($events as $event) {
            if (empty($event['applyInfo'])) {
                continue;
            }
            foreach ($event['applyInfo'] as $index => $item) {
                if ($index >= 5) {
                    break;
                }
                switch ($item['type']) {
                    case 'text':
                        \Edwin404\Base\Support\ModelHelper::updateOne('event', ['id' => $event['id']], [
                            'fieldCustom' . ($index + 1) => json_encode([
                                'type' => 'Text',
                                'title' => $item['name'],
                                'data' => [],
                            ])
                        ]);
                        break;
                    case 'select':
                        $option = [];
                        foreach (explode("\n", $item['option']) as $line) {
                            $line = trim($line);
                            if (empty($line)) {
                                continue;
                            }
                            $option [] = $line;
                        }
                        \Edwin404\Base\Support\ModelHelper::updateOne('event', ['id' => $event['id']], [
                            'fieldCustom' . ($index + 1) => json_encode([
                                'type' => 'Radio',
                                'title' => $item['name'],
                                'data' => [
                                    'option' => $option
                                ],
                            ])
                        ]);
                        break;
                }
            }
            \Edwin404\Base\Support\ModelHelper::updateOne('event', ['id' => $event['id']], [
                'applyInfo' => null,
            ]);
        }

        $eventOrders = \Edwin404\Base\Support\ModelHelper::find('event_order');
        \Edwin404\Base\Support\ModelHelper::decodeRecordsJson($eventOrders, 'applyInfo');
        foreach ($eventOrders as $eventOrder) {
            if (empty($eventOrder['eventId'])) {
                continue;
            }
            /*
            const WAIT_PAY = 1;
            const WAIT_SIGN_IN = 2;
            const EXPIRED = 3;
            const COMPLETED = 4;
            const ABSENT = 5;
            */
            $orderStatus = $eventOrder['status'];
            $status = \App\Types\EventOrderItemStatus::WAIT_SIGN_IN;
            if ($eventOrder['status'] == 2) {
                \Edwin404\Base\Support\ModelHelper::updateOne('event_order', ['id' => $eventOrder['id']], [
                    'status' => \App\Types\EventOrderStatus::COMPLETED,
                ]);
                $orderStatus = \App\Types\EventOrderStatus::COMPLETED;
                $status = \App\Types\EventOrderItemStatus::WAIT_SIGN_IN;
            }
            if ($eventOrder['status'] == 5) {
                \Edwin404\Base\Support\ModelHelper::updateOne('event_order', ['id' => $eventOrder['id']], [
                    'status' => \App\Types\EventOrderStatus::COMPLETED,
                ]);
                $orderStatus = \App\Types\EventOrderStatus::COMPLETED;
                $status = \App\Types\EventOrderItemStatus::ABSENT;
            }

            $update = [
                'memberUserId' => $eventOrder['memberUserId'],
                'orderId' => $eventOrder['id'],
                'eventId' => $eventOrder['eventId'],
                'checkCode' => \EdwinFound\Utils\RandomUtil::number(10),
                'orderStatus' => $orderStatus,
                'status' => $status,
            ];

            if (!empty($eventOrder['applyInfo'])) {
                foreach ($eventOrder['applyInfo'] as $index => $item) {
                    if ($index >= 5) {
                        break;
                    }
                    $update['fieldCustom' . ($index + 1)] = $item['value'];
                }
            }

            \Edwin404\Base\Support\ModelHelper::add('event_order_item', $update);

            \Edwin404\Base\Support\ModelHelper::updateOne('event_order', ['id' => $eventOrder['id']], [
                'eventId' => null,
                'applyInfo' => null,
            ]);
        }

        Schema::table('event', function (Blueprint $table) {
            $table->dropColumn('applyInfo');
        });

        Schema::table('event_order', function (Blueprint $table) {
            $table->dropColumn('applyInfo');
            $table->dropColumn('eventId');
        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
    }
}
