@extends('theme.default.m.frame')

@section('pageTitleMain','订单详情')

@section('bodyContent')

    <div class="pb pb-member-order-detail">
        <ul class="mui-table-view">
            <li class="mui-table-view-cell">
                <div class="name">订单号</div>
                <div class="value">{{$order['sn']}}</div>
            </li>
            <li class="mui-table-view-cell">
                <div class="name">金额</div>
                <div class="value">￥{{$order['payFee']}} 元</div>
            </li>
            <li class="mui-table-view-cell">
                <div class="name">金额</div>
                <div class="value">￥{{$order['payFee']}}元</div>
            </li>
            <li class="mui-table-view-cell">
                <div class="name">状态</div>
                <div class="value">
                    <div class="status">
                        @if($order['status']==\App\Types\EventOrderStatus::WAIT_PAY)
                            <span class="pb-text-danger">等待付款</span>
                        @elseif($order['status']==\App\Types\EventOrderStatus::EXPIRED)
                            <span class="pb-text-muted">已过期</span>
                        @elseif($order['status']==\App\Types\EventOrderStatus::COMPLETED)
                            <span class="pb-text-success">已完成</span>
                        @endif
                    </div>
                </div>
            </li>
            @if($order['status']==\App\Types\EventOrderStatus::WAIT_PAY)
                <li class="mui-table-view-cell">
                    <div class="name">&nbsp;</div>
                    <div class="value">
                        <div class="action">
                            <a class="main" href="/member/order_pay/{{$order['id']}}">立即付款</a>
                        </div>
                    </div>
                </li>
            @endif
        </ul>
    </div>
    <div class="pb pb-member-order-detail">
        <ul class="mui-table-view mui-table-view-striped mui-table-view-condensed">
            @foreach($order['_items'] as $orderItem)
            <li class="mui-table-view-cell">
                <div class="mui-table">
                    <div class="mui-table-cell mui-col-xs-10">
                        <h4 class="mui-ellipsis">
                            <a class="title" href="/event/{{$orderItem['eventId']}}" target="_blank">
                                {{$orderItem['_event']['title']}}
                            </a>
                        </h4>
                        <h5>票号：{{$orderItem['checkCode']}}</h5>
                        @foreach(\Edwin404\EXField\EXFieldUtil::pair($orderItem['_event'],$orderItem) as $item)
                            <p class="mui-h6 mui-ellipsis">
                                {{$item['name']}}：{{$item['value']}}
                            </p>
                        @endforeach
                    </div>
                    <div class="mui-table-cell mui-col-xs-2 mui-text-right">
                        <span class="mui-h5">
                            @if($orderItem['orderStatus']==\App\Types\EventOrderStatus::COMPLETED)
                                @if($orderItem['status']==\App\Types\EventOrderItemStatus::WAIT_SIGN_IN)
                                    <div class="pb-text-warning">待签到</div>
                                @endif
                                @if($orderItem['status']==\App\Types\EventOrderItemStatus::ABSENT)
                                    <div class="pb-text-danger">缺席</div>
                                @endif
                                @if($orderItem['status']==\App\Types\EventOrderItemStatus::COMPLETED)
                                    <div class="pb-text-warning">已完成</div>
                                @endif
                            @else
                                -
                            @endif
                        </span>
                    </div>
                </div>
            </li>
            @endforeach
        </ul>
    </div>

@endsection