@extends('theme.default.pc.frame')

@section('pageTitleMain',\Edwin404\Config\Facades\ConfigFacade::get('langCategoryName','活动').'详情')

@section('bodyContent')

    <div class="main-container">

        <div class="pb pb-breadcrumb">
            <ul class="uk-breadcrumb">
                <li><a href="/">首页</a></li>
                <li><a href="/member/order">我的活动</a></li>
                <li class="uk-active"><span>订单详情</span></li>
            </ul>
        </div>

        <div class="uk-grid">
            <div class="uk-width-1-6">
                @include('theme.default.pc.member.profile.menu')
            </div>
            <div class="uk-width-5-6">
                <div class="pb pb-member-order-detail">
                    <div class="head">订单详情</div>
                    <table class="uk-table">
                        <tbody>
                        <tr>
                            <td width="100">订单号：</td>
                            <td>{{$order['sn']}}</td>
                        </tr>
                        <tr>
                            <td>下单时间：</td>
                            <td>{{$order['created_at']}}</td>
                        </tr>
                        <tr>
                            <td>支付价格：</td>
                            <td>
                                ￥{{$order['payFee']}}元
                            </td>
                        </tr>
                        <tr>
                            <td>状态：</td>
                            <td>
                                <div class="status">
                                    @if($order['status']==\App\Types\EventOrderStatus::WAIT_PAY)
                                        <span class="uk-text-danger">等待付款</span>
                                    @elseif($order['status']==\App\Types\EventOrderStatus::EXPIRED)
                                        <span class="uk-text-muted">已过期</span>
                                    @elseif($order['status']==\App\Types\EventOrderStatus::COMPLETED)
                                        <span class="uk-text-success">已完成</span>
                                    @endif
                                </div>
                            </td>
                        </tr>
                        @if($order['status']==\App\Types\EventOrderStatus::WAIT_PAY)
                            <tr>
                                <td>操作：</td>
                                <td>
                                    <div class="action">
                                        <a class="main" href="/member/order_pay/{{$order['id']}}">立即付款</a>
                                    </div>
                                </td>
                            </tr>
                        @endif
                        </tbody>
                    </table>
                </div>
                <div class="pb pb-member-order-detail">
                    <div class="head">报名信息</div>
                    <table class="uk-table">
                        <thead>
                        <tr>
                            <th>活动</th>
                            <th>信息</th>
                            <th>票号</th>
                            <th>状态</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($order['_items'] as $orderItem)
                        <tr>
                            <td>
                                <a class="title" href="/event/{{$orderItem['eventId']}}" target="_blank">
                                    {{$orderItem['_event']['title']}}
                                </a>
                            </td>
                            <td>
                                <div class="buyInfo">
                                    @foreach(\Edwin404\EXField\EXFieldUtil::pair($orderItem['_event'],$orderItem) as $item)
                                        <div class="item">
                                            {{$item['name']}}：{{$item['value']}}
                                        </div>
                                    @endforeach
                                </div>
                            </td>
                            <td>{{$orderItem['checkCode']}}</td>
                            <td>
                                @if($orderItem['orderStatus']==\App\Types\EventOrderStatus::COMPLETED)
                                    @if($orderItem['status']==\App\Types\EventOrderItemStatus::WAIT_SIGN_IN)
                                        <div class="uk-text-warning">待签到</div>
                                    @endif
                                    @if($orderItem['status']==\App\Types\EventOrderItemStatus::ABSENT)
                                        <div class="uk-text-danger">缺席</div>
                                    @endif
                                    @if($orderItem['status']==\App\Types\EventOrderItemStatus::COMPLETED)
                                        <div class="uk-text-warning">已完成</div>
                                    @endif
                                @else
                                    -
                                @endif
                            </td>
                        </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>

@endsection