﻿<%
Private Const zfpay_BITS_TO_A_BYTE_ = 8
Private Const zfpay_BYTES_TO_A_WORD_ = 4
Private Const zfpay_BITS_TO_A_WORD_ = 32

Private zfpay_m_lOnBits_(30)
Private zfpay_m_l2Power_(30)
 
Private Function zfpay_LShift(lValue, iShiftBits)
    If iShiftBits = 0 Then
        zfpay_LShift = lValue
        Exit Function
    ElseIf iShiftBits = 31 Then
        If lValue And 1 Then
            zfpay_LShift = &H80000000
        Else
            zfpay_LShift = 0
        End If
        Exit Function
    ElseIf iShiftBits < 0 Or iShiftBits > 31 Then
        Err.Raise 6
    End If

    If (lValue And zfpay_m_l2Power_(31 - iShiftBits)) Then
        zfpay_LShift = ((lValue And zfpay_m_lOnBits_(31 - (iShiftBits + 1))) * zfpay_m_l2Power_(iShiftBits)) Or &H80000000
    Else
        zfpay_LShift = ((lValue And zfpay_m_lOnBits_(31 - iShiftBits)) * zfpay_m_l2Power_(iShiftBits))
    End If
End Function

Private Function zfpay_RShift(lValue, iShiftBits)
    If iShiftBits = 0 Then
        zfpay_RShift = lValue
        Exit Function
    ElseIf iShiftBits = 31 Then
        If lValue And &H80000000 Then
            zfpay_RShift = 1
        Else
            zfpay_RShift = 0
        End If
        Exit Function
    ElseIf iShiftBits < 0 Or iShiftBits > 31 Then
        Err.Raise 6
    End If
    
    zfpay_RShift = (lValue And &H7FFFFFFE) \ zfpay_m_l2Power_(iShiftBits)

    If (lValue And &H80000000) Then
        zfpay_RShift = (zfpay_RShift Or (&H40000000 \ zfpay_m_l2Power_(iShiftBits - 1)))
    End If
End Function

Private Function zfpay_RotateLeft(lValue, iShiftBits)
    zfpay_RotateLeft = zfpay_LShift(lValue, iShiftBits) Or zfpay_RShift(lValue, (32 - iShiftBits))
End Function

Private Function zfpay_AddUnsigned(lX, lY)
    Dim lX4
    Dim lY4
    Dim lX8
    Dim lY8
    Dim lResult
 
    lX8 = lX And &H80000000
    lY8 = lY And &H80000000
    lX4 = lX And &H40000000
    lY4 = lY And &H40000000
 
    lResult = (lX And &H3FFFFFFF) + (lY And &H3FFFFFFF)
 
    If lX4 And lY4 Then
        lResult = lResult Xor &H80000000 Xor lX8 Xor lY8
    ElseIf lX4 Or lY4 Then
        If lResult And &H40000000 Then
            lResult = lResult Xor &HC0000000 Xor lX8 Xor lY8
        Else
            lResult = lResult Xor &H40000000 Xor lX8 Xor lY8
        End If
    Else
        lResult = lResult Xor lX8 Xor lY8
    End If
 
    zfpay_AddUnsigned = lResult
End Function

Private Function zfpay_md5_F(x, y, z)
    zfpay_md5_F = (x And y) Or ((Not x) And z)
End Function

Private Function zfpay_md5_G(x, y, z)
    zfpay_md5_G = (x And z) Or (y And (Not z))
End Function

Private Function zfpay_md5_H(x, y, z)
    zfpay_md5_H = (x Xor y Xor z)
End Function

Private Function zfpay_md5_I(x, y, z)
    zfpay_md5_I = (y Xor (x Or (Not z)))
End Function

Private Sub zfpay_md5_FF(a, b, c, d, x, s, ac)
    a = zfpay_AddUnsigned(a, zfpay_AddUnsigned(zfpay_AddUnsigned(zfpay_md5_F(b, c, d), x), ac))
    a = zfpay_RotateLeft(a, s)
    a = zfpay_AddUnsigned(a, b)
End Sub

Private Sub zfpay_md5_GG(a, b, c, d, x, s, ac)
    a = zfpay_AddUnsigned(a, zfpay_AddUnsigned(zfpay_AddUnsigned(zfpay_md5_G(b, c, d), x), ac))
    a = zfpay_RotateLeft(a, s)
    a = zfpay_AddUnsigned(a, b)
End Sub

Private Sub zfpay_md5_HH(a, b, c, d, x, s, ac)
    a = zfpay_AddUnsigned(a, zfpay_AddUnsigned(zfpay_AddUnsigned(zfpay_md5_H(b, c, d), x), ac))
    a = zfpay_RotateLeft(a, s)
    a = zfpay_AddUnsigned(a, b)
End Sub

Private Sub zfpay_md5_II(a, b, c, d, x, s, ac)
    a = zfpay_AddUnsigned(a, zfpay_AddUnsigned(zfpay_AddUnsigned(zfpay_md5_I(b, c, d), x), ac))
    a = zfpay_RotateLeft(a, s)
    a = zfpay_AddUnsigned(a, b)
End Sub

Private Function zfpay_ConvertToWordArray(sMessage)
    Dim lMessageLength
    Dim lNumberOfWords
    Dim lWordArray()
    Dim lBytePosition
    Dim lByteCount
    Dim lWordCount
    
    Const MODULUS_BITS = 512
    Const CONGRUENT_BITS = 448
    
    lMessageLength = Len(sMessage)
    
    lNumberOfWords = (((lMessageLength + ((MODULUS_BITS - CONGRUENT_BITS) \ zfpay_BITS_TO_A_BYTE_)) \ (MODULUS_BITS \ zfpay_BITS_TO_A_BYTE_)) + 1) * (MODULUS_BITS \ zfpay_BITS_TO_A_WORD_)
    ReDim lWordArray(lNumberOfWords - 1)
    
    lBytePosition = 0
    lByteCount = 0
    Do Until lByteCount >= lMessageLength
        lWordCount = lByteCount \ zfpay_BYTES_TO_A_WORD_
        lBytePosition = (lByteCount Mod zfpay_BYTES_TO_A_WORD_) * zfpay_BITS_TO_A_BYTE_
        lWordArray(lWordCount) = lWordArray(lWordCount) Or zfpay_LShift(Asc(Mid(sMessage, lByteCount + 1, 1)), lBytePosition)
        lByteCount = lByteCount + 1
    Loop

    lWordCount = lByteCount \ zfpay_BYTES_TO_A_WORD_
    lBytePosition = (lByteCount Mod zfpay_BYTES_TO_A_WORD_) * zfpay_BITS_TO_A_BYTE_

    lWordArray(lWordCount) = lWordArray(lWordCount) Or zfpay_LShift(&H80, lBytePosition)

    lWordArray(lNumberOfWords - 2) = zfpay_LShift(lMessageLength, 3)
    lWordArray(lNumberOfWords - 1) = zfpay_RShift(lMessageLength, 29)
    
    zfpay_ConvertToWordArray = lWordArray
End Function

Private Function zfpay_WordToHex(lValue)
    Dim lByte
    Dim lCount
    
    For lCount = 0 To 3
        lByte = zfpay_RShift(lValue, lCount * zfpay_BITS_TO_A_BYTE_) And zfpay_m_lOnBits_(zfpay_BITS_TO_A_BYTE_ - 1)
        zfpay_WordToHex = zfpay_WordToHex & Right("0" & Hex(lByte), 2)
    Next
End Function

Public Function zfpay_md5(sMessage)
    zfpay_m_lOnBits_(0) = CLng(1)
    zfpay_m_lOnBits_(1) = CLng(3)
    zfpay_m_lOnBits_(2) = CLng(7)
    zfpay_m_lOnBits_(3) = CLng(15)
    zfpay_m_lOnBits_(4) = CLng(31)
    zfpay_m_lOnBits_(5) = CLng(63)
    zfpay_m_lOnBits_(6) = CLng(127)
    zfpay_m_lOnBits_(7) = CLng(255)
    zfpay_m_lOnBits_(8) = CLng(511)
    zfpay_m_lOnBits_(9) = CLng(1023)
    zfpay_m_lOnBits_(10) = CLng(2047)
    zfpay_m_lOnBits_(11) = CLng(4095)
    zfpay_m_lOnBits_(12) = CLng(8191)
    zfpay_m_lOnBits_(13) = CLng(16383)
    zfpay_m_lOnBits_(14) = CLng(32767)
    zfpay_m_lOnBits_(15) = CLng(65535)
    zfpay_m_lOnBits_(16) = CLng(131071)
    zfpay_m_lOnBits_(17) = CLng(262143)
    zfpay_m_lOnBits_(18) = CLng(524287)
    zfpay_m_lOnBits_(19) = CLng(1048575)
    zfpay_m_lOnBits_(20) = CLng(2097151)
    zfpay_m_lOnBits_(21) = CLng(4194303)
    zfpay_m_lOnBits_(22) = CLng(8388607)
    zfpay_m_lOnBits_(23) = CLng(16777215)
    zfpay_m_lOnBits_(24) = CLng(33554431)
    zfpay_m_lOnBits_(25) = CLng(67108863)
    zfpay_m_lOnBits_(26) = CLng(134217727)
    zfpay_m_lOnBits_(27) = CLng(268435455)
    zfpay_m_lOnBits_(28) = CLng(536870911)
    zfpay_m_lOnBits_(29) = CLng(1073741823)
    zfpay_m_lOnBits_(30) = CLng(2147483647)
    
    zfpay_m_l2Power_(0) = CLng(1)
    zfpay_m_l2Power_(1) = CLng(2)
    zfpay_m_l2Power_(2) = CLng(4)
    zfpay_m_l2Power_(3) = CLng(8)
    zfpay_m_l2Power_(4) = CLng(16)
    zfpay_m_l2Power_(5) = CLng(32)
    zfpay_m_l2Power_(6) = CLng(64)
    zfpay_m_l2Power_(7) = CLng(128)
    zfpay_m_l2Power_(8) = CLng(256)
    zfpay_m_l2Power_(9) = CLng(512)
    zfpay_m_l2Power_(10) = CLng(1024)
    zfpay_m_l2Power_(11) = CLng(2048)
    zfpay_m_l2Power_(12) = CLng(4096)
    zfpay_m_l2Power_(13) = CLng(8192)
    zfpay_m_l2Power_(14) = CLng(16384)
    zfpay_m_l2Power_(15) = CLng(32768)
    zfpay_m_l2Power_(16) = CLng(65536)
    zfpay_m_l2Power_(17) = CLng(131072)
    zfpay_m_l2Power_(18) = CLng(262144)
    zfpay_m_l2Power_(19) = CLng(524288)
    zfpay_m_l2Power_(20) = CLng(1048576)
    zfpay_m_l2Power_(21) = CLng(2097152)
    zfpay_m_l2Power_(22) = CLng(4194304)
    zfpay_m_l2Power_(23) = CLng(8388608)
    zfpay_m_l2Power_(24) = CLng(16777216)
    zfpay_m_l2Power_(25) = CLng(33554432)
    zfpay_m_l2Power_(26) = CLng(67108864)
    zfpay_m_l2Power_(27) = CLng(134217728)
    zfpay_m_l2Power_(28) = CLng(268435456)
    zfpay_m_l2Power_(29) = CLng(536870912)
    zfpay_m_l2Power_(30) = CLng(1073741824)


    Dim x
    Dim k
    Dim AA
    Dim BB
    Dim CC
    Dim DD
    Dim a
    Dim b
    Dim c
    Dim d
    
    Const S11 = 7
    Const S12 = 12
    Const S13 = 17
    Const S14 = 22
    Const S21 = 5
    Const S22 = 9
    Const S23 = 14
    Const S24 = 20
    Const S31 = 4
    Const S32 = 11
    Const S33 = 16
    Const S34 = 23
    Const S41 = 6
    Const S42 = 10
    Const S43 = 15
    Const S44 = 21

    x = zfpay_ConvertToWordArray(sMessage)
    
    a = &H67452301
    b = &HEFCDAB89
    c = &H98BADCFE
    d = &H10325476

    For k = 0 To UBound(x) Step 16
        AA = a
        BB = b
        CC = c
        DD = d
    
        zfpay_md5_FF a, b, c, d, x(k + 0), S11, &HD76AA478
        zfpay_md5_FF d, a, b, c, x(k + 1), S12, &HE8C7B756
        zfpay_md5_FF c, d, a, b, x(k + 2), S13, &H242070DB
        zfpay_md5_FF b, c, d, a, x(k + 3), S14, &HC1BDCEEE
        zfpay_md5_FF a, b, c, d, x(k + 4), S11, &HF57C0FAF
        zfpay_md5_FF d, a, b, c, x(k + 5), S12, &H4787C62A
        zfpay_md5_FF c, d, a, b, x(k + 6), S13, &HA8304613
        zfpay_md5_FF b, c, d, a, x(k + 7), S14, &HFD469501
        zfpay_md5_FF a, b, c, d, x(k + 8), S11, &H698098D8
        zfpay_md5_FF d, a, b, c, x(k + 9), S12, &H8B44F7AF
        zfpay_md5_FF c, d, a, b, x(k + 10), S13, &HFFFF5BB1
        zfpay_md5_FF b, c, d, a, x(k + 11), S14, &H895CD7BE
        zfpay_md5_FF a, b, c, d, x(k + 12), S11, &H6B901122
        zfpay_md5_FF d, a, b, c, x(k + 13), S12, &HFD987193
        zfpay_md5_FF c, d, a, b, x(k + 14), S13, &HA679438E
        zfpay_md5_FF b, c, d, a, x(k + 15), S14, &H49B40821
    
        zfpay_md5_GG a, b, c, d, x(k + 1), S21, &HF61E2562
        zfpay_md5_GG d, a, b, c, x(k + 6), S22, &HC040B340
        zfpay_md5_GG c, d, a, b, x(k + 11), S23, &H265E5A51
        zfpay_md5_GG b, c, d, a, x(k + 0), S24, &HE9B6C7AA
        zfpay_md5_GG a, b, c, d, x(k + 5), S21, &HD62F105D
        zfpay_md5_GG d, a, b, c, x(k + 10), S22, &H2441453
        zfpay_md5_GG c, d, a, b, x(k + 15), S23, &HD8A1E681
        zfpay_md5_GG b, c, d, a, x(k + 4), S24, &HE7D3FBC8
        zfpay_md5_GG a, b, c, d, x(k + 9), S21, &H21E1CDE6
        zfpay_md5_GG d, a, b, c, x(k + 14), S22, &HC33707D6
        zfpay_md5_GG c, d, a, b, x(k + 3), S23, &HF4D50D87
        zfpay_md5_GG b, c, d, a, x(k + 8), S24, &H455A14ED
        zfpay_md5_GG a, b, c, d, x(k + 13), S21, &HA9E3E905
        zfpay_md5_GG d, a, b, c, x(k + 2), S22, &HFCEFA3F8
        zfpay_md5_GG c, d, a, b, x(k + 7), S23, &H676F02D9
        zfpay_md5_GG b, c, d, a, x(k + 12), S24, &H8D2A4C8A
            
        zfpay_md5_HH a, b, c, d, x(k + 5), S31, &HFFFA3942
        zfpay_md5_HH d, a, b, c, x(k + 8), S32, &H8771F681
        zfpay_md5_HH c, d, a, b, x(k + 11), S33, &H6D9D6122
        zfpay_md5_HH b, c, d, a, x(k + 14), S34, &HFDE5380C
        zfpay_md5_HH a, b, c, d, x(k + 1), S31, &HA4BEEA44
        zfpay_md5_HH d, a, b, c, x(k + 4), S32, &H4BDECFA9
        zfpay_md5_HH c, d, a, b, x(k + 7), S33, &HF6BB4B60
        zfpay_md5_HH b, c, d, a, x(k + 10), S34, &HBEBFBC70
        zfpay_md5_HH a, b, c, d, x(k + 13), S31, &H289B7EC6
        zfpay_md5_HH d, a, b, c, x(k + 0), S32, &HEAA127FA
        zfpay_md5_HH c, d, a, b, x(k + 3), S33, &HD4EF3085
        zfpay_md5_HH b, c, d, a, x(k + 6), S34, &H4881D05
        zfpay_md5_HH a, b, c, d, x(k + 9), S31, &HD9D4D039
        zfpay_md5_HH d, a, b, c, x(k + 12), S32, &HE6DB99E5
        zfpay_md5_HH c, d, a, b, x(k + 15), S33, &H1FA27CF8
        zfpay_md5_HH b, c, d, a, x(k + 2), S34, &HC4AC5665
    
        zfpay_md5_II a, b, c, d, x(k + 0), S41, &HF4292244
        zfpay_md5_II d, a, b, c, x(k + 7), S42, &H432AFF97
        zfpay_md5_II c, d, a, b, x(k + 14), S43, &HAB9423A7
        zfpay_md5_II b, c, d, a, x(k + 5), S44, &HFC93A039
        zfpay_md5_II a, b, c, d, x(k + 12), S41, &H655B59C3
        zfpay_md5_II d, a, b, c, x(k + 3), S42, &H8F0CCC92
        zfpay_md5_II c, d, a, b, x(k + 10), S43, &HFFEFF47D
        zfpay_md5_II b, c, d, a, x(k + 1), S44, &H85845DD1
        zfpay_md5_II a, b, c, d, x(k + 8), S41, &H6FA87E4F
        zfpay_md5_II d, a, b, c, x(k + 15), S42, &HFE2CE6E0
        zfpay_md5_II c, d, a, b, x(k + 6), S43, &HA3014314
        zfpay_md5_II b, c, d, a, x(k + 13), S44, &H4E0811A1
        zfpay_md5_II a, b, c, d, x(k + 4), S41, &HF7537E82
        zfpay_md5_II d, a, b, c, x(k + 11), S42, &HBD3AF235
        zfpay_md5_II c, d, a, b, x(k + 2), S43, &H2AD7D2BB
        zfpay_md5_II b, c, d, a, x(k + 9), S44, &HEB86D391
    
        a = zfpay_AddUnsigned(a, AA)
        b = zfpay_AddUnsigned(b, BB)
        c = zfpay_AddUnsigned(c, CC)
        d = zfpay_AddUnsigned(d, DD)
    Next
    
    zfpay_md5 = LCase(zfpay_WordToHex(a) & zfpay_WordToHex(b) & zfpay_WordToHex(c) & zfpay_WordToHex(d))
End Function
%>
