PageOverLay = Class.create();
Object.extend(PageOverLay.prototype,{
	mask:null,
	initialize: function() {
		
		this.initDiv();
		//get the mask div element
		this.mask = $('loading-div');
		
		Event.observe(window,"load",this.onloadWindow.bindAsEventListener(this));
		this.overlay();
		
	},
	initDiv:function(){
		new Insertion.Top(document.body,"<div id=\"loading-div\" style=\"background-color:#fff;\"><div id=\"loading-float\"><image src=\"/images/loading.gif\"/><br/>Loading, please wait...</div></div>");
		
	},    
	getPageSize:function() {
	        
	   var xScroll, yScroll;
		
		if (window.innerHeight && window.scrollMaxY) {	
			xScroll = window.innerWidth + window.scrollMaxX;
			yScroll = window.innerHeight + window.scrollMaxY;
		} else if (document.body.scrollHeight > document.body.offsetHeight){ // all but Explorer Mac
			xScroll = document.body.scrollWidth;
			yScroll = document.body.scrollHeight;
		} else { // Explorer Mac...would also work in Explorer 6 Strict, Mozilla and Safari
			xScroll = document.body.offsetWidth;
			yScroll = document.body.offsetHeight;
		}
		
		var windowWidth, windowHeight;
		
		if (self.innerHeight) {	// all except Explorer
			if(document.documentElement.clientWidth){
				windowWidth = document.documentElement.clientWidth; 
			} else {
				windowWidth = self.innerWidth;
			}
			windowHeight = self.innerHeight;
		} else if (document.documentElement && document.documentElement.clientHeight) { // Explorer 6 Strict Mode
			windowWidth = document.documentElement.clientWidth;
			windowHeight = document.documentElement.clientHeight;
		} else if (document.body) { // other Explorers
			windowWidth = document.body.clientWidth;
			windowHeight = document.body.clientHeight;
		}	
		
		// for small pages with total height less then height of the viewport
		if(yScroll < windowHeight){
			pageHeight = windowHeight;
		} else { 
			pageHeight = yScroll;
		}
	
		// for small pages with total width less then width of the viewport
		if(xScroll < windowWidth){	
			pageWidth = xScroll;		
		} else {
			pageWidth = windowWidth;
		}

		return [pageWidth,pageHeight];
	},
	overlay:function(){
		var arrayPageSize = this.getPageSize();
	
		maskLeft=arrayPageSize[0]/2-80;
		maskTop=arrayPageSize[1]/2-80;
		
		//get the mask div element
		var maskFloat = $('loading-float');
		maskFloat.setStyle({position:'absolute',top:maskTop+'px',left:maskLeft+'px'});
		this.mask.setStyle({position:'absolute',width:arrayPageSize[0]+'px',height:arrayPageSize[1]+'px',display:'block'});
	},
	onloadWindow:function(){
		//style the mask so that it is no longer displayed
		this.mask.style.display = 'none';
		self_location = document.location.href;
		if(top.infoFrame && self_location.indexOf('Info.page')==-1){
			if(top.infoFrame.stopCover!=null){
				top.infoFrame.stopCover();
			}
		}
	}
});
__page_loading=new PageOverLay();