<%
'┌──────────────────── 深度空间 深度学习 ──┐
'│过程名：pageInit(rsArticle,pSize,	currentPage,pageSize)
'│作  用：分页初始化函数                     
'│参  数： rs		记录集
'│			pSize	每页显示记录数
'│			[currentPage，pageSize]此2值调用时按名称原样写即可不用设置
'│说  明：	调用时仅需将rs更改成对应记录集名称,设置 pSize每页显示数
'│			1 分页初始化，以及显示循环处设界,
'│				call pageInit(rs,10  ,currentPage,pageSize)
'│			2 循环处设界
'│				if (pageSize<=0)then exit do end if
'│				pageSize=PageSize-1
'│			3 分页显示 
'│				call pagination(rs,currentPage)
'│			sql数据库分页时set rs对象后需添加 rs.cursorlocation=3
'│日  期：2009/5/9
'└──────────────────── www.DeepTeach.com 2009/2/28──┘
sub pageInit(rs,pSize  ,currentPage,pageSize)
	currentPage=request.QueryString("page")	'page值为接受值
	rs.PageSize = pSize 				'每页显示记录数
	pageSize=rs.PageSize
	if Not IsEmpty(currentPage) then 			'判断page初始化
		if Not IsNumeric(currentPage) then 	'判断page值是否为数字
		   page=1
		else
			currentPage = int(currentPage)				'接收page并化为数字型赋给page变量
		end if  
		 
		if currentPage > rs.PageCount then '如果接收的页数大于总页数
			rs.AbsolutePage = rs.PageCount '设置当前显示页等于最后页        
		elseif currentPage <= 0 then			'如果page小于等于0
			rs.AbsolutePage = 1 	'设置当前显示页等于第一页
		else
			rs.AbsolutePage = currentPage '如果大于零,显示当前页等于接收的页数 
		end if
	else
		rs.AbsolutePage=1
	end if
	currentPage = rs.AbsolutePage
end sub
'┌──────────────────── 深度空间 深度学习 ──┐
'│过程名：Function pagination(rs	,currentPage)
'│作  用：分页显示函数                     
'│参  数： rs	记录集
'│			[currentPage 当前接受页面值]此值调用时按名称原样写即可不用设置
'│说  明：	调用时仅需将rs更改成对应记录集名称,设置 pSize每页显示数
'│			1 分页初始化，以及显示循环处设界,
'│				call pageInit(rs,10  ,currentPage,pageSize)
'│			2 循环处设界
'│				if (pageSize<=0)then exit do end if
'│				pageSize=PageSize-1
'│			3 分页显示 
'│				call pagination(rs,currentPage)
'│日  期：2009/5/9
'└──────────────────── www.DeepTeach.com 2009/2/28──┘
sub pagination(rs,currentPage)
	Dim query, a, x, temp  ,action,resultCount
	pagecount=rs.PageCount		'总页数
	pagesize=rs.pagesize		'每页显示记录数
	resultCount=rs.RecordCount	'记录集中总计录数
	action = "http://" & Request.ServerVariables("HTTP_HOST") & Request.ServerVariables("SCRIPT_NAME")
	query = Split(Request.ServerVariables("QUERY_STRING"), "&")
	For Each x In query
	    a = Split(x, "=")
	    If StrComp(a(0), "page", vbTextCompare) <> 0 Then
	        temp = temp & a(0) & "=" & a(1) & "&"
	    End If
	Next	
	Response.Write("<form method='get' onsubmit=""document.location='" &action& "?" &temp& "page='+this.page.value;return false;"">")		
	if currentPage<=1 then
		Response.Write ("[首页] [上一页] ")
	else		
		Response.Write("[<a href='" & action & "?" & temp & "page=1'>首页</a>] ")
		Response.Write("[<a href='" & action & "?" & temp & "page=" & (currentPage-1) & "'>上一页</a>] ")
	end if

	if currentPage>=pagecount then
		Response.Write ("[下一页] [尾页]")		
	else
		Response.Write("[<a href='" & action & "?" & temp & "page=" & (currentPage+1) & "'>下一页</a>] ")
		Response.Write("[<a href='" & action & "?" & temp & "page=" & pagecount & "'>尾页</a>]")			
	end if
	Response.Write(" [页次:<font color='red'>" & currentPage & "</font>/" & pageCount)	
	Response.Write("] [共" & resultCount & "条 <font color='red'>"& pagesize & "</font>条/页]")
	Response.Write(" 转到<input name='page' value='" & currentPage & "' style='width:30px;'/>页<input type='submit' value='go' />")
	Response.Write("</form>")
End sub
%>