/*!
* һ򵥵Ajax
* author: ichenshy@gmail.com
* date:   2010/06/04 Friday
*
* @param function fnBefore     ûԶ庯 AjaxʼǰִУΪnull
* @param function fnAfter      ûԶ庯 AjaxɺִУΪnull
* @param function fnTimeout    ûԶ庯 AjaxʱִУΪnull
* @param integer  iTime        óʱʱ λ
* @param boolean  bSync        ǷΪͬĬΪfalse
*/

function Ajax(fnBefore,fnAfter,fnTimeout,iTime,bSync){
	this.before		= fnBefore;
	this.after		= fnAfter;
	this.timeout	= fnTimeout;
	this.time		= iTime ? iTime : 10000;
	this.async		= bSync ? false : true;
	this._request	= null;
	this._response	= null;
}

Ajax.prototype = {
	/**
	*  Ҫ͵ݽб
	*
	*  @param object data  JSONʽݣ: {username:"fyland",password:"ichenshy"}
	*/
	formatParam : function( data ){
		if ( ! data || typeof data != "object" ) return data;
		var k,r = [];
		for ( k in data ) {
			r.push([k,'=',encodeURIComponent(data[k])].join(''));
		}
		return r.join('&');
	},

	/**
	*  XMLHttpRequest
	*/
	create : function(){
		if( window.XMLHttpRequest ) {
			this._request = new XMLHttpRequest();
		} else {
			try {
				this._request = new window.ActiveXObject("Microsoft.XMLHTTP");
			} catch(e) {}
		}
	},

	/**
	* 
	*
	* @param string				url     ַ
	* @param object or string   data    ַJSONʽݣ: {username:"fyland",password:"ichenshy"}
	* @param string             method  ʽ  GET or POST
	* @param boolean            ifCache	Ƿ˻棬ĬΪfalse;
	*/
	send : function(url,data,method,ifCache){
		if ( typeof this.before == "function" ) this.before();

		method = method.toUpperCase();
		this.create();

		var self = this;
		var timer = setTimeout(function(){
				if ( typeof self.timeout == "function" ) self.timeout();
				if ( self._request ) {
					self._request.abort();
					self._request = null;
				}
				return true;
			},this.time);

		var sendBody  = this.formatParam(data);

		if ( 'GET' == method ) {
			url = [url, ( url.indexOf('?') == -1 ? '?' : '&') ,sendBody].join('');
			sendBody = null;
		}

		if ( ! ifCache ) {
			url = [url, ( url.indexOf('?') == -1 ? '?' : '&') , "ajaxtimestamp=" , (new Date()).getTime()].join('');
		}

		this._request.open(method,url,this.async);
		if ( "POST" == method ) this._request.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

		this._request.onreadystatechange = function(){
			if( self._request.readyState==4 ){
				if ( self._request.status==200 ){
					if ( timer ) clearTimeout(timer);
					self._response = self._request.responseText;
					if ( typeof self.after == "function") self.after(self._response);
				}
			}
		}
		this._request.send( sendBody );
	},

	/**
	*   򵥵GET
	*
	*   @param string url  ַ
	*   @param null or string or object	data
	*   @param object html element or string id	  e
	*   @param string loading                     loadingʱeеʾ
	*   @param boolean  ifCache    Ƿ񻺴
	*/
	get : function(url,data,e,loading,ifCache){
			if ( typeof e == "string" ) e = document.getElementById(e);
			if ( loading ) {
				var rg = /\.(gif|jpg|jpeg|png|bmp)$/i;
				if ( rg.test(loading) ){
					loading = ['<img src="', loading , '"  align="absmiddle" />'].join('');
				}
				this.before = function(){e.innerHTML = loading;}
			}
			this.after		= function(s){e.innerHTML = s;}
			this.timeout	= function(){e.innerHTML = ' ʱ! ';}
			this.send(url,data,"GET",ifCache ? true : false);
	}
};