﻿var FCAPP = FCAPP || {};
FCAPP.PICWALL = {
    CONFIG: {
        noteHeight: 30,
    },
	RUNTIME: {
        records: 0,
        total: 0,
        curScrollTop: 0,
        isSlide: false,
        SPICS: {},
        POFFSET: {}
    },
    init: function() {
        var R = PICWALL.RUNTIME,
        C = PICWALL.CONFIG;
        R.page = 1;
        if (!R.photoDiv) {
            R.photoDiv = document.getElementById('photoDiv');
            R.photoClick = document.getElementById('photoClick');
            R.loading = document.getElementById('popFail');
            R.scroller = document.getElementById('scroller');
            R.photoMask = document.getElementById('photoMask');
            R.postTM = document.getElementById('postTM');
            window.onresize = PICWALL.resizeLayout;
            window.popUp = PICWALL.popUP;
            window.closePOP = PICWALL.closePOP;
        }
    },
    
    popUP: function(idx) {
		if(curPage==1)
		{
			PICWALL.picResult();
			curPage=2;
		}
        var R = PICWALL.RUNTIME;
        R.isSlide = true;
        R.photoDiv.style.display = "";
        R.photoMask.style.display = "";
        R.photoClick.style.zIndex = "9999";
        if (!PICS[idx].dom) {
            PICS[idx].dom = document.getElementById('img_' + idx);
       }
        if (!PICS[idx].loaded) {
            PICWALL.loadImg(idx);
        }
       try {
            myScroll.refresh();
            myScroll.scrollToPage(idx, 0, 0);
        } catch(e) {}
    },
    closePOP: function() {
        var R = PICWALL.RUNTIME;
        R.isSlide = false;
        R.switchSlide = true;
        setTimeout(function() {
            R.switchSlide = false;
        },
        100);
        R.photoDiv.style.display = "none";
        R.photoMask.style.display = "none";
		$(".f-fix").show();
        //window.scrollTo(0, R.POFFSET[myScroll.currPageX]);
    },
    initScroll: function() {
        if (myScroll) {
            myScroll.destroy();
        }
        myScroll = new iScroll('wrapper', {
            zoom: false,
            snap: true,
            momentum: false,
            hScrollbar: false,
            vScrollbar: false,
            hScroll: true,
            onScrollEnd: function() {
                var R = PICWALL.RUNTIME,
                idx = myScroll.currPageX;
                if (PICS[idx]) {
					if(PICS[idx].ts!="")
					{
						$('#infopostTM').show();
                    	R.postTM.innerHTML = PICS[idx].ts;
					}
					else
					{
						$('#infopostTM').hide();
					}
                }
                if (PICS[idx] && !PICS[idx].loaded) {
                    PICWALL.loadImg(idx);
                }
           }
        });
		PICWALL.resizeLayout(true);
    },
	updateImgMargin: function() {
        var R = PICWALL.RUNTIME,
        h = R.lastHeight,
        w = R.lastWidth,
        iw, ih, th, img, margin = PICWALL.CONFIG.noteHeight;
        for (var i = 0, il = $('#theList li').length; i < il; i++) {
            var pic = PICS[i];
            img = pic.img;
            iw = pic.origWidth;
            ih = pic.origHeight;
            if (pic.loaded) {
                if (h > w && iw / ih > w / h) {
                    th = Math.floor(w * ih / iw);
                    img.style.width = w - 4 + 'px';
                    img.style.height = th + 'px';
                    img.style.marginTop = Math.floor((h - th - margin) / 2) + 'px';
                } else {
                    img.style.height = h - margin + 'px';
                    img.style.width = Math.floor(h * iw / ih) + 'px';
                    img.style.marginTop = '0px';
                }
            }
        }
    },
	resizeLayout: function(boo) {
        var R = PICWALL.RUNTIME,
        C = PICWALL.CONFIG,
        margin = PICWALL.CONFIG.noteHeight,
        w = document.documentElement.clientWidth,
        h = $(window).height();
       if (!R.lastWidth) {
            R.lastWidth = w;
            R.lastHeight = h;
            R.clientWidth = w;
            PICWALL.resizeLayout(boo);
        } else {
            if (boo || w != R.lastWidth || h != R.lastHeight) {
                R.lastHeight = h;
                R.lastWidth = w;
				R.slideLi = $('#theList li');
                R.scroller.style.width = w * R.slideLi.length + 'px';
                R.scroller.style.height = h + 'px';
                if (R.slideLi) {
                    R.slideLi.css({
                        width: w + 'px'
                    });
                }
                PICWALL.updateImgMargin();
                if (R.isSlide && myScroll) {
                    myScroll.refresh();
                    myScroll.scrollToPage(myScroll.currPageX);
                }
            }
        }
    },
    loadImg: function(idx) {
        var R = PICWALL.RUNTIME,
        C = PICWALL.CONFIG,
        h = R.lastHeight,
        w = R.lastWidth,
        pic = PICS[idx],
        margin = C.noteHeight,
        img = new Image();
        img.idx = idx;
        if (pic.loading || pic.loaded) {
            return;
        }
        img.addEventListener('load',
        function() {
            if (!pic.dom) {
                pic.dom = document.getElementById('img_' + this.idx);
            }
            if (!pic.loaded) {
                pic.dom.style.background = "none";
                pic.dom.appendChild(this);
            }
            var iw = this.width,
            ih = this.height,
            th = 0;
            if (h > w && iw / ih > w / h) {
                th = Math.floor(w * ih / iw);
                this.style.width = w - 4 + 'px';
                this.style.height = th + 'px';
                this.style.marginTop = Math.floor((h - th - margin) / 2) + 'px';
            } else {
             this.style.height = h - margin + 'px';
                this.style.width = Math.floor(h * iw / ih) + 'px';
            }
           pic.origWidth = iw;
            pic.origHeight = ih;
            pic.img = this;
            pic.loaded = true;
            pic.loading = false;
            delete pic.dom;
            delete pic.url;
            this.onload = null;
        });
        img.src = pic.url;
        pic.loading = true;
    },
    picResult: function() {
        if (!myScroll) {
                PICWALL.initScroll();
            } else {
				PICWALL.resizeLayout(true);
                var idx = myScroll.currPageX;
                myScroll.refresh();
                myScroll.scrollToPage(idx);
            }
    }
};
var PICWALL = FCAPP.PICWALL,
tm = null,
myScroll;
$(document).ready(PICWALL.init);