
function Menu(container, selectNum)
{
	
	this.container = container;
	this.selectNum = selectNum;
	this.timer;
	this.clickMotion = false;

	this.init();
	this.selectMenu( selectNum );
}

Menu.prototype.init = function ()
{
	var owner = this;
	this.container.find("li").each( function ( i )
	{
		$(this).bind("mouseover", overMenu);
		$(this).bind("mouseout", outMenu);

		function overMenu()
		{
			owner.selectMenu( $(this).index()+1 );
			clearInterval( owner.timer );
		}

		function outMenu()
		{
			owner.timer = setInterval( function (){ owner.selectMenu( owner.selectNum )}, 600 );
		}

	});

	
}

Menu.prototype.clickMenu = function ( idx )
{
	var owner = this;

    owner.clickMotion = true;
	$("html, body").stop().animate({scrollTop:$("#IndexMenu"+idx).offset().top-80}, {easing:"easeInOutCubic", complete:motionEnd});
	

	this.selectNum = idx;
	this.selectMenu( idx );

	function motionEnd()
	{
		owner.clickMotion = false;
	}

}

Menu.prototype.changeMenu = function ( idx )
{
	if(this.clickMotion) return;
	this.selectNum = idx;
	this.selectMenu( idx );
}

Menu.prototype.selectMenu = function ( idx )
{
	this.container.find("li").each( function ( i )
	{
		if(idx-1 == i)
		{
			$(this).find("a").css({"color":"#4AB800"});
			$("#IndexCom"+idx).css({"background":"url(/Shop/Images/hot_table_2.png) no-repeat left center"});
		}
		else 
		{
			$(this).find("a").css({"color":"#625351"});
		}
	});
}