﻿


/**
* 星星打分组件
*
* @author    Yunsd
* @date        2010-7-5
*/
var Class = {
    create: function () {
        return function () { this.initialize.apply(this, arguments); }
    }
}
var Extend = function (destination, source) {
    for (var property in source) {
        destination[property] = source[property];
    }
}
function stopDefault(e) {
    if (e && e.preventDefault) {
        e.preventDefault();
    } else {
        window.event.returnValue = false;
    }
    return false;
}

var Stars = Class.create();
Stars.prototype = {
    initialize: function (star, options) {
        this.SetOptions(options); //默认属性
        var flag = 999; //定义全局指针
        var isIE = (document.all) ? true : false; //IE?
        var starlist = document.getElementById(star).getElementsByTagName('a'); //星星列表
        var input = document.getElementById(star + "-input"); // 输出结果
        var tips = document.getElementById(star + "-tips"); // 打印提示
        var nowClass = " " + this.options.nowClass; // 定义选中星星样式名
        var tipsTxt = this.options.tipsTxt; // 定义提示文案
        var len = starlist.length; //星星数量

        for (i = 0; i < len; i++) { // 绑定事件 点击 鼠标滑过
            starlist[i].value = i;
            starlist[i].onclick = function (e) {
                stopDefault(e);
                this.className = this.className + nowClass;
                flag = this.value;
                input.value = this.getAttribute("star:value");
                tips.innerHTML = tipsTxt[this.value]
            }
            starlist[i].onmouseover = function () {
                if (flag < 999) {
                    var reg = RegExp(nowClass, "g");
                    starlist[flag].className = starlist[flag].className.replace(reg, "")
                }
            }
            starlist[i].onmouseout = function () {
                if (flag < 999) {
                    starlist[flag].className = starlist[flag].className + nowClass;
                }
            }
        };
        if (isIE) { //FIX IE下样式错误
            var li = document.getElementById(star).getElementsByTagName('dl');
            for (var i = 0, len = li.length; i < len; i++) {
                var c = li[i];
                if (c) {
                    c.className = c.getElementsByTagName('a')[0].className;
                }
            }
        }
    },
    //设置默认属性
    SetOptions: function (options) {
        this.options = {//默认值
            Input: "", //设置触保存分数的INPUT
            Tips: "", //设置提示文案容器
            nowClass: "current-rating", //选中的样式名
            tipsTxt: ["非常不满意", "不满意", "一般", "满意", "非常满意"]//提示文案
        };
        Extend(this.options, options || {});
    }
}
/* For TEST */
function teststars() {
    alert(document.getElementById("stars1-input").value + "|" + document.getElementById("stars2-input").value)
}
var Stars1 = new Stars("stars1")
var Stars2 = new Stars("stars2")
var Stars3 = new Stars("stars3")


//****************图片放大JS******************

var imageZoom = function (img, options) {
    this.img = this.g(img);
    if (this.img.nodeName != "IMG") {
        if (this.img && this.img.children[0].nodeName == "IMG") this.img = this.img.children[0];
        else throw Error("Invalid argument [img] !");
    }
    this.setOptions(options);
    this.init();
}
imageZoom.prototype = {
    g: function (id) { return typeof (id) == "string" ? document.getElementById(id) : id; },
    ae: function (el, type, call) {
        if (el.addEventListener) el.addEventListener(type, call, false);
        else el.attachEvent("on" + type, call);
    },
    getPos: function (o) {//取元素坐标
        var x = 0, y = 0;
        do { x += o.offsetLeft; y += o.offsetTop; }
        while (o = o.offsetParent);
        return { 'x': x, 'y': y };
    },
    setOptions: function (options) {
        this.options = {
            mul: 0, //默认为不放大（显示图片的原来大小）
            bigImg: null, //指定放大的图片路径（要跟小图成比例才好）
            viewer: null, //指定显示的位置(可以为一个div或者其id)
            viewerCla: "", //指定预览的div的类样式
            viewerMul: 1, //指定显示div的放大倍数，默认为原大小,设置viewer时此参数无效
            viewerPos: { h: 10, v: 0 }, //自定义展示层位置,h水平文向，v垂直方向 ,假如水平方向，正数表示右边，负数表示左边
            onShow: function () { }, //自定义事件，显示时触发，当viewer不为空时无效
            onHide: function () { }
        };
        for (var o in options) { this.options[o] = options[o]; }
        this.options.bigImg = this.options.bigImg || this.img.src;
    },
    getSize: function (o) {
        return { w: o.offsetWidth, h: o.offsetHeight };
    },
    createView: function () {
        var _is = this.getSize(this.img);
        var d = document;
        if (this.options.viewer) {
            this.viewer = this.g(this.options.viewer);
            this.viewer.style.overflow = "hidden";
            this.viewer.style.position = "relative";
        } else {
            this.viewer = d.createElement("div");
            this.viewer.className = this.options.viewerCla;
            var pos = this.getPos(this.img);

            var t = pos.y + this.options.viewerPos.v;
            if (this.options.viewerPos.v < 0) { t -= _is.h * this.options.viewerMul; }
            else if (this.options.viewerPos.v > 0) { t += _is.h; }
            else t = pos.y;

            var l = pos.x + this.options.viewerPos.h;
            if (this.options.viewerPos.h < 0) { l -= _is.w * this.options.viewerMul; }
            else if (this.options.viewerPos.h > 0) { l += _is.w; }
            else l = pos.x + _is.w;

            this.viewer.style.cssText = "display:none;overflow:hidden;position:absolute;top:" + (t) + "px;left:" + (l) + "px;height:" + _is.h * this.options.viewerMul + "px;width:" + _is.w * this.options.viewerMul + "px";
            d.body.appendChild(this.viewer);
        }
        this.viewimg = d.createElement("img");
        this.viewimg.style.cssText = "position:relative;left:-33%;top:-33%;";
        this.viewimg.src = this.options.bigImg;
        if (this.options.mul) {//设置放大倍数
            this.viewimg.style.width = _is.w * this.options.mul + "px";
            this.viewimg.style.height = _is.h * this.options.mul + "px";
        }
        this.viewer.appendChild(this.viewimg);
    },
    move: function (e) {
        if (!this.options.mul)
            this.options.mul = this.viewimg.offsetHeight / this.img.offsetHeight;
        var pos = this.getPos(this.img);
        var l = e.clientX - pos.x + (document.documentElement.scrollLeft || document.body.scrollLeft); //鼠标位置相对于图片左上角的偏移
        var t = e.clientY - pos.y + (document.documentElement.scrollTop || document.body.scrollTop);
        var zs = this.getSize(this.viewer);
        var pl = -l * this.options.mul + zs.w / 2;
        var pt = -t * this.options.mul + zs.h / 2;
        pl = pl > 0 ? 0 : pl;
        pt = pt > 0 ? 0 : pt;

        var vs = this.getSize(this.viewimg);
        pl = Math.max(pl, zs.w - vs.w);
        pt = Math.max(pt, zs.h - vs.h);

        this.viewimg.style.left = pl + "px";
        this.viewimg.style.top = pt + "px";
    },
    init: function () {
        var o = this;
        var load = function (a) {//图片加载
            o.createView.call(o);
            o.img.setAttribute("alt", "");
            o.ae(o.img, "mousemove", function (event) { o.move.call(o, event); });
            if (!o.options.viewer) {
                o.ae(o.img, "mouseover", function () { o.options.onShow(); o.viewer.style.display = "" });
                o.ae(o.img, "mouseout", function () { o.options.onHide(); o.viewer.style.display = "none" });
            }
        };
        if (typeof (document.readyState) == "undefined" || window.opera) {
            var de = document.documentElement || document.body;
            var h = de.scrollHeight;
            var t = setInterval(function () {
                if (h == de.scrollHeight) {
                    clearInterval(t);
                    load();
                } else h = de.scrollHeight;
            }, 500);
        } else if (document.readyState == "complete")
            load();
        else
            o.ae(window, "load", load);
    }
};

//********************************评价分页***********************************

function PingLun(productId, pageCount2,type) {
    $(function () {
        var infocommentId = productId;
        var PageCount = 0;
        var pageSize = 5;

        $.ajax({
            url: '/Ashx/HandlerComments.ashx', //目标地址
            type: "POST",
            dataType: "json", //数据格式:JSON
            data: "action=pageCount&InformationId=" + infocommentId,
            success: function (pagecount) {
                PageCount = pagecount;
            }
        });

        // 初始化数据(显示第一页)
        InitData(infocommentId, "Rec_CreateTime", "Desc", pageSize, 0, PageCount);

        function pageselectCallback(page_id, jq) {
            InitData(infocommentId, "CreateDate", "Desc", pageSize, page_id, PageCount);
        }
        // ★分页主函数(类别ID，排序字段，排序类型，页大小，页索引，总条数)
        function InitData(InfocommentId, order, ordertype, PageSize, pageindx, pageCount) {

            $.ajax({
                url: '/Ashx/HandlerComments.ashx', //目标地址
                type: "POST", //用POST方式传输
                dataType: "json", //数据格式:JSON
                data: "action=pager&InformationId=" + InfocommentId + "&order=" + order + "&orderType=" + ordertype + "&pageSize=" + PageSize + "&pageIndex=" + (pageindx + 1),
                success: function (json) {
                    var listDate = json.ListData;
                    var html = "";
                    $.each(listDate, function (index, n) {
                        html += "<ul class=\"cmmt_ul1\"><li class=\"cmmt_li1\"><img src=\"../images/NewImages/img_04.gif\" /></li><li class=\"cmmt_li2\"><font>" + n.UserName + "</font><br />";
                        html += "<b>评论：</b>" + n.CommentContent + "</li><li class=\"cmmt_li3\">" + n.Rec_CreateTime + "<br />评分：<img src=\"../images/NewImages/icon21.gif\" /></li></ul>";
                    });
                    // 输出HTML
                    if (type == 1) {
                        $("#tcontentList1").html(html);
                    }
                    if (type == 2) {
                        $("#tcontentList2").html(html);
                    }
                    if (type == 3) {
                        $("#tcontentList3").html(html);
                    }
                    if (type == 4) {
                        $("#tcontentList4").html(html);
                    }
                }
            });
            if (type == 1) {
                $("#Pagination").pagination(pageCount2, {
                    callback: pageselectCallback,
                    prev_text: '« 上一页',
                    next_text: '下一页 »',
                    items_per_page: pageSize, // 每页显示条数
                    num_display_entries: 6, // 前面显示几个按钮
                    current_page: pageindx, // 当前页索引,这里0为第一页
                    num_edge_entries: 2// 后面显示几个按钮
                });
            }
            if (type == 2) {
                $("#Pagination2").pagination(pageCount2, {
                    callback: pageselectCallback,
                    prev_text: '« 上一页',
                    next_text: '下一页 »',
                    items_per_page: pageSize, // 每页显示条数
                    num_display_entries: 6, // 前面显示几个按钮
                    current_page: pageindx, // 当前页索引,这里0为第一页
                    num_edge_entries: 2// 后面显示几个按钮
                });
            }
            if (type == 3) {
                $("#Pagination3").pagination(pageCount2, {
                    callback: pageselectCallback,
                    prev_text: '« 上一页',
                    next_text: '下一页 »',
                    items_per_page: pageSize, // 每页显示条数
                    num_display_entries: 6, // 前面显示几个按钮
                    current_page: pageindx, // 当前页索引,这里0为第一页
                    num_edge_entries: 2// 后面显示几个按钮
                });
            }
            if (type == 4) {
                $("#Pagination4").pagination(pageCount2, {
                    callback: pageselectCallback,
                    prev_text: '« 上一页',
                    next_text: '下一页 »',
                    items_per_page: pageSize, // 每页显示条数
                    num_display_entries: 6, // 前面显示几个按钮
                    current_page: pageindx, // 当前页索引,这里0为第一页
                    num_edge_entries: 2// 后面显示几个按钮
                });
            }

        }
    });
}
//添加评论
function AddPinglun(userId,userName,commodityId) {
    var productEval = document.getElementById("stars1-input").value;
    var delievryEval = document.getElementById("stars2-input").value;
    var serviceEval = document.getElementById("stars3-input").value;
    //userId = "5A58A88F-42A1-46A5-BE97-B55C00928618";
    //userName = "zhangjia";
    if (productEval.length < 1 || delievryEval.length < 1 || serviceEval.length < 1) {
        alert("请对产品,配送,服务进行评价");
        return false;
    }
    if (userId.length < 1) {
        alert("请先登录再进行评价!");
        return false;
    }
    $.ajax({
        url: '/Ashx/HandlerComments.ashx', //目标地址
        type: "POST", //用POST方式传输
        dataType: "JSON", //数据格式:JSON
        data: "action=AddComment&commodityId=" + commodityId + "&userId=" + userId + "&userName=" + userName + "&productEval=" + productEval + "&delievryEval=" + delievryEval + "&serviceEval=" + serviceEval,
        success: function (json) {
            if (json == "1") {
                alert("您没有买过此商品或已经投过票了，不能进行投票!");
                return false;
            }
            else if (json == "2") {
                alert("评论成功!");
                GetPingLun(commodityId);
            }
            else if (json == "3") {
                alert("评论失败!");
                return false;
            }
        }
    });

}
//获得评论情况
function GetPingLun(commodityId) {
    $.ajax({
        url: '/Ashx/HandlerComments.ashx', //目标地址
        type: "POST", //用POST方式传输
        dataType: "JSON", //数据格式:JSON
        data: "action=GetNumber&commodityId=" + commodityId,
        success: function (json) {
            var varComm = json.split('|');
            document.getElementById("ctl00_ContentPlaceHolder1_lblGoodNumber").innerHTML = varComm[0] + '%';
            var html = "";
            html += "<div><p>好评</p><div class=\"cmmt_p1\"><div class=\"percent-bar\"  style=\"width:" + varComm[0] + "%\"> </div></div><p>" + varComm[0] + "%</p></div>";
            html += "<div><p>中评</p><div class=\"cmmt_p1\"><div class=\"percent-bar\"  style=\"width:" + varComm[1] + "%\"> </div></div><p>" + varComm[1] + "%</p></div>";
            html += "<div><p>差评</p><div class=\"cmmt_p1\"><div class=\"percent-bar\"  style=\"width:" + varComm[2] + "%\"> </div></div><p>" + varComm[2] + "%</p></div>";
            document.getElementById("liCommentResult").innerHTML = html;
        }
    });
}

function BuyHistory(id) {
    $.ajax({
        url: '/Ashx/BuyHistoryHandler.ashx', //目标地址
        type: "POST", //用POST方式传输
        dataType: "json", //数据格式:JSON
        data: "action=buyhistory&CommodityId=" + id,
        beforeSend: function () { $("#divload").show(); $("divHistory").hide(); }, //发送数据之前
        complete: function () { $("#divload").hide(); $("#divHistory").show(); }, //接收数据完毕
        success: function (json) {
            var listDate = json.ListData;
            var html = "";
            var title = "易果装";
            $.each(listDate, function (index, n) {

                if (n.PackageType == "1") {
                    title = "小包装";
                }
                else if (n.PackageType == "4") {
                    title = "原装";
                }
                html += "<p class=\"p_1\"><a href=\"../CommodityDetail.aspx?CommodityId=" + n.CommodityId + "\"> <img src=\"../img/" + n.PictureName + "\" width=\"147px\" height=\"147px\"  title=\"" + n.CommodityName + "\" /></a>";
                html += "<span>" + n.CommodityName + "<br /><b>" + Math.round((n.Price) * 100) / 100 + "元/" + title + "</span></p>";
            });
            // 输出HTML
            document.getElementById("divHistory").innerHTML = html;
        }
    });
}