// JavaScript Document
/*图片轮播*/
(function($){
	$.fn.Xslider = function(options){var settings ={
			speed: 1200, //动画速度
			space: 3000, //时间间隔
			auto: true, //自动滚动
			trigger: 'mouseover', //触发事件 注意用mouseover代替hover
			conbox: '.conbox', //内容容器id或class
			ctag: 'a', //内容标签 默认为<a>
			switcher: '.switcher', //切换触发器id或class
			stag: 'a', //切换器标签 默认为a
			current:'cur' //当前切换器样式名称
		};
		settings = $.extend({}, settings, options);
		var index = 1;
		var last_index = 0;
		var $conbox = $(this).find(settings.conbox),$contents = $conbox.find(settings.ctag);
		var $switcher = $(this).find(settings.switcher),$stag = $switcher.find(settings.stag);
		$.each($contents,function(k, v){
			(k === 0) ? $(this).css({'position':'absolute','z-index':9}):$(this).css({'position':'absolute','z-index':1,'opacity':0});
		});
		function slide(){
			if (index >= $contents.length){index = 0;}
			$stag.removeClass(settings.current).eq(index).addClass(settings.current);
			$contents.eq(last_index).stop().animate({'opacity': 0}, settings.speed/2).css('z-index',1)
				.end().eq(index).css('z-index',9).stop().animate({'opacity': 1}, settings.speed/2);
			last_index = index;
			index++;
		};
		if(settings.auto) var Timer = setInterval(slide, settings.space);
		$stag.bind(settings.trigger,function(){
			_pause();
			index = $(this).index();
			slide();
		});
		$conbox.hover(_pause,_continue);
		function _pause(){
			clearInterval(Timer);
		}
		function _continue(){
			if(settings.auto)Timer = setInterval(slide, settings.space);
		}	
	}
})(jQuery);

/*图片循环切换（左右、上下通过vertical来控制） */
$(document).ready(function(){
	$.fn.jCarouselLite=function(o){
		o=$.extend({btnPrev:null,btnNext:null,btnGo:null,mouseWheel:false,auto:null,speed:600,easing:null,vertical:false,circular:true,visible:1,start:0,scroll:1,beforeStart:null,afterEnd:null},o||{});
		return this.each(function(){
			var b=false,animCss=o.vertical?"top":"left",sizeCss=o.vertical?"height":"width";
			var c=$(this),ul=$("ul",c),tLi=$("li",ul),tl=tLi.size(),v=o.visible;
			if(o.circular&&tl>1){
				ul.prepend(tLi.slice(tl-v).clone()).append(tLi.slice(0,v).clone());
				o.start+=v;
			}else{
				return false;
			}
			var f=$("li",ul),itemLength=f.size(),curr=o.start;
			var g=o.vertical?height(f):width(f);
			var h=g*itemLength;
			//f.css({width:f.width(),height:f.height()});
			ul.css(sizeCss,h+"px").css(animCss,-(curr*g));
			if(tl>v){//判断总的图片数是否大于可显示的图片数                  
				if(o.btnPrev){
					$(o.btnPrev).click(function(){return go(curr-o.scroll)});
					$(o.btnPrev).hover(function(){
						$(this).addClass("left_hover");	
					},function(){
						$(this).removeClass("left_hover");
					});}
				if(o.btnNext){
					$(o.btnNext).click(function(){return go(curr+o.scroll)});
					$(o.btnNext).hover(function(){
						$(this).addClass("right_hover");	
					},function(){
						$(this).removeClass("right_hover");
					});}
			}
			if(o.btnGo)
				$.each(o.btnGo,function(i,a){$(a).click(function(){return go(o.circular?o.visible+i:i)})});
			if(o.mouseWheel&&c.mousewheel)
				c.mousewheel(function(e,d){return d>0?go(curr-o.scroll):go(curr+o.scroll)});
			if(o.auto){
				var Timer;
				if(tl>v)
				$(c).hover(function(){clearInterval(Timer);},function(){ Timer=setInterval(function(){go(curr+o.scroll)},o.auto+o.speed);}).trigger("mouseleave");
			}
			function vis(){return f.slice(curr).slice(0,v)};
			function go(a){
				if(!b){
					if(o.beforeStart)
						o.beforeStart.call(this,vis());
					if(o.circular){
						if(a<=o.start-v-1){
							ul.css(animCss,-((itemLength-(v*2))*g)+"px");
							curr=a==o.start-v-1?itemLength-(v*2)-1:itemLength-(v*2)-o.scroll
						}
						else if(a>=itemLength-v+1){
							ul.css(animCss,-((v)*g)+"px");
							curr=a==itemLength-v+1?v+1:v+o.scroll
						}
						else{
							curr=a;
						}
					}
					else{
						if(a<0||a>itemLength-v)return;
						else curr=a
					}
					b=true;
					ul.animate(animCss=="left"?{left:-(curr*g)}:{top:-(curr*g)},o.speed,o.easing,function(){
						if(o.afterEnd)
							o.afterEnd.call(this,vis());
						b=false;
					});
					if(!o.circular){
						$(o.btnPrev+","+o.btnNext).removeClass("disabled");
						$((curr-o.scroll<0&&o.btnPrev)||(curr+o.scroll>itemLength-v&&o.btnNext)||[]).addClass("disabled")
					}
				}
				return false
			}
		});
	};
	function css(a,b){return parseInt($.css(a[0],b))||0};
	function width(a){return a[0].offsetWidth+css(a,'marginLeft')+css(a,'marginRight')};
	function height(a){return a[0].offsetHeight+css(a,'marginTop')+css(a,'marginBottom')}
});

$(document).ready(function(){
	$("#slider3").Xslider({ctag: 'div',stag:'li'});
	$(".slider1").jCarouselLite({btnNext: ".btn_right1",btnPrev: ".btn_left1",speed:200,visible:5,scroll:1,auto:4000});
	$(".hotSlider1").jCarouselLite({btnNext: ".br_1",btnPrev: ".bl_1",speed:200,auto:4000});
	$(".hotSlider2").jCarouselLite({btnNext: ".br_2",btnPrev: ".bl_2",speed:200,auto:4000});
	$(".hotSlider3").jCarouselLite({btnNext: ".br_3",btnPrev: ".bl_3",speed:200,auto:4000});
	$(".hotSlider4").jCarouselLite({btnNext: ".br_4",btnPrev: ".bl_4",speed:200,auto:4000});
	$(".hotSlider5").jCarouselLite({btnNext: ".br_5",btnPrev: ".bl_5",speed:200,auto:4000});
	$(".hotSlider6").jCarouselLite({btnNext: ".br_6",btnPrev: ".bl_6",speed:200,auto:4000});
	$(".pro_cnt li dl,.sort_cnt dl").hover(function(){
		$(this).addClass("curr");
	},function(){
		$(this).removeClass("curr");
	});
});