Array.prototype.inArray = function (value){
  var i;
  for (i=0; i < this.length; i++){
      if (this[i] === value){
          return true;
      }
  }
  return false;
}

jQuery.MsgBox = function(settings) {
    settings = jQuery.extend({
        img_url_prefix:'',   //图片的绝对路径
        overlayBgColor:'black',
        overlayOpacity: 0.2,
        title:'提示',
        boxwidth:"400px",
        html: '',
        hidden:false,
        callback:''
     },settings);

    function _initialize() {
        _start();
        return false;
    };

    function _start(){
        $('embed, object,select').css({ 'visibility' : 'hidden' });
        _set_interface();
    };

    function _set_interface(){
        $('body').append('<div id="floatbox-overlay"></div><div id="floatbox" style="display:none;'+settings.boxwidth+'"><div class="topCon"><div style="float:left;width:340px"><strong>'+settings.title+'</strong></div><a class="close_float" href="javascript:void(0)" onclick="close_msg_box();"></a></div>'+settings.html+'</div>');

        var arrPageSizes = ___getPageSize();

        $('#floatbox-overlay').css({
            backgroundColor:	settings.overlayBgColor,
            opacity:			settings.overlayOpacity,
            width:				arrPageSizes[0],
            height:				arrPageSizes[1]
        }).fadeIn();

        var arrPageScroll = ___getPageScroll();
        $('#floatbox').css({
            top:	parseInt(arrPageScroll[1] + (arrPageSizes[3] / 10)+100),
            left:	parseInt((arrPageSizes[0] - $('#floatbox').width())/2)
        }).show();

        $(window).resize(function() {
            var arrPageSizes = ___getPageSize();
            $('#floatbox-overlay').css({width:arrPageSizes[0],height:arrPageSizes[1]});
        });

        $('.topCon')[0].onmousedown = function(event) {try{menudrag($('#floatbox')[0], event, 1);}catch(e){}};
		document.body.onmousemove = function(event) {try{menudrag($('#floatbox')[0], event, 2);}catch(e){}};
		$('.topCon')[0].onmouseup = function(event) {try{menudrag($('#floatbox')[0], event, 3);}catch(e){}};

        if(typeof (settings.callback) == 'function'){
             //alert(settings.callback)
            settings.callback.apply($('#floatbox')[0],[1,2,3,4,5]);
        }
    };

    function ___getPageSize() {
        var xScroll, yScroll;
        if (window.innerHeight && window.scrollMaxY) {
            xScroll = window.innerWidth + window.scrollMaxX;
            yScroll = window.innerHeight + window.scrollMaxY;
        } else if (document.body.scrollHeight > document.body.offsetHeight){ // all but Explorer Mac
            xScroll = document.body.scrollWidth;
            yScroll = document.body.scrollHeight;
        } else { // Explorer Mac...would also work in Explorer 6 Strict, Mozilla and Safari
            xScroll = document.body.offsetWidth;
            yScroll = document.body.offsetHeight;
        }
        var windowWidth, windowHeight;
        if (self.innerHeight) {	// all except Explorer
            if(document.documentElement.clientWidth){
                windowWidth = document.documentElement.clientWidth;
            } else {
                windowWidth = self.innerWidth;
            }
            windowHeight = self.innerHeight;
        } else if (document.documentElement && document.documentElement.clientHeight) { // Explorer 6 Strict Mode
            windowWidth = document.documentElement.clientWidth;
            windowHeight = document.documentElement.clientHeight;
        } else if (document.body) { // other Explorers
            windowWidth = document.body.clientWidth;
            windowHeight = document.body.clientHeight;
        }
        // for small pages with total height less then height of the viewport
        if(yScroll < windowHeight){
            pageHeight = windowHeight;
        } else {
            pageHeight = yScroll;
        }
        // for small pages with total width less then width of the viewport
        if(xScroll < windowWidth){
            pageWidth = xScroll;
        } else {
            pageWidth = windowWidth;
        }
        arrayPageSize = new Array(pageWidth,pageHeight,windowWidth,windowHeight);
        return arrayPageSize;
    }
    /**
     / THIRD FUNCTION
     * getPageScroll() by quirksmode.com
     *
     * @return Array Return an array with x,y page scroll values.
     */
    function ___getPageScroll() {
        var xScroll, yScroll;
        if (self.pageYOffset) {
            yScroll = self.pageYOffset;
            xScroll = self.pageXOffset;
        } else if (document.documentElement && document.documentElement.scrollTop) {	 // Explorer 6 Strict
            yScroll = document.documentElement.scrollTop;
            xScroll = document.documentElement.scrollLeft;
        } else if (document.body) {// all other Explorers
            yScroll = document.body.scrollTop;
            xScroll = document.body.scrollLeft;
        }
        arrayPageScroll = new Array(xScroll,yScroll);
        return arrayPageScroll;
    };

    //移动
    var menudragstart = [];
    function menudrag(menuobj, e, op){
        if(op == 1) {
            if(['TEXTAREA', 'INPUT', 'BUTTON', 'SELECT','A'].inArray($.browser.msie ? event.srcElement.tagName : e.target.tagName)){
                return;
            }
            menudragstart = $.browser.msie ? [event.clientX, event.clientY] : [e.clientX, e.clientY];
            menudragstart[2] = parseInt(menuobj.style.left);
            menudragstart[3] = parseInt(menuobj.style.top);
            doane(e);
        } else if(op == 2 && menudragstart[0]) {
            var menudragnow = $.browser.msie ? [event.clientX, event.clientY] : [e.clientX, e.clientY];
            menuobj.style.left = (menudragstart[2] + menudragnow[0] - menudragstart[0]) + 'px';
            menuobj.style.top = (menudragstart[3] + menudragnow[1] - menudragstart[1]) + 'px';
            doane(e);
        } else if(op == 3) {
            menudragstart = [];
            doane(e);
        }
    }

    function doane(event) {
        e = event ? event : window.event;
        if($.browser.msie) {
            e.returnValue = false;
            e.cancelBubble = true;
        } else if(e) {
            e.stopPropagation();
            e.preventDefault();
        }
    }

    function _finish() {
        //$('#floatbox').slideUp('fast',function(){ $('#floatbox').remove(); });
        $('#floatbox').remove();
        $('#floatbox-overlay').remove();
        $('embed, object, select').css({ 'visibility' : 'visible' });
    }

    if(settings.hidden){
        setTimeout(function(){_finish();},1000);
    }

	return _initialize();
 }

//外部调用的close box
function close_msg_box(){
    try{
        $('#floatbox').remove();
        $('#floatbox-overlay').remove();
        // Show some elements to avoid conflict with overlay in IE. These elements appear above the overlay.
        $('embed, object, select').css({ 'visibility' : 'visible' });
    }catch(e){}
}
