<?php
if (!defined('IN_HANFOX')) exit('Access Denied');

$pagename = '网站目录';
$pageurl = '?mod=directory';
$tempfile = 'directory.html';
$table = $DB->table('website');

$pagesize = 10;
$curpage = intval($_GET['page']);
if ($curpage > 1) {
	$start = ($curpage - 1) * $pagesize;
} else {
	$start = 0;
	$curpage = 1;
}
		
$cate_id = intval($_GET['cid']);
$cache_id = $cate_id.'-'.$curpage;

if (!$smarty->isCached($tempfile, $cache_id)) {
	$pageurl .= '&cid='.$cate_id;
	
	$cate = get_one_category($cate_id);
	if (!$cate) {
		unset($cate);
		redirect('./?mod=index');
	}
	
	$smarty->assign('site_title', $cate['cate_name'].' - 网址大全 - '.$options['site_title']);
	$smarty->assign('site_keywords', !empty($cate['cate_keywords']) ? $cate['cate_keywords'] : "$cate[cate_name]分类，$cate[cate_name]网站，$cate[cate_name]网址，$cate[cate_name]目录");
	$smarty->assign('site_description', !empty($cate['cate_description']) ? $cate['cate_description'] : "$cate[cate_name]网站目录，主要收录与$cate[cate_name]相关的优秀网站，为用户提供最优的$cate[cate_name]等相关内容。");
	$smarty->assign('site_path', get_sitepath($cate['cate_id']));
	$smarty->assign('site_rss', get_rssfeed($cate['cate_id']));
			
	$where = "w.web_status=3";
	if ($cate['cate_childcount'] > 0) {
		$where .= " AND w.cate_id IN (".$cate['cate_arrchildid'].")";
		$child_category = get_categories($cate['cate_id']);
	} else {
		$where .= " AND w.cate_id=$cate_id";
		$child_category = get_categories($cate['root_id']);
	}
			
	$weblist = get_website_list($where, 'web_ctime', 'DESC', $start, $pagesize);
	$total = $DB->get_count($table.' w', $where);
	$showpage = showpage($pageurl, $total, $curpage, $pagesize);
			
	$smarty->assign('pagename', $pagename);
	$smarty->assign('category_id', $cate['cate_id']);
	$smarty->assign('category_name', $cate['cate_name']);
	$smarty->assign('child_category', $child_category);
	$smarty->assign('total', $total);
	$smarty->assign('weblist', $weblist);
	$smarty->assign('showpage', $showpage);
	unset($child_category, $weblist);
}
	
smarty_output($tempfile, $cache_id);
?>