<?php
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP 5.2.4 or newer
 *
 * This content is released under the MIT License (MIT)
 *
 * Copyright (c) 2014, British Columbia Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the 'Software'), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @package	CodeIgniter
 * @author	EllisLab Dev Team
 * @copyright	Copyright (c) 2008 - 2014, EllisLab, Inc. (http://ellislab.com/)
 * @copyright	Copyright (c) 2014, British Columbia Institute of Technology (http://bcit.ca/)
 * @license	http://opensource.org/licenses/MIT	MIT License
 * @link	http://codeigniter.com
 * @since	Version 1.0.0
 * @filesource
 */
defined('BASEPATH') OR exit('No direct script access allowed');

$lang['form_validation_required'] 			= '{field} 必须填写.';
$lang['form_validation_isset']				= '{field} 一定要有内容.';
$lang['form_validation_valid_email']		= '{field} 必须是一个有效的电子邮箱地址.';
$lang['form_validation_valid_emails'] 		= '{field} 必须是有效的电子邮箱地址.';
$lang['form_validation_valid_url'] 			= '{field} 必须是有效的网址.';
$lang['form_validation_valid_ip'] 			= '{field} 必须是一个有效IP地址.';
$lang['form_validation_min_length']			= '{field} 至少包含 {field} 个字.';
$lang['form_validation_max_length']			= '{field} 不能超过 {field} 个字.';
$lang['form_validation_exact_length']		= '{field} 必须刚好 {field} 个字.';
$lang['form_validation_alpha']				= '{field} 只能包含英文字母.';
$lang['form_validation_alpha_numeric']		= '{field} 只能包含英文字母或数字.';
$lang['form_validation_alpha_numeric_spaces']	= 'The {field} field may only contain alpha-numeric characters and spaces.';
$lang['form_validation_alpha_dash']			= '{field} 只能包含英文字母、数字、下划线、或破折号.';
$lang['form_validation_numeric']			= '{field} 只能包含数字.';
$lang['form_validation_is_numeric']			= '{field} 只能包含数字.';
$lang['form_validation_integer']			= '{field} 只能包含整数.';
$lang['form_validation_regex_match']		= '{field} 格式不正确.';
$lang['form_validation_matches']			= '{field} 与 {field} 不相符合.';
$lang['form_validation_differs']		    = '{field} 不能和 {param} 相同.';
$lang['form_validation_is_unique'] 		    = 'The {field} field must contain a unique value.';
$lang['form_validation_is_natural']			= '{field} 必须是自然数(非负整数).';
$lang['form_validation_is_natural_no_zero']	= '{field} 必须是大于零的自然数(非负整数).';
$lang['form_validation_decimal']			= '{field} 只能包含小数.';
$lang['form_validation_less_than']			= '{field} 必须小于 {field}.';
$lang['form_validation_less_than_equal_to']	= 'The {field} field must contain a number less than or equal to {param}.';
$lang['form_validation_greater_than']		= '{field} 必须大于 {field}.';
$lang['form_validation_greater_than_equal_to']	= 'The {field} field must contain a number greater than or equal to {param}.';

/* End of file form_validation_lang.php */
/* Location: ./system/language/chinese/form_validation_lang.php */