<%
''' XML 操作类
''' ==================================================================

class eycms_clsxml
	private strfile, objdoc

	private sub class_initialize()
		strfile = ""
	end sub

	private sub class_terminate()
		set objdoc = nothing
	end sub

	public property let file(str)
		set objdoc = server.createobject("microsoft.xmldom")
		objdoc.async = false
		strfile = server.mappath(str)
		objdoc.load strfile
	end property

	public property get file()
		file = strfile
	end Property
	
	public sub save()
		objdoc.save strfile
	end sub

	'创建初始化的XML    参数：(文件路径、根节点名)
	public function createfile(strpath, strroot)
		dim objfso, objtextfile, xmlstr
		set objfso = server.createobject("ADODB.Stream")
		xmlstr = "<?xml version=""1.0"" encoding=""utf-8""?>" & vbcrlf
		xmlstr = xmlstr & "<" & strroot & "/>"
		with objfso
			.type=2
			.mode=3
			.charset="utf-8"
			.open
			.writetext xmlstr
			.savetofile server.mappath(strpath), 2
			.close
		end with
		me.file = strpath
		set objfso = nothing
	end Function
	
	'获取节点的值    参数：(节点路径、标识符)    其中标识符：0表示所有，非0表示第几个
	public function getfield(strxpath, item)
		dim objnodelist, arrresponse(), i
		set objnodelist = objdoc.documentelement.selectnodes(strxpath)
		redim arrresponse(objnodelist.length)
		If objnodelist.length>0 Then
			if item=0 then
				for i = 0 to objnodelist.length - 1
				  arrresponse(i) = objnodelist.item(i).text
				next
				getfield = arrresponse
			else
				getfield = objnodelist.item(item-1).text
			end If
		End if
	end Function
	
	'获取节点的属性    参数：(节点路径、属性名、标识符)    其中标识符：0表示所有，非0表示第几个
	public function getattr(strxpath, attr, item)
		dim objnodelist, arrresponse(), i
		set objnodelist = objdoc.documentelement.selectnodes(strxpath)
		redim arrresponse(objnodelist.length)
		If objnodelist.length>0 Then
			if item=0 then
				for i = 0 to objnodelist.length - 1
				  arrresponse(i) = objnodelist.item(i).getAttribute(attr)
				next
				getattr = arrresponse
			else
				getattr = objnodelist.item(item-1).getAttribute(attr)
			end If
		End if
	end function

	'更新节点的值    参数：(节点路径、节点值、标识符)    其中标识符：0表示所有，非0表示第几个
	public function updatefield(strxpath, strdata, item)
		dim objnodelist, objfield
		set objnodelist = objdoc.documentelement.selectnodes(strxpath)
		If objnodelist.length>0 Then
			If item=0 Then
				for each objfield in objnodelist
					objfield.text = strdata
				next
			Else
				objnodelist.item(item-1).text = strdata
			End If
		End if
		set objfield = nothing
		updatefield = true
	end Function
	
	'更新节点的属性    参数：(节点路径、属性名、属性值、标识符）   其中标识符：0表示所有，非0表示第几个
	public function updateattr(strxpath, stritem, strval, item)
		dim objnodelist, objfield
		set objnodelist = objdoc.documentelement.selectnodes(strxpath)
		If objnodelist.length>0 Then
			if item=0 Then
				for each objfield in objnodelist
					objfield.setattribute stritem, strval
				next
			else
				objnodelist.item(item-1).setattribute stritem, strval
			end If
		End if
		set objfield = nothing
		updateattr = true
	end Function

	'创建根节点    参数：(节点名）
	public function createrootchild(strnode)
		dim objchild
		set objchild = objdoc.createnode(1, strnode, "")
		objdoc.documentelement.appendchild(objchild)
		set objchild = nothing
	end Function
	
	'创建带属性的根节点    参数：(节点名、属性名、属性值) 
	public function createrootnodewattr(strnode, attr, val)
		dim objchild, objattr
		set objchild = objdoc.createnode(1, strnode, "")
		if isarray(attr) and isarray(val) then
		  if ubound(attr)-lbound(attr) <> ubound(val)-lbound(val) then
			exit function
		  else
			dim i
			for i = lbound(attr) to ubound(attr)
			  set objattr = objdoc.createattribute(attr(i))
			  objchild.setattribute attr(i), val(i)
			next
		  end if
		else
		  set objattr = objdoc.createattribute(attr)
		  objchild.setattribute attr, val
		end if
		objdoc.documentelement.appendchild(objchild)
		set objchild = nothing
	end Function
	
	'创建子节点    参数：(上级节点路径、节点名、节点值、标识符）   其中标识符：0表示所有，非0表示第几个
	public function createchildnode(strxpath, strnode, strval, item)
		dim objnodelist, objparent, objchild
		set objnodelist = objdoc.documentelement.selectnodes(strxpath)
		If objnodelist.length>0 Then
			if item=0 then
				for each objparent in objnodelist
					set objchild = objdoc.createnode(1, strnode, "")
					objparent.appendchild(objchild)
					if strval<>"" then objchild.text = strval
				next
			else
				set objchild = objdoc.createnode(1, strnode, "")
				objnodelist.item(item-1).appendchild(objchild)
				if strval<>"" then objchild.text = strval
			end If
		end If
		set objparent = nothing
		set objchild = nothing
	end Function

	'创建子节点    参数：(上级节点路径、节点名、节点值、标识符）   其中标识符：0表示所有，非0表示第几个
	public function createchildnode_cdata(strxpath, strnode, strval, item)
		dim objnodelist, objparent, objchild, newCDATA	
		set objnodelist = objdoc.documentelement.selectnodes(strxpath)
		If objnodelist.length>0 Then
			if item=0 then
				for each objparent in objdoc.documentelement.selectnodes(strxpath)
					set objchild = objdoc.createnode(1, strnode, "")
					objparent.appendchild(objchild)
					Set newCDATA=objdoc.createCDATASection(strval)
					if strval<>"" then  objchild.appendChild(newCDATA)
				next
			else
				set objchild = objdoc.createnode(1, strnode, "")
				objnodelist.item(item-1).appendchild(objchild)
				set newCDATA = objdoc.createCDATASection(strval)
				if strval<>"" then  objchild.appendChild(newCDATA)
			end If
		end If
		set objparent = nothing
		set objchild = nothing
	end Function

	'创建带属性的子节点    参数：(上级节点路径、节点名、属性名、属性值）
	public function createchildnodewattr(strxpath, strnode, attr, val)
		dim objparent, objchild, objattr
		for each objparent in objdoc.documentelement.selectnodes(strxpath)
		  set objchild = objdoc.createnode(1, strnode, "")
		  if isarray(attr) and isarray(val) then
			if ubound(attr)-lbound(attr) <> ubound(val)-lbound(val) then
			  exit function
			else
			  dim i
			  for i = lbound(attr) to ubound(attr)
				set objattr = objdoc.createattribute(attr(i))
				objchild.setattribute attr(i), val(i)
			  next
			end if
		  else
			set objattr = objdoc.createattribute(attr)
			objchild.setattribute attr, val
		  end if
		  objparent.appendchild(objchild)
		next
		set objparent = nothing
		set objchild = nothing
	end Function
	
	'删除节点    参数：(节点路径、匹配值）
	public function deletenode(strxpath)
		dim objnodelist, objold
		for each objold in objdoc.documentelement.selectnodes(strxpath)
			objold.parentnode.removechild objold
		next
		set objold = nothing
	end function
end class
%>