﻿<%
''' EYCMS 图片水印
''' ==================================================================

class eycms_draw
	private jpeg_name,jpeg_type,jpeg_text,jpeg_textcolor,jpeg_textfont,jpeg_fontsize,jpeg_bold
	private jpeg_photo,jpeg_bgcolor
	private jpeg_minwidth,jpeg_minheight,jpeg_transparent,jpeg_quality,jpeg_position
	private aspjpeg,logobox,draw_x,draw_y
	
	private sub class_initialize()
		jpeg_name=eycms.getsys("jpeg_name")
		jpeg_type=eycms.getsys("jpeg_type")
		jpeg_text=eycms.getsys("jpeg_text")
		jpeg_textcolor=eycms.getsys("jpeg_textcolor")
		jpeg_textcolor="&H"&replace(jpeg_textcolor,"#","")
		jpeg_textfont=eycms.getsys("jpeg_textfont")
		jpeg_fontsize=eycms.getsys("jpeg_fontsize")
		jpeg_bold=eycms.iif(eycms.getsys("jpeg_bold")="true",true,false)
		
		jpeg_photo=eycms.getsys("jpeg_photo")
		jpeg_bgcolor=eycms.getsys("jpeg_bgcolor")
		jpeg_bgcolor="&H"&replace(jpeg_bgcolor,"#","")
		
		jpeg_minwidth=eycms.getsys("jpeg_minwidth")
		jpeg_minheight=eycms.getsys("jpeg_minheight")
		jpeg_transparent=eycms.getsys("jpeg_transparent")
		jpeg_quality=eycms.getsys("jpeg_quality")
		jpeg_position=getrndnum(eycms.getsys("jpeg_position"))	
		if eycms.isinstall("persits.jpeg") Then
			set aspjpeg=server.createObject("persits.jpeg")
			set logobox=server.createobject("persits.jpeg")
		End if
	end sub
	
	private sub class_terminate
		set aspjpeg=nothing
		set logobox=nothing
	end sub
	
	public function cut(byval t0,byval t1,byval t2,byval t3)
		Dim picname,picExt
		Dim x, y, x1, y1
		if jpeg_name = "" then cut=t0:exit Function
		if not(eycms.isinstall("persits.jpeg")) then exit Function
		if not(eycms.isfile(t0)) then cut=t0:exit function
		aspjpeg.open server.mappath(t0)
		If InStr(t0,"/")>0 Then picname=split(t0,"/")(ubound(split(t0,"/")))
		picExt="jpg"
		If t3="cover" Or t3="crop" Then picExt=mid(picname,instrrev(picname,".")+1)
		picname=left(picname,instr(picname,".")) & picExt

		If t3="cover" Then
			if aspjpeg.OriginalHeight > aspjpeg.OriginalWidth And aspjpeg.OriginalHeight > t2 then 
				aspjpeg.Height = t2
				aspjpeg.Width = aspjpeg.OriginalWidth/(aspjpeg.OriginalHeight/t2)
			end If
			if aspjpeg.OriginalWidth >= aspjpeg.OriginalHeight And aspjpeg.OriginalWidth > t1 then 
				aspjpeg.Width = t1
				aspjpeg.Height = aspjpeg.OriginalHeight/(aspjpeg.OriginalWidth/t1)
			end If
			t3=split(t0,picname)(0)
			aspjpeg.Save (Server.MapPath(t3) & "\" & picname)
		Else
			If t2 > 0 Then
				if aspjpeg.OriginalWidth >= aspjpeg.OriginalHeight then 
					aspjpeg.Width = t1
					aspjpeg.Height = aspjpeg.OriginalHeight/(aspjpeg.OriginalWidth/t1)
				end If
				if aspjpeg.OriginalHeight > aspjpeg.OriginalWidth then 
					aspjpeg.Height = t1
					aspjpeg.Width = aspjpeg.OriginalWidth/(aspjpeg.OriginalHeight/t1)
				end If
			Else
				aspjpeg.Width = t1
				aspjpeg.Height = aspjpeg.OriginalHeight/(aspjpeg.OriginalWidth/t1)
				t2 = aspjpeg.OriginalHeight/(aspjpeg.OriginalWidth/t1)
			End If
			x = CInt((aspjpeg.Width - t1)/2)
			y = CInt((aspjpeg.Height - t1)/2)
			x1 = x + t1
			y1 = y + t2
			aspjpeg.Canvas.Brush.Color = &HFFFFFF
			aspjpeg.quality = jpeg_quality 
			aspjpeg.Crop x,y,x1,y1   '切割处理
			If t3="crop" Then t3=split(t0,picname)(0)
			aspjpeg.Save (Server.MapPath(t3) & "\" & picname)
		End if
		cut = t3 & picname
	end Function

	public sub add(byval t0)
		if jpeg_name="" then exit sub
		if not(eycms.isinstall("persits.jpeg")) then  exit sub
		set aspjpeg=server.createObject("persits.jpeg")
		set logobox=server.createobject("persits.jpeg")
		if not(eycms.isfile(t0)) then exit sub
		aspjpeg.open server.mappath(t0)
		if not(aspjpeg.originalwidth>=clng(jpeg_minwidth) or aspjpeg.originalheight>=clng(jpeg_minheight)) then exit sub
		
		if jpeg_type="true" then
			jpeg_minwidth=(jpeg_fontsize+1)*getstrlen(jpeg_text)/2
			jpeg_minheight=jpeg_fontsize+1
			draw_x=drawimage_x(aspjpeg.originalwidth,jpeg_minwidth,10)
			draw_y=drawimage_y(aspjpeg.originalheight,jpeg_minheight,10)
			aspjpeg.canvas.font.color		=jpeg_textcolor	    
			aspjpeg.canvas.font.family		=jpeg_textfont      
			aspjpeg.canvas.font.bold		=jpeg_bold          
			aspjpeg.canvas.font.size		=jpeg_fontsize	    
			aspjpeg.canvas.print draw_x,draw_y,jpeg_text	    
			aspjpeg.canvas.pen.color		=&H000000		   
			aspjpeg.canvas.pen.width		=0				    
			aspjpeg.canvas.brush.solid	    =false			    
			aspjpeg.quality=jpeg_quality                        
			aspjpeg.save server.mappath(t0)
		else
			if jpeg_photo="" then exit sub
			if not(eycms.isfile(jpeg_photo)) then exit sub
			logobox.open server.mappath(jpeg_photo)
			logobox.width=logobox.originalwidth							                  
			logobox.height=logobox.Originalheight   						              
			draw_x=drawimage_x(aspjpeg.originalwidth,logobox.originalwidth,10)
			draw_y=drawimage_y(aspjpeg.originalheight,logobox.Originalheight,10)
			if instr(lcase(jpeg_photo),".png")>0 then
				aspjpeg.canvas.drawpng draw_x,draw_y,server.mappath(jpeg_photo)
				aspjpeg.quality=jpeg_quality
				aspjpeg.save server.mappath(t0)
			else
				aspjpeg.drawimage draw_x,draw_y,logobox,jpeg_transparent,jpeg_bgcolor,100
				aspjpeg.quality=jpeg_quality                                                  
				aspjpeg.save server.mappath(t0)
			end if
			
		end if
	end sub
	
	function drawimage_x(byval t0,byval t1,byval t2)
		select case jpeg_position
			case "0"
				drawimage_x=t2
			case "1"
				drawimage_x=t2
			case "2"
				drawimage_x=(t0-t1)/2
			case "3"
				drawimage_x=t0-t1-t2
			case "4"
				drawimage_x=t0-t1-t2
			case else
				drawimage_x=0
		end select
	end function

	function drawimage_y(byval t0,byval t1,byval t2)
		select case jpeg_position
			case "0"
				drawimage_y=t2
			case "1"
				drawimage_y=t0-t1-t2
			case "2"
				drawimage_y=(t0-t1)/2
			case "3"
				drawimage_y=t2
			case "4"
				drawimage_y=t0-t1-t2
			case else
				drawimage_y=0
		end select
	end function
	
	function getstrlen(byval t0)
		dim t1,c,i
		if isnull(t0) then getstrlen=0:exit function
		t1=0
		for i=1 to len(t0)
			c=ascw(mid(t0,i,1))
			if c<0 or c>255 then t1=t1+2 else t1=t1+1
		next
		getstrlen=t1
	end function
	
	function getrndnum(byval t0)
		if t0="5" then
			randomize
			getrndnum=int(5*rnd)
		else
			getrndnum=t0
		end if
	end function
end class
%>
