
$(function(){
    $("#beautify").click(function () {
        var js_source, tabsize, tabchar;
        document.getElementById('beautify').disabled = true;
        js_source = editor.getValue().replace(/^\s+/, '');
        tabsize = 4;
        tabchar = ' ';
        if (tabsize == 1) {
            tabchar = '\t';
        }
        var regEmptyTag = /(<([^\/][^>|^\/>].*)>)(\s*)?(<\/([^>]*)>)/g;
        var c = "";
        if ($("#ext").val() === '.asp') {
            c = style_html(js_source, tabsize, tabchar, 80);
            c = c.replace(/\n\s*<>/g, '<>');
            c = c.replace(/{dim/g, '\n{dim');
            c = c.replace(/\n\s*<img/g, '<img');
            c = c.replace(/\n\s*<font/g, '<font');
            c = c.replace(/\n\s*<i>/g, '<i>');
            c = c.replace(/\n\s*\.html/g, '\.html');
            c = c.replace(/([1-8]{1})\n\s*">/g, '$1">');
            c = c.replace(/>{eycms:include/g, '>\n{eycms:include');
        } else {
            c = js_beautify(js_source, tabsize, tabchar);
            c = c.replace(/:\n\s*"/g, ':"');
            c = c.replace(/:\n\s*\'/g, ':\'');
            c = c.replace(/,\n\s*function/g, ',function');
            c = c.replace(/}\)\s*\$\(/g, '}\)\n$\(');
        }
        editor.setValue(c.replace(regEmptyTag, '$1$4'));
        document.getElementById('beautify').disabled = false;
        return false;
    });
    $("#pack0").click(function (base64) {
        pack_js(0);
    });
    $("#pack1").click(function (base64) {
        pack_js(1);
    });
    function pack_js(base64) {
        var input = editor.getValue();
        var packer = new Packer;
        if (base64) {
            var output = packer.pack(input, 1, 0);
        } else {
            var output = packer.pack(input, 0, 0);
        }
        output = output.replace(/}\)\s*\$\(/g, '}\)\n$\(');
        editor.setValue(output);
    }
})
